/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.userconfiguration;

import com.openexchange.capabilities.Capability;
import com.openexchange.capabilities.CapabilityService;
import com.openexchange.capabilities.CapabilitySet;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.java.Strings;
import com.openexchange.server.services.ServerServiceRegistry;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class CapabilityUserConfigurationStorage
extends UserConfigurationStorage {
    @Override
    protected void startInternal() {
    }

    @Override
    protected void stopInternal() {
    }

    @Override
    public UserConfiguration getUserConfiguration(int userId, int[] groups, Context ctx) throws OXException {
        return CapabilityUserConfigurationStorage.loadUserConfiguration(userId, groups, ctx);
    }

    @Override
    public UserConfiguration[] getUserConfiguration(Context ctx, User[] users) throws OXException {
        return CapabilityUserConfigurationStorage.loadUserConfiguration(ctx, users);
    }

    @Override
    public void clearStorage() {
    }

    @Override
    public void invalidateCache(int userId, Context ctx) {
    }

    public static UserConfiguration loadUserConfiguration(int userId, Context ctx) throws OXException {
        return CapabilityUserConfigurationStorage.loadUserConfiguration(userId, null, ctx);
    }

    private static Set<String> getCapabilities(int userId, int cid) throws OXException {
        CapabilityService capabilityService = ServerServiceRegistry.getInstance().getService(CapabilityService.class);
        if (capabilityService == null) {
            return new HashSet<String>();
        }
        return CapabilityUserConfigurationStorage.stringify(capabilityService.getCapabilities(userId, cid));
    }

    private static Set<String> stringify(CapabilitySet capabilities) {
        HashSet<String> set = new HashSet<String>(capabilities.size());
        for (Capability capability : capabilities) {
            set.add(Strings.toLowerCase((CharSequence)capability.getId()));
        }
        return set;
    }

    public static UserConfiguration loadUserConfiguration(int userId, int[] groupsArg, Context ctx) throws OXException {
        int[] groups = groupsArg == null ? UserStorage.getInstance().getUser(userId, ctx).getGroups() : groupsArg;
        UserStorage.getInstance().getUser(userId, ctx);
        UserConfiguration userConfiguration = new UserConfiguration(CapabilityUserConfigurationStorage.getCapabilities(userId, ctx.getContextId()), userId, groups, ctx);
        return userConfiguration;
    }

    public static UserConfiguration[] loadUserConfiguration(Context ctx, User[] users) throws OXException {
        UserConfiguration[] retval = new UserConfiguration[users.length];
        for (int i = 0; i < users.length; ++i) {
            UserConfiguration userConfiguration;
            User user = users[i];
            retval[i] = userConfiguration = new UserConfiguration(CapabilityUserConfigurationStorage.getCapabilities(user.getId(), ctx.getContextId()), user.getId(), user.getGroups(), ctx);
        }
        return retval;
    }

    @Override
    public UserConfiguration[] getUserConfigurations(Context ctx, int[] userIds, int[][] groups) throws OXException {
        if (0 == userIds.length) {
            return new UserConfiguration[0];
        }
        return CapabilityUserConfigurationStorage.loadUserConfigurations(ctx, userIds, groups);
    }

    private static UserConfiguration[] loadUserConfigurations(Context ctx, int[] userIds, int[][] groupsArg) throws OXException {
        ArrayList<UserConfiguration> list = new ArrayList<UserConfiguration>(userIds.length);
        for (int i = 0; i < userIds.length; ++i) {
            int userId = userIds[i];
            int[] groups = groupsArg[i] == null ? UserStorage.getInstance().getUser(userId, ctx).getGroups() : groupsArg[i];
            list.add(new UserConfiguration(CapabilityUserConfigurationStorage.getCapabilities(userId, ctx.getContextId()), userId, groups, ctx));
        }
        return list.toArray(new UserConfiguration[userIds.length]);
    }
}

