/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.database.DatabaseService;
import com.openexchange.database.Databases;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Attributes;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.TaskAttributes;
import com.openexchange.groupware.update.UpdateConcurrency;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskV2;
import com.openexchange.server.services.ServerServiceRegistry;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RemoveFacebookAccountsTask
implements UpdateTaskV2 {
    private static final String OAUTH_ID = "com.openexchange.oauth.facebook";
    private static final String MESSAGING_ID = "com.openexchange.messaging.facebook";

    @Override
    public void perform(PerformParameters params) throws OXException {
        int contextId = params.getContextId();
        DatabaseService ds = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        Connection con = ds.getForUpdateTask(contextId);
        PreparedStatement stmt = null;
        try {
            con.setAutoCommit(false);
            this.removeOAuthAccounts(stmt, con);
            this.removeMessagingAccounts(stmt, con);
            con.commit();
        }
        catch (SQLException x) {
            throw UpdateExceptionCodes.SQL_PROBLEM.create(x, x.getMessage());
        }
        finally {
            Databases.closeSQLStuff(stmt);
            if (con != null) {
                ds.backForUpdateTask(contextId, con);
            }
        }
    }

    private void removeOAuthAccounts(PreparedStatement stmt, Connection con) throws SQLException {
        if (!Databases.tablesExist((Connection)con, (String[])new String[]{"oauthAccounts"})) {
            return;
        }
        stmt = con.prepareStatement("DELETE FROM oauthAccounts WHERE serviceId = ? ;");
        stmt.setString(1, OAUTH_ID);
        stmt.executeUpdate();
        stmt.close();
    }

    private void removeMessagingAccounts(PreparedStatement stmt, Connection con) throws OXException {
        List<int[]> dataList = this.listFacebookMessagingAccounts(stmt, con);
        for (int[] data : dataList) {
            this.dropAccountByData(stmt, data, con);
        }
    }

    private List<int[]> listFacebookMessagingAccounts(PreparedStatement stmt, Connection con) throws OXException {
        ArrayList<int[]> arrayList;
        ResultSet rs;
        block6: {
            rs = null;
            stmt = con.prepareStatement("SELECT account, confId, user, cid FROM messagingAccount WHERE serviceId = ?");
            stmt.setString(1, MESSAGING_ID);
            rs = stmt.executeQuery();
            if (rs.next()) break block6;
            List<int[]> list = Collections.emptyList();
            Databases.closeSQLStuff((ResultSet)rs);
            return list;
        }
        try {
            ArrayList<int[]> dataList = new ArrayList<int[]>(64);
            do {
                int[] data = new int[]{rs.getInt(1), rs.getInt(2), rs.getInt(3), rs.getInt(4)};
                dataList.add(data);
            } while (rs.next());
            stmt.close();
            arrayList = dataList;
        }
        catch (SQLException e) {
            try {
                throw this.createSQLError(e);
            }
            catch (Throwable throwable) {
                Databases.closeSQLStuff(rs);
                throw throwable;
            }
        }
        Databases.closeSQLStuff((ResultSet)rs);
        return arrayList;
    }

    private void dropAccountByData(PreparedStatement stmt, int[] data, Connection writeCon) throws OXException {
        try {
            stmt = writeCon.prepareStatement("DELETE FROM genconf_attributes_strings WHERE cid = ? AND id = ?");
            stmt.setInt(1, data[3]);
            stmt.setInt(2, data[1]);
            stmt.executeUpdate();
            stmt.close();
            stmt = writeCon.prepareStatement("DELETE FROM messagingAccount WHERE cid = ? AND user = ? AND serviceId = ? AND account = ?");
            stmt.setInt(1, data[3]);
            stmt.setInt(2, data[2]);
            stmt.setString(3, MESSAGING_ID);
            stmt.setInt(4, data[0]);
            stmt.executeUpdate();
            stmt.close();
        }
        catch (SQLException e) {
            throw this.createSQLError(e);
        }
    }

    private OXException createSQLError(SQLException e) {
        return UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
    }

    @Override
    public String[] getDependencies() {
        return new String[0];
    }

    @Override
    public TaskAttributes getAttributes() {
        return new Attributes(UpdateConcurrency.BACKGROUND);
    }
}

