/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.database.Databases;
import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.ProgressState;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.groupware.update.tasks.AddUUIDForUserAttributeTable;
import com.openexchange.java.util.UUIDs;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Column;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.UUID;

public class MakeUUIDPrimaryForUserAttributeTable
extends UpdateTaskAdapter {
    @Override
    public void perform(PerformParameters params) throws OXException {
        ProgressState progress = params.getProgressState();
        Connection con = Database.getNoTimeout(params.getContextId(), true);
        try {
            DBUtils.startTransaction(con);
            progress.setTotal(MakeUUIDPrimaryForUserAttributeTable.getTotalRows(con));
            if (!Tools.columnExists(con, "user_attribute", "uuid")) {
                throw UpdateExceptionCodes.COLUMN_NOT_FOUND.create("uuid");
            }
            AddUUIDForUserAttributeTable.fillUUIDs(con, progress);
            this.dropDuplicates(con);
            String foreignKey = Tools.existsForeignKey(con, "user", new String[]{"cid", "id"}, "user_attribute", new String[]{"cid", "id"});
            if (null != foreignKey && !foreignKey.equals("")) {
                Tools.dropForeignKey(con, "user_attribute", foreignKey);
            }
            this.dropOrphaned(con);
            Tools.modifyColumns(con, "user_attribute", new Column("uuid", "BINARY(16) NOT NULL"));
            Tools.createPrimaryKeyIfAbsent(con, "user_attribute", new String[]{"cid", "uuid"});
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            Database.backNoTimeout(params.getContextId(), true, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropOrphaned(Connection con) throws SQLException {
        ResultSet rs;
        PreparedStatement stmt;
        block5: {
            stmt = null;
            rs = null;
            stmt = con.prepareStatement("SELECT attrs.cid, attrs.id, hex(uuid) FROM user_attribute AS attrs LEFT JOIN user ON attrs.cid = user.cid AND attrs.id = user.id WHERE user.id IS NULL");
            rs = stmt.executeQuery();
            if (rs.next()) break block5;
            Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
            return;
        }
        try {
            class Orphaned {
                final UUID uuid;
                final int cid;
                final int user;

                Orphaned(int cid, int user, UUID uuid) {
                    this.cid = cid;
                    this.user = user;
                    this.uuid = uuid;
                }
            }
            LinkedList<Orphaned> orphaneds = new LinkedList<Orphaned>();
            do {
                orphaneds.add(new Orphaned(rs.getInt(1), rs.getInt(2), UUIDs.fromUnformattedString((String)rs.getString(3))));
            } while (rs.next());
            Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
            rs = null;
            stmt = null;
            for (Orphaned orphaned : orphaneds) {
                stmt = con.prepareStatement("DELETE FROM user_attribute WHERE cid=? AND id=? AND ?=HEX(uuid)");
                stmt.setInt(1, orphaned.cid);
                stmt.setInt(2, orphaned.user);
                stmt.setString(3, UUIDs.getUnformattedString((UUID)orphaned.uuid));
                stmt.executeUpdate();
                Databases.closeSQLStuff((Statement)stmt);
                stmt = null;
            }
        }
        catch (Throwable throwable) {
            Databases.closeSQLStuff(rs, (Statement)stmt);
            throw throwable;
        }
        Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropDuplicates(Connection con) throws SQLException {
        ResultSet rs;
        PreparedStatement stmt;
        block6: {
            stmt = null;
            rs = null;
            stmt = con.prepareStatement("SELECT cid, HEX(uuid) FROM user_attribute GROUP BY cid, uuid HAVING count(*) > 1");
            rs = stmt.executeQuery();
            if (rs.next()) break block6;
            Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
            return;
        }
        try {
            class Dup {
                final UUID uuid;
                final int cid;

                Dup(int cid, UUID uuid) {
                    this.cid = cid;
                    this.uuid = uuid;
                }
            }
            LinkedList<Dup> dups = new LinkedList<Dup>();
            do {
                dups.add(new Dup(rs.getInt(1), UUIDs.fromUnformattedString((String)rs.getString(2))));
            } while (rs.next());
            Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
            rs = null;
            stmt = null;
            for (Dup dup : dups) {
                stmt = con.prepareStatement("SELECT cid, id, name, value FROM user_attribute WHERE cid=? AND ?=HEX(uuid)");
                stmt.setInt(1, dup.cid);
                stmt.setString(2, UUIDs.getUnformattedString((UUID)dup.uuid));
                rs = stmt.executeQuery();
                if (rs.next()) {
                    int cid = rs.getInt(1);
                    int id = rs.getInt(2);
                    String name = rs.getString(3);
                    String value = rs.getString(4);
                    Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
                    rs = null;
                    stmt = null;
                    stmt = con.prepareStatement("DELETE FROM user_attribute WHERE cid=? AND ?=HEX(uuid)");
                    stmt.setInt(1, dup.cid);
                    stmt.setString(2, UUIDs.getUnformattedString((UUID)dup.uuid));
                    stmt.executeUpdate();
                    Databases.closeSQLStuff((Statement)stmt);
                    stmt = null;
                    stmt = con.prepareStatement("INSERT INTO user_attribute (cid,id,name,value,uuid) VALUES (?,?,?,?,UNHEX(?))");
                    stmt.setInt(1, cid);
                    stmt.setInt(2, id);
                    stmt.setString(3, name);
                    stmt.setString(4, value);
                    stmt.setString(5, UUIDs.getUnformattedString((UUID)dup.uuid));
                    stmt.executeUpdate();
                    Databases.closeSQLStuff((Statement)stmt);
                    stmt = null;
                }
                Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
                rs = null;
                stmt = null;
            }
        }
        catch (Throwable throwable) {
            Databases.closeSQLStuff(rs, (Statement)stmt);
            throw throwable;
        }
        Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
    }

    @Override
    public String[] getDependencies() {
        return new String[]{AddUUIDForUserAttributeTable.class.getName()};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getTotalRows(Connection con) throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        int rows = 0;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery("SELECT COUNT(*) FROM user_attribute WHERE uuid IS NULL");
            while (rs.next()) {
                rows += rs.getInt(1);
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(rs, stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return rows;
    }
}

