/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.groupware.update.tasks.InfostoreDocumentDropForeignKeyUpdateTask;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.SQLException;

public class InfostorePrimaryKeyUpdateTask
extends UpdateTaskAdapter {
    private static final String INFOSTORE = "infostore";
    private static final String INFOSTORE_DOCUMENT = "infostore_document";

    @Override
    public void perform(PerformParameters params) throws OXException {
        int cid = params.getContextId();
        Connection con = Database.getNoTimeout(cid, true);
        try {
            con.setAutoCommit(false);
            String foreignKey = Tools.existsForeignKey(con, INFOSTORE, new String[]{"cid", "id"}, INFOSTORE_DOCUMENT, new String[]{"cid", "infostore_id"});
            if (null != foreignKey && !foreignKey.equals("")) {
                Tools.dropForeignKey(con, INFOSTORE_DOCUMENT, foreignKey);
            }
            if (Tools.hasPrimaryKey(con, INFOSTORE)) {
                Tools.dropPrimaryKey(con, INFOSTORE);
                Tools.createPrimaryKey(con, INFOSTORE, new String[]{"cid", "id", "folder_id"});
            }
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.OTHER_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            Database.backNoTimeout(cid, true, con);
        }
    }

    @Override
    public String[] getDependencies() {
        return new String[]{InfostoreDocumentDropForeignKeyUpdateTask.class.getName()};
    }
}

