/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Attributes;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.ProgressState;
import com.openexchange.groupware.update.TaskAttributes;
import com.openexchange.groupware.update.UpdateConcurrency;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.groupware.update.WorkingLevel;
import com.openexchange.groupware.update.tasks.DropIndividualUserPermissionsOnPublicFolderTask;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FolderPermissionAddGuestGroup
extends UpdateTaskAdapter {
    private static int[] systemFolderIDs = new int[]{1, 3, 9, 10, 2, 15};
    private static Logger log = LoggerFactory.getLogger(FolderPermissionAddGuestGroup.class);

    @Override
    public String[] getDependencies() {
        return new String[]{DropIndividualUserPermissionsOnPublicFolderTask.class.getName()};
    }

    @Override
    public TaskAttributes getAttributes() {
        return new Attributes(UpdateConcurrency.BLOCKING, WorkingLevel.SCHEMA);
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        log.info("Performing update task {}", (Object)FolderPermissionAddGuestGroup.class.getSimpleName());
        ProgressState progress = params.getProgressState();
        Connection connection = Database.getNoTimeout(params.getContextId(), true);
        boolean committed = false;
        try {
            connection.setAutoCommit(false);
            int[] contextIDs = Database.getContextsInSameSchema(params.getContextId());
            progress.setTotal(contextIDs.length);
            for (int i = 0; i < contextIDs.length; ++i) {
                progress.setState(i);
                FolderPermissionAddGuestGroup.insertGroupPermission(connection, contextIDs[i]);
            }
            connection.commit();
            committed = true;
        }
        catch (SQLException e) {
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw UpdateExceptionCodes.OTHER_PROBLEM.create(e, e.getMessage());
        }
        finally {
            if (!committed) {
                DBUtils.rollback(connection);
            }
            DBUtils.autocommit(connection);
            Database.backNoTimeout(params.getContextId(), true, connection);
        }
        log.info("{} successfully performed.", (Object)FolderPermissionAddGuestGroup.class.getSimpleName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int[] insertGroupPermission(Connection connection, int contextID) throws SQLException, OXException {
        PreparedStatement stmt = null;
        try {
            stmt = connection.prepareStatement("INSERT INTO oxfolder_permissions (cid,fuid,permission_id,fp,orp,owp,odp,admin_flag,group_flag,system) VALUES (?,?,?,?,?,?,?,?,?,?) ON DUPLICATE KEY UPDATE fp=?,orp=?,owp=?,odp=?,admin_flag=?,group_flag=?,system=?;");
            stmt.setInt(1, contextID);
            stmt.setInt(3, Integer.MAX_VALUE);
            stmt.setInt(4, 2);
            stmt.setInt(5, 0);
            stmt.setInt(6, 0);
            stmt.setInt(7, 0);
            stmt.setInt(8, 0);
            stmt.setInt(9, 1);
            stmt.setInt(10, 0);
            stmt.setInt(11, 2);
            stmt.setInt(12, 0);
            stmt.setInt(13, 0);
            stmt.setInt(14, 0);
            stmt.setInt(15, 0);
            stmt.setInt(16, 1);
            stmt.setInt(17, 0);
            for (int folderID : systemFolderIDs) {
                if (FolderPermissionAddGuestGroup.systemFolderExist(connection, contextID, folderID)) {
                    stmt.setInt(2, folderID);
                    stmt.addBatch();
                    continue;
                }
                log.warn("System folder {} not found in context {}, skipping.", (Object)folderID, (Object)contextID);
            }
            int[] nArray = stmt.executeBatch();
            return nArray;
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    private static boolean systemFolderExist(Connection con, int contextId, int fuid) throws OXException {
        boolean bl;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement("SELECT 1 FROM oxfolder_tree WHERE cid = ? AND fuid = ?");
            stmt.setInt(1, contextId);
            stmt.setInt(2, fuid);
            rs = stmt.executeQuery();
            bl = rs.next();
        }
        catch (SQLException e) {
            try {
                throw UpdateExceptionCodes.SQL_PROBLEM.create(e, new Object[0]);
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return bl;
    }
}

