/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Attributes;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.TaskAttributes;
import com.openexchange.groupware.update.UpdateConcurrency;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.groupware.update.tasks.FolderExtendNameTask;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FolderInheritTrashFolderTypeTask
extends UpdateTaskAdapter {
    @Override
    public String[] getDependencies() {
        return new String[]{FolderExtendNameTask.class.getName()};
    }

    @Override
    public TaskAttributes getAttributes() {
        return new Attributes(UpdateConcurrency.BLOCKING);
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        Logger log = LoggerFactory.getLogger(FolderInheritTrashFolderTypeTask.class);
        log.info("Performing update task {}", (Object)FolderInheritTrashFolderTypeTask.class.getSimpleName());
        Connection connection = Database.getNoTimeout(params.getContextId(), true);
        boolean rollback = false;
        try {
            connection.setAutoCommit(false);
            rollback = true;
            List<Integer> trashFolderIDs = FolderInheritTrashFolderTypeTask.getDefaultTrashFolderIDs(connection, params.getContextId());
            for (Integer trashFolderID : trashFolderIDs) {
                List<Integer> subfolderIDs = FolderInheritTrashFolderTypeTask.getSubfolderIDsRecursively(connection, params.getContextId(), trashFolderID);
                FolderInheritTrashFolderTypeTask.updateFolderType(connection, params.getContextId(), 16, subfolderIDs);
            }
            connection.commit();
            rollback = false;
        }
        catch (SQLException e) {
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw UpdateExceptionCodes.OTHER_PROBLEM.create(e, e.getMessage());
        }
        finally {
            if (rollback) {
                DBUtils.rollback(connection);
            }
            DBUtils.autocommit(connection);
            Database.backNoTimeout(params.getContextId(), true, connection);
        }
        log.info("{} successfully performed.", (Object)FolderInheritTrashFolderTypeTask.class.getSimpleName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Integer> getDefaultTrashFolderIDs(Connection connection, int contextID) throws SQLException {
        ArrayList<Integer> trashFolderIDs = new ArrayList<Integer>();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = connection.prepareStatement("SELECT fuid FROM oxfolder_tree WHERE cid=? AND type=16 AND default_flag=1;");
            stmt.setInt(1, contextID);
            rs = stmt.executeQuery();
            while (rs.next()) {
                trashFolderIDs.add(rs.getInt(1));
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(rs, stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return trashFolderIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Integer> getSubfolderIDsRecursively(Connection connection, int contextID, int folderID) throws SQLException {
        ArrayList<Integer> subfolderIDs = new ArrayList<Integer>();
        ArrayList<Integer> parentFolderIDs = new ArrayList<Integer>();
        parentFolderIDs.add(folderID);
        do {
            StringBuilder stringBuilder = new StringBuilder("SELECT fuid FROM oxfolder_tree WHERE cid=? AND parent");
            if (1 == parentFolderIDs.size()) {
                stringBuilder.append("=?;");
            } else {
                stringBuilder.append(" IN (?");
                for (int i = 1; i < parentFolderIDs.size(); ++i) {
                    stringBuilder.append(",?");
                }
                stringBuilder.append(");");
            }
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                stmt = connection.prepareStatement(stringBuilder.toString());
                stmt.setInt(1, contextID);
                for (int i = 0; i < parentFolderIDs.size(); ++i) {
                    stmt.setInt(i + 2, (Integer)parentFolderIDs.get(i));
                }
                parentFolderIDs.clear();
                rs = stmt.executeQuery();
                while (rs.next()) {
                    Integer id = rs.getInt(1);
                    subfolderIDs.add(id);
                    parentFolderIDs.add(id);
                }
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                throw throwable;
            }
            DBUtils.closeSQLStuff(rs, stmt);
        } while (!parentFolderIDs.isEmpty());
        return subfolderIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int updateFolderType(Connection connection, int contextID, int type, List<Integer> folderIDs) throws SQLException {
        int n;
        if (null == folderIDs || 0 == folderIDs.size()) {
            return 0;
        }
        PreparedStatement stmt = null;
        try {
            int i;
            StringBuilder stringBuilder = new StringBuilder("UPDATE oxfolder_tree SET type=? WHERE cid=? AND fuid");
            if (1 == folderIDs.size()) {
                stringBuilder.append("=?;");
            } else {
                stringBuilder.append(" IN (?");
                for (i = 1; i < folderIDs.size(); ++i) {
                    stringBuilder.append(",?");
                }
                stringBuilder.append(");");
            }
            stmt = connection.prepareStatement(stringBuilder.toString());
            stmt.setInt(1, type);
            stmt.setInt(2, contextID);
            for (i = 0; i < folderIDs.size(); ++i) {
                stmt.setInt(i + 3, folderIDs.get(i));
            }
            n = stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff(stmt);
        return n;
    }
}

