/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalendarAddIndex2DatesMembers
extends UpdateTaskAdapter {
    @Override
    public String[] getDependencies() {
        return new String[0];
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        int contextId = params.getContextId();
        Connection con = Database.getNoTimeout(contextId, true);
        try {
            con.setAutoCommit(false);
            this.createMyIndex(con, new String[]{"prg_dates_members", "del_dates_members"}, "pfid", "givenname");
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw CalendarAddIndex2DatesMembers.createSQLError(e);
        }
        catch (RuntimeException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.OTHER_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            Database.backNoTimeout(contextId, true, con);
        }
    }

    private void createMyIndex(Connection con, String[] tables, String fieldName, String name) {
        Logger log = LoggerFactory.getLogger(CalendarAddIndex2DatesMembers.class);
        String[] columns = new String[]{"cid", fieldName};
        for (String table : tables) {
            try {
                String indexName = Tools.existsIndex(con, table, columns);
                if (null == indexName) {
                    log.info("Creating new index named \"{}\" with columns (cid,{}) on table {}.", new Object[]{name, fieldName, table});
                    Tools.createIndex(con, table, name, columns, false);
                    continue;
                }
                log.info("New index named \"{}\" with columns (cid,{}) already exists in table {}.", new Object[]{indexName, fieldName, table});
            }
            catch (SQLException e) {
                log.error("Problem adding index {} on table {}.", new Object[]{name, table, e});
            }
        }
    }

    private static OXException createSQLError(SQLException e) {
        return UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
    }
}

