/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.ProgressState;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.java.util.UUIDs;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Column;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;

public class AddUUIDForUserAttributeTable
extends UpdateTaskAdapter {
    @Override
    public void perform(PerformParameters params) throws OXException {
        int ctxId = params.getContextId();
        ProgressState progress = params.getProgressState();
        Connection con = Database.getNoTimeout(ctxId, true);
        try {
            DBUtils.startTransaction(con);
            progress.setTotal(AddUUIDForUserAttributeTable.getTotalRows(con));
            if (!Tools.columnExists(con, "user_attribute", "uuid")) {
                Tools.addColumns(con, "user_attribute", new Column("uuid", "BINARY(16) DEFAULT NULL"));
                AddUUIDForUserAttributeTable.fillUUIDs(con, progress);
            }
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            Database.backNoTimeout(ctxId, true, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillUUIDs(Connection con, ProgressState progress) throws SQLException {
        Statement stmt1 = null;
        ResultSet result = null;
        PreparedStatement stmt2 = null;
        try {
            stmt1 = con.createStatement();
            result = stmt1.executeQuery("SELECT cid, id, name, value FROM user_attribute WHERE uuid IS NULL");
            stmt2 = con.prepareStatement("UPDATE user_attribute SET uuid=? WHERE cid=? AND id=? AND name=? AND value=?");
            while (result.next()) {
                int cid = result.getInt(1);
                int userId = result.getInt(2);
                String name = result.getString(3);
                String value = result.getString(4);
                stmt2.setBytes(1, UUIDs.toByteArray((UUID)UUID.randomUUID()));
                stmt2.setInt(2, cid);
                stmt2.setInt(3, userId);
                stmt2.setString(4, name);
                stmt2.setString(5, value);
                stmt2.addBatch();
                progress.incrementState();
            }
            stmt2.executeBatch();
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(result, stmt1);
            DBUtils.closeSQLStuff(stmt2);
            throw throwable;
        }
        DBUtils.closeSQLStuff(result, stmt1);
        DBUtils.closeSQLStuff(stmt2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getTotalRows(Connection con) throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        int rows = 0;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery("SELECT COUNT(*) FROM user_attribute");
            while (rs.next()) {
                rows += rs.getInt(1);
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(rs, stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return rows;
    }

    @Override
    public String[] getDependencies() {
        return new String[0];
    }
}

