/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.ProgressState;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.java.util.UUIDs;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Column;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;

public class AddUUIDForInfostoreReservedPaths
extends UpdateTaskAdapter {
    private static final String TABLE = "infostoreReservedPaths";

    @Override
    public void perform(PerformParameters params) throws OXException {
        int ctxId = params.getContextId();
        ProgressState progress = params.getProgressState();
        Connection con = Database.getNoTimeout(ctxId, true);
        boolean rollback = false;
        try {
            DBUtils.startTransaction(con);
            rollback = true;
            progress.setTotal(AddUUIDForInfostoreReservedPaths.getTotalRows(con));
            if (!Tools.columnExists(con, TABLE, "uuid")) {
                Tools.addColumns(con, TABLE, new Column("uuid", "BINARY(16) DEFAULT NULL"));
                AddUUIDForInfostoreReservedPaths.fillUUIDs(con, TABLE, progress);
            }
            con.commit();
            rollback = true;
        }
        catch (SQLException e) {
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw UpdateExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            if (rollback) {
                DBUtils.rollback(con);
            }
            DBUtils.autocommit(con);
            Database.backNoTimeout(ctxId, true, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillUUIDs(Connection con, String table, ProgressState progress) throws SQLException {
        Statement stmt1 = null;
        ResultSet result = null;
        PreparedStatement stmt2 = null;
        try {
            stmt1 = con.createStatement();
            result = stmt1.executeQuery("SELECT cid, folder, name FROM " + table + " WHERE uuid IS NULL");
            stmt2 = con.prepareStatement("UPDATE " + table + " SET uuid=? WHERE cid=? AND folder=? AND name=?");
            while (result.next()) {
                int cid = result.getInt(1);
                int folder = result.getInt(2);
                String name = result.getString(3);
                stmt2.setBytes(1, UUIDs.toByteArray((UUID)UUID.randomUUID()));
                stmt2.setInt(2, cid);
                stmt2.setInt(3, folder);
                stmt2.setString(4, name);
                stmt2.addBatch();
                progress.incrementState();
            }
            stmt2.executeBatch();
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(result, stmt1);
            DBUtils.closeSQLStuff(stmt2);
            throw throwable;
        }
        DBUtils.closeSQLStuff(result, stmt1);
        DBUtils.closeSQLStuff(stmt2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getTotalRows(Connection con) throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        int rows = 0;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery("SELECT COUNT(*) FROM infostoreReservedPaths");
            while (rs.next()) {
                rows += rs.getInt(1);
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(rs, stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return rows;
    }

    @Override
    public String[] getDependencies() {
        return new String[0];
    }
}

