/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Column;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.SQLException;

public class AddMetaForInfostoreDocumentTable
extends UpdateTaskAdapter {
    @Override
    public void perform(PerformParameters params) throws OXException {
        int ctxId = params.getContextId();
        Connection con = Database.getNoTimeout(ctxId, true);
        boolean rollback = false;
        try {
            DBUtils.startTransaction(con);
            rollback = true;
            if (!Tools.columnExists(con, "infostore_document", "meta")) {
                Tools.addColumns(con, "infostore_document", new Column("meta", "BLOB DEFAULT NULL"));
            }
            if (!Tools.columnExists(con, "del_infostore_document", "meta")) {
                Tools.addColumns(con, "del_infostore_document", new Column("meta", "BLOB DEFAULT NULL"));
            }
            con.commit();
            rollback = false;
        }
        catch (SQLException e) {
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw UpdateExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            if (rollback) {
                DBUtils.rollback(con);
            }
            DBUtils.autocommit(con);
            Database.backNoTimeout(ctxId, true, con);
        }
    }

    @Override
    public String[] getDependencies() {
        return new String[0];
    }
}

