/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.internal;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.SchemaUpdateState;
import com.openexchange.groupware.update.SeparatedTasks;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskV2;
import com.openexchange.groupware.update.internal.DynamicList;
import com.openexchange.groupware.update.internal.ExcludedList;
import com.openexchange.groupware.update.internal.ExecutedFilter;
import com.openexchange.groupware.update.internal.UpdateTaskSorter;
import com.openexchange.java.Strings;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UpdateTaskCollection {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateTaskCollection.class);
    private static final UpdateTaskCollection SINGLETON = new UpdateTaskCollection();
    private final AtomicBoolean versionDirty = new AtomicBoolean(true);

    private UpdateTaskCollection() {
    }

    static UpdateTaskCollection getInstance() {
        return SINGLETON;
    }

    void dispose() {
        this.versionDirty.set(true);
    }

    private final List<UpdateTaskV2> getFilteredUpdateTasks(SchemaUpdateState schema) {
        List<UpdateTaskV2> tasks2 = this.getListWithoutExcludes();
        ExecutedFilter filter = new ExecutedFilter();
        ArrayList<UpdateTaskV2> filtered = new ArrayList<UpdateTaskV2>();
        for (UpdateTaskV2 task : tasks2) {
            if (!filter.mustBeExecuted(schema, task)) continue;
            filtered.add(task);
        }
        return filtered;
    }

    SeparatedTasks getFilteredAndSeparatedTasks(SchemaUpdateState state) {
        return this.separateTasks(this.getFilteredUpdateTasks(state));
    }

    SeparatedTasks separateTasks(List<UpdateTaskV2> tasks2) {
        final ArrayList<UpdateTaskV2> blocking = new ArrayList<UpdateTaskV2>();
        final ArrayList<UpdateTaskV2> background = new ArrayList<UpdateTaskV2>();
        block4: for (UpdateTaskV2 toExecute : tasks2) {
            switch (toExecute.getAttributes().getConcurrency()) {
                case BLOCKING: {
                    blocking.add(toExecute);
                    continue block4;
                }
                case BACKGROUND: {
                    background.add(toExecute);
                    continue block4;
                }
            }
            OXException e = UpdateExceptionCodes.UNKNOWN_CONCURRENCY.create(toExecute.getClass().getName());
            LOG.error("", (Throwable)e);
            blocking.add(toExecute);
        }
        return new SeparatedTasks(){

            @Override
            public List<UpdateTaskV2> getBlocking() {
                return blocking;
            }

            @Override
            public List<UpdateTaskV2> getBackground() {
                return background;
            }
        };
    }

    final List<UpdateTaskV2> getFilteredAndSortedUpdateTasks(SchemaUpdateState schema, boolean blocking) throws OXException {
        SeparatedTasks tasks2 = this.getFilteredAndSeparatedTasks(schema);
        List<UpdateTaskV2> retval = new ArrayList<UpdateTaskV2>();
        if (blocking) {
            retval.addAll(tasks2.getBlocking());
        } else {
            if (tasks2.getBlocking().size() > 0) {
                throw UpdateExceptionCodes.BLOCKING_FIRST.create(Strings.join(tasks2.getBlocking(), (String)","), Strings.join(tasks2.getBackground(), (String)","));
            }
            retval.addAll(tasks2.getBackground());
        }
        retval = new UpdateTaskSorter().sort(schema.getExecutedList(), retval);
        return retval;
    }

    List<UpdateTaskV2> getListWithoutExcludes() {
        List<UpdateTaskV2> retval = this.getFullList();
        for (String excluded : ExcludedList.getInstance().getTaskList()) {
            Iterator<UpdateTaskV2> iter = retval.iterator();
            while (iter.hasNext()) {
                if (!excluded.equals(iter.next().getClass().getName())) continue;
                iter.remove();
            }
        }
        return retval;
    }

    private List<UpdateTaskV2> getFullList() {
        return DynamicList.getInstance().getTaskList();
    }

    void dirtyVersion() {
        this.versionDirty.set(true);
    }

    boolean needsUpdate(SchemaUpdateState state) {
        List<UpdateTaskV2> tasks2 = this.getListWithoutExcludes();
        for (UpdateTaskV2 task : tasks2) {
            if (state.isExecuted(task.getClass().getName())) continue;
            return true;
        }
        return false;
    }
}

