/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.internal;

import com.openexchange.groupware.update.UpdateTaskV2;
import com.openexchange.groupware.update.internal.UpdateTaskCollection;
import com.openexchange.groupware.update.internal.UpdateTaskList;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DynamicList
implements UpdateTaskList<UpdateTaskV2> {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicList.class);
    private static final DynamicList SINGLETON = new DynamicList();
    private final ConcurrentMap<Class<? extends UpdateTaskV2>, UpdateTaskV2> taskList = new ConcurrentHashMap<Class<? extends UpdateTaskV2>, UpdateTaskV2>();

    public static DynamicList getInstance() {
        return SINGLETON;
    }

    private DynamicList() {
    }

    public boolean addUpdateTask(UpdateTaskV2 updateTask) {
        boolean added;
        boolean bl = added = null == this.taskList.putIfAbsent(updateTask.getClass(), updateTask);
        if (added) {
            UpdateTaskCollection.getInstance().dirtyVersion();
        } else {
            LOG.error("Update task \"{}\" is already registered.", (Object)updateTask.getClass().getName());
        }
        return added;
    }

    public void removeUpdateTask(UpdateTaskV2 updateTask) {
        UpdateTaskV2 removed = (UpdateTaskV2)this.taskList.remove(updateTask.getClass());
        if (null == removed) {
            LOG.error("Update task \"{}\" is unknown and could not be deregistered.", (Object)updateTask.getClass().getName());
        } else {
            UpdateTaskCollection.getInstance().dirtyVersion();
        }
    }

    @Override
    public List<UpdateTaskV2> getTaskList() {
        ArrayList<UpdateTaskV2> retval = new ArrayList<UpdateTaskV2>(this.taskList.size());
        retval.addAll(this.taskList.values());
        return retval;
    }
}

