/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update;

import com.openexchange.database.CreateTableService;
import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Attributes;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.TaskAttributes;
import com.openexchange.groupware.update.UpdateTaskV2;
import java.sql.Connection;

public class CreateTableUpdateTask
implements UpdateTaskV2 {
    private final CreateTableService create;
    private final String[] dependencies;
    private final DatabaseService databaseService;

    public CreateTableUpdateTask(CreateTableService create, String[] dependencies, int version2, DatabaseService databaseService) {
        this(create, dependencies, databaseService);
    }

    public CreateTableUpdateTask(CreateTableService create, String[] dependencies, DatabaseService databaseService) {
        this.create = create;
        this.dependencies = dependencies;
        this.databaseService = databaseService;
    }

    @Override
    public TaskAttributes getAttributes() {
        return new Attributes();
    }

    @Override
    public String[] getDependencies() {
        return this.dependencies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform(PerformParameters params) throws OXException {
        int contextId = params.getContextId();
        Connection con = null;
        try {
            con = this.getConnection(contextId);
            this.create.perform(con);
        }
        finally {
            this.releaseConnection(contextId, con);
        }
    }

    private void releaseConnection(int contextId, Connection con) {
        this.databaseService.backForUpdateTask(contextId, con);
    }

    private Connection getConnection(int contextId) throws OXException {
        return this.databaseService.getForUpdateTask(contextId);
    }
}

