/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tasks.database;

import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Attributes;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.TaskAttributes;
import com.openexchange.groupware.update.UpdateConcurrency;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.groupware.update.WorkingLevel;
import com.openexchange.groupware.update.tasks.TasksAddFulltimeColumnTask;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public final class RemoveUselessExternalParticipants
extends UpdateTaskAdapter {
    private final DatabaseService service;

    public RemoveUselessExternalParticipants(DatabaseService service) {
        this.service = service;
    }

    @Override
    public String[] getDependencies() {
        return new String[]{TasksAddFulltimeColumnTask.class.getName()};
    }

    @Override
    public TaskAttributes getAttributes() {
        return new Attributes(UpdateConcurrency.BACKGROUND, WorkingLevel.SCHEMA);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void perform(PerformParameters params) throws OXException {
        int contextID = params.getContextId();
        Connection con = this.service.getForUpdateTask(contextID);
        Statement stmt = null;
        try {
            DBUtils.startTransaction(con);
            stmt = con.createStatement();
            stmt.execute("DELETE FROM del_task_eparticipant");
            con.commit();
        }
        catch (SQLException e) {
            try {
                DBUtils.rollback(con);
                throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
                catch (RuntimeException e2) {
                    DBUtils.rollback(con);
                    throw UpdateExceptionCodes.OTHER_PROBLEM.create(e2, e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(stmt);
                DBUtils.autocommit(con);
                this.service.backForUpdateTask(contextID, con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(stmt);
        DBUtils.autocommit(con);
        this.service.backForUpdateTask(contextID, con);
    }
}

