/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tasks;

import com.openexchange.configuration.ServerConfig;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.search.Order;
import com.openexchange.groupware.search.SearchObject;
import com.openexchange.groupware.search.TaskSearchObject;
import com.openexchange.groupware.tasks.Permission;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.groupware.tasks.TaskExceptionCode;
import com.openexchange.groupware.tasks.TaskStorage;
import com.openexchange.groupware.tasks.Tools;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.java.Autoboxing;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIteratorAdapter;
import com.openexchange.tools.oxfolder.OXFolderIteratorSQL;
import com.openexchange.tools.sql.SearchStrings;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Search {
    private static final Logger LOG = LoggerFactory.getLogger(Search.class);
    protected final Context ctx;
    protected final User user;
    protected final UserPermissionBits permissionBits;
    protected final TaskSearchObject search;
    protected final int orderBy;
    protected final Order order;
    protected final int[] columns;
    protected final List<Integer> all = new ArrayList<Integer>();
    protected final List<Integer> own = new ArrayList<Integer>();
    protected final List<Integer> shared = new ArrayList<Integer>();

    public Search(Context ctx, User user, UserPermissionBits permissionBits, TaskSearchObject search, int orderBy, Order order, int[] columns) {
        this.permissionBits = permissionBits;
        this.ctx = ctx;
        this.user = user;
        this.search = search;
        this.orderBy = orderBy;
        this.order = order;
        this.columns = columns;
    }

    public SearchIterator<Task> perform() throws OXException, OXException {
        this.checkConditions();
        this.prepareFolder();
        if (this.all.size() + this.own.size() + this.shared.size() == 0) {
            return SearchIteratorAdapter.emptyIterator();
        }
        return TaskStorage.getInstance().search(this.ctx, this.getUserId(), this.search, this.orderBy, this.order, this.columns, this.all, this.own, this.shared);
    }

    protected void checkConditions() throws OXException {
        if (SearchObject.NO_PATTERN == this.search.getPattern()) {
            return;
        }
        int minimumSearchCharacters = ServerConfig.getInt(ServerConfig.Property.MINIMUM_SEARCH_CHARACTERS);
        if (0 == minimumSearchCharacters) {
            return;
        }
        if (SearchStrings.lengthWithoutWildcards(this.search.getPattern()) < minimumSearchCharacters) {
            throw TaskExceptionCode.PATTERN_TOO_SHORT.create(Autoboxing.I((int)minimumSearchCharacters));
        }
    }

    protected void prepareFolder() throws OXException, OXException {
        SearchIterator<FolderObject> folders2;
        if (this.search.hasFolders()) {
            folders2 = Search.loadFolder(this.ctx, this.search.getFolders());
        } else {
            folders2 = OXFolderIteratorSQL.getAllVisibleFoldersIteratorOfModule(this.getUserId(), this.user.getGroups(), this.permissionBits.getAccessibleModules(), 1, this.ctx);
        }
        while (folders2.hasNext()) {
            FolderObject folder = (FolderObject)folders2.next();
            if (!Permission.isFolderVisible(this.ctx, this.user, this.permissionBits, folder) || Permission.canOnlySeeFolder(this.ctx, this.user, this.permissionBits, folder)) continue;
            Permission.checkReadInFolder(this.ctx, this.user, this.permissionBits, folder);
            if (folder.isShared(this.getUserId()) && !Permission.canReadInFolder(this.ctx, this.user, this.permissionBits, folder)) {
                this.shared.add(folder.getObjectID());
                continue;
            }
            if (Permission.canReadInFolder(this.ctx, this.user, this.permissionBits, folder)) {
                this.own.add(folder.getObjectID());
                continue;
            }
            this.all.add(folder.getObjectID());
        }
        LOG.trace("Search tasks, all: {}, own: {}, shared: {}", new Object[]{this.all, this.own, this.shared});
    }

    private static SearchIterator<FolderObject> loadFolder(Context ctx, int[] folderIds) throws OXException {
        ArrayList<FolderObject> retval = new ArrayList<FolderObject>(folderIds.length);
        for (int folderId : folderIds) {
            retval.add(Tools.getFolder(ctx, folderId));
        }
        return new SearchIteratorAdapter(retval.iterator());
    }

    private int getUserId() {
        return this.user.getId();
    }
}

