/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tasks;

import com.openexchange.database.provider.SimpleDBProvider;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.AttachmentBase;
import com.openexchange.groupware.attach.Attachments;
import com.openexchange.groupware.attach.impl.AttachmentBaseImpl;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.tasks.Folder;
import com.openexchange.groupware.tasks.FolderStorage;
import com.openexchange.groupware.tasks.ParticipantStorage;
import com.openexchange.groupware.tasks.Permission;
import com.openexchange.groupware.tasks.Reminder;
import com.openexchange.groupware.tasks.StorageType;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.groupware.tasks.TaskExceptionCode;
import com.openexchange.groupware.tasks.TaskLogic;
import com.openexchange.groupware.tasks.TaskParticipant;
import com.openexchange.groupware.tasks.TaskStorage;
import com.openexchange.groupware.tasks.Tools;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.java.Autoboxing;
import java.sql.Connection;
import java.util.Date;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GetTask {
    private static final Logger LOG = LoggerFactory.getLogger(GetTask.class);
    private final Context ctx;
    private final Connection con;
    private User user;
    private UserPermissionBits permissionBits;
    private final int folderId;
    private FolderObject folder;
    private final int taskId;
    private Task task;
    private final StorageType type;
    private Set<TaskParticipant> participants;
    private Set<Folder> folderMapping;
    private final TaskStorage storage = TaskStorage.getInstance();
    private final ParticipantStorage partStor = ParticipantStorage.getInstance();
    private final FolderStorage foldStor = FolderStorage.getInstance();
    private boolean filledParts = false;
    private boolean filledTask = false;

    GetTask(Context ctx, User user, UserPermissionBits permissionBits, int folderId, int taskId, StorageType type) {
        this(ctx, null, user, permissionBits, folderId, taskId, type);
    }

    GetTask(Context ctx, Connection con, User user, UserPermissionBits permissionBits, int folderId, int taskId, StorageType type) {
        this.ctx = ctx;
        this.con = con;
        this.user = user;
        this.permissionBits = permissionBits;
        this.folderId = folderId;
        this.taskId = taskId;
        this.type = type;
    }

    GetTask(Context ctx, int folderId, int taskId, StorageType type) {
        this(ctx, null, folderId, taskId, type);
    }

    GetTask(Context ctx, Connection con, int folderId, int taskId, StorageType type) {
        this.ctx = ctx;
        this.con = con;
        this.folderId = folderId;
        this.taskId = taskId;
        this.type = type;
    }

    private FolderObject getFolder() throws OXException {
        if (null == this.folder) {
            this.folder = null == this.con ? Tools.getFolder(this.ctx, this.folderId) : Tools.getFolder(this.ctx, this.con, this.folderId);
        }
        return this.folder;
    }

    private Task getTask() throws OXException {
        if (null == this.task) {
            this.task = null == this.con ? this.storage.selectTask(this.ctx, this.taskId, this.type) : this.storage.selectTask(this.ctx, this.con, this.taskId, this.type);
        }
        return this.task;
    }

    private Set<TaskParticipant> getParticipants() throws OXException {
        if (null == this.participants) {
            this.participants = null == this.con ? this.partStor.selectParticipants(this.ctx, this.taskId, this.type) : this.partStor.selectParticipants(this.ctx, this.con, this.taskId, this.type);
        }
        return this.participants;
    }

    private Set<Folder> getFolders() throws OXException {
        if (null == this.folderMapping) {
            this.folderMapping = null == this.con ? this.foldStor.selectFolder(this.ctx, this.taskId, this.type) : this.foldStor.selectFolder(this.ctx, this.con, this.taskId, this.type);
        }
        return this.folderMapping;
    }

    static Task load(Context ctx, Connection con, int folderId, int taskId, StorageType type) throws OXException {
        return new GetTask(ctx, con, folderId, taskId, type).load();
    }

    static Task load(Context ctx, int folderId, int taskId, StorageType type) throws OXException {
        return new GetTask(ctx, folderId, taskId, type).load();
    }

    Task load() throws OXException {
        this.fillParticipants();
        this.fillTask();
        return this.getTask();
    }

    Task loadAndCheck() throws OXException {
        this.checkPermission();
        this.fillParticipants();
        this.fillTask();
        this.fillReminder();
        return this.getTask();
    }

    void checkPermission() throws OXException {
        if (null == this.user || null == this.permissionBits) {
            throw TaskExceptionCode.UNIMPLEMENTED.create();
        }
        if (null == this.con) {
            Permission.canReadInFolder(this.ctx, this.user, this.permissionBits, this.getFolder(), this.getTask());
        } else {
            Permission.canReadInFolder(this.ctx, this.con, this.user, this.permissionBits, this.getFolder(), this.getTask());
        }
        Folder check = FolderStorage.getFolder(this.getFolders(), this.folderId);
        if (null == check || Tools.isFolderShared(this.getFolder(), this.user) && this.getTask().getPrivateFlag()) {
            throw TaskExceptionCode.NO_PERMISSION.create(Autoboxing.I((int)this.taskId), this.getFolder().getFolderName(), Autoboxing.I((int)this.folderId));
        }
    }

    private void fillParticipants() throws OXException {
        if (this.filledParts) {
            return;
        }
        if (!Tools.isFolderPublic(this.getFolder())) {
            Tools.fillStandardFolders(this.ctx.getContextId(), this.taskId, this.getParticipants(), this.getFolders(), true);
        }
        this.filledParts = true;
    }

    private void fillTask() throws OXException {
        if (this.filledTask) {
            return;
        }
        this.getTask();
        this.task.setParticipants(TaskLogic.createParticipants(this.getParticipants()));
        this.task.setUsers(TaskLogic.createUserParticipants(this.getParticipants()));
        this.task.setParentFolderID(this.folderId);
        AttachmentBase attachmentBase = null == this.con ? Attachments.getInstance() : new AttachmentBaseImpl(new SimpleDBProvider(this.con, null));
        Date lastModifiedOfNewestAttachment = null;
        try {
            lastModifiedOfNewestAttachment = attachmentBase.getNewestCreationDate(this.ctx, 4, this.task.getObjectID());
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
        }
        if (null != lastModifiedOfNewestAttachment) {
            this.task.setLastModifiedOfNewestAttachment(lastModifiedOfNewestAttachment);
        }
        this.filledTask = true;
    }

    void fillReminder() throws OXException {
        Reminder.loadReminder(this.ctx, this.getUserId(), this.getTask());
    }

    private int getUserId() throws OXException {
        if (null == this.user) {
            throw TaskExceptionCode.UNIMPLEMENTED.create();
        }
        return this.user.getId();
    }
}

