/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.settings.tree.modules.mail.folder;

import com.openexchange.config.ConfigurationService;
import com.openexchange.config.Reloadable;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.settings.AbstractWarningAwareReadOnlyValue;
import com.openexchange.groupware.settings.Setting;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.config.MailReloadable;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractStandardFolderItemValue
extends AbstractWarningAwareReadOnlyValue {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractStandardFolderItemValue.class);
    private static volatile Boolean failOnError;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean failOnError() {
        Boolean tmp = failOnError;
        if (null != tmp) return tmp;
        Class<AbstractStandardFolderItemValue> clazz = AbstractStandardFolderItemValue.class;
        synchronized (AbstractStandardFolderItemValue.class) {
            tmp = failOnError;
            if (null != tmp) return tmp;
            boolean defaultValue = false;
            ConfigurationService service = ServerServiceRegistry.getServize(ConfigurationService.class);
            if (null == service) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return defaultValue;
            }
            failOnError = tmp = Boolean.valueOf(service.getBoolProperty("com.openexchange.settings.mail.failOnError", defaultValue));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    protected AbstractStandardFolderItemValue() {
    }

    @Override
    public boolean isAvailable(UserConfiguration userConfig) {
        return userConfig.hasWebMail();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getValue(Session session, Context ctx, User user, UserConfiguration userConfig, Setting setting) throws OXException {
        MailServletInterface mailInterface = null;
        try {
            mailInterface = MailServletInterface.getInstance(session);
            this.getValue(setting, mailInterface);
            this.addWarnings(mailInterface.getWarnings());
        }
        catch (OXException e) {
            if (MailExceptionCode.ACCOUNT_DOES_NOT_EXIST.equals(e)) {
                setting.setSingleValue(null);
            } else if (MailExceptionCode.containsSocketError(e)) {
                LOGGER.warn("Could not connect to mail system due to a socket error", (Throwable)e);
                setting.setSingleValue(null);
            } else {
                if (AbstractStandardFolderItemValue.failOnError()) {
                    throw e;
                }
                LOGGER.warn("Could not determine mail setting", (Throwable)e);
                setting.setSingleValue(null);
            }
        }
        catch (RuntimeException rte) {
            if (AbstractStandardFolderItemValue.failOnError()) {
                throw rte;
            }
            LOGGER.warn("Could not determine mail setting", (Throwable)rte);
            setting.setSingleValue(null);
        }
        finally {
            if (mailInterface != null) {
                try {
                    mailInterface.close(true);
                }
                catch (OXException e) {
                    LOGGER.error("Failed to close MailServletInterface instance", (Throwable)e);
                }
            }
        }
    }

    protected abstract void getValue(Setting var1, MailServletInterface var2) throws OXException;

    static {
        MailReloadable.getInstance().addReloadable(new Reloadable(){

            public void reloadConfiguration(ConfigurationService configService) {
                failOnError = null;
            }

            public Map<String, String[]> getConfigFileNames() {
                return null;
            }
        });
    }
}

