/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.settings.tree.modules.mail;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.settings.IValueHandler;
import com.openexchange.groupware.settings.PreferencesItemService;
import com.openexchange.groupware.settings.impl.AbstractMailFuncs;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mailaccount.UnifiedInboxManagement;
import com.openexchange.server.services.ServerServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnifiedInboxEnablement
implements PreferencesItemService {
    static final Logger LOG = LoggerFactory.getLogger(UnifiedInboxEnablement.class);

    @Override
    public String[] getPath() {
        return new String[]{"modules", "mail", "unifiedinbox"};
    }

    @Override
    public IValueHandler getSharedValue() {
        return new AbstractMailFuncs(){

            @Override
            public boolean isAvailable(UserConfiguration userConfig) {
                return userConfig.hasWebMail();
            }

            @Override
            protected Boolean isSet(UserSettingMail settings) {
                UnifiedInboxManagement management;
                try {
                    management = ServerServiceRegistry.getInstance().getService(UnifiedInboxManagement.class, true);
                }
                catch (OXException e) {
                    LOG.warn("", (Throwable)e);
                    return Boolean.FALSE;
                }
                try {
                    return management.getUnifiedINBOXAccountID(settings.getUserId(), settings.getCid()) >= 0;
                }
                catch (OXException e) {
                    LOG.error("", (Throwable)e);
                    return Boolean.FALSE;
                }
            }

            @Override
            protected void setValue(UserSettingMail settings, String value) {
                UnifiedInboxManagement management;
                boolean enable = Boolean.parseBoolean(value);
                try {
                    management = ServerServiceRegistry.getInstance().getService(UnifiedInboxManagement.class, true);
                }
                catch (OXException e) {
                    LOG.warn("{} of Unified Mail for user {} in context {} aborted: {}", new Object[]{enable ? "Enabling" : "Disabling", settings.getUserId(), settings.getCid(), e.getMessage(), e});
                    return;
                }
                try {
                    int userId = settings.getUserId();
                    int cid = settings.getCid();
                    if (enable) {
                        if (management.getUnifiedINBOXAccountID(userId, cid) < 0) {
                            management.createUnifiedINBOX(userId, cid);
                        }
                    } else {
                        management.deleteUnifiedINBOX(userId, cid);
                    }
                }
                catch (OXException e) {
                    LOG.error("", (Throwable)e);
                }
            }
        };
    }
}

