/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.reminder.osgi;

import com.openexchange.groupware.reminder.TargetService;
import com.openexchange.groupware.reminder.internal.TargetRegistry;
import com.openexchange.java.Autoboxing;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetRegistryCustomizer
implements ServiceTrackerCustomizer<TargetService, TargetService> {
    private static final Logger LOG = LoggerFactory.getLogger(TargetRegistryCustomizer.class);
    private final BundleContext context;

    public TargetRegistryCustomizer(BundleContext context) {
        this.context = context;
    }

    public TargetService addingService(ServiceReference<TargetService> reference) {
        TargetService targetService = (TargetService)this.context.getService(reference);
        int module = this.parseModule(reference);
        if (-1 == module) {
            LOG.error("Registration of service {} is missing property defining the module.", (Object)targetService.getClass().getName());
            this.context.ungetService(reference);
            return null;
        }
        TargetRegistry.getInstance().addService(module, targetService);
        return targetService;
    }

    public void modifiedService(ServiceReference<TargetService> reference, TargetService service) {
    }

    public void removedService(ServiceReference<TargetService> reference, TargetService service) {
        if (null == service) {
            return;
        }
        TargetRegistry.getInstance().removeService(this.parseModule(reference));
        this.context.ungetService(reference);
    }

    private int parseModule(ServiceReference<TargetService> reference) {
        Object obj = reference.getProperty("MODULE");
        int retval = obj instanceof Integer ? Autoboxing.i((Integer)((Integer)obj)) : -1;
        return retval;
    }
}

