/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.reminder.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.writer.ReminderWriter;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.reminder.ReminderHandler;
import com.openexchange.groupware.reminder.ReminderObject;
import com.openexchange.groupware.reminder.json.ReminderAJAXRequest;
import com.openexchange.groupware.reminder.json.actions.AbstractReminderAction;
import com.openexchange.oauth.provider.annotations.OAuthAction;
import com.openexchange.server.ServiceLookup;
import com.openexchange.tools.TimeZoneUtils;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIterators;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import com.openexchange.tools.session.ServerSession;
import java.util.Date;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Action(method=RequestMethod.GET, name="updates", description="Get updated reminders", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module.")}, responseDescription="")
@OAuthAction(value="read_reminders")
public final class UpdatesAction
extends AbstractReminderAction {
    private static final Logger LOG = LoggerFactory.getLogger(UpdatesAction.class);

    public UpdatesAction(ServiceLookup services) {
        super(services);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AJAXRequestResult perform(ReminderAJAXRequest req) throws OXException, JSONException {
        AJAXRequestResult aJAXRequestResult;
        Date timestamp = req.checkDate("timestamp");
        String timeZoneId = req.getParameter("timezone");
        TimeZone timeZone = null == timeZoneId ? req.getTimeZone() : TimeZoneUtils.getTimeZone(timeZoneId);
        JSONArray jsonResponseArray = new JSONArray();
        SearchIterator it = null;
        try {
            ServerSession session = req.getSession();
            ReminderHandler reminderSql = new ReminderHandler(session.getContext());
            it = reminderSql.listModifiedReminder(session.getUserId(), timestamp);
            while (it.hasNext()) {
                ReminderWriter reminderWriter = new ReminderWriter(timeZone);
                ReminderObject reminder = (ReminderObject)it.next();
                if (reminder.isRecurrenceAppointment()) {
                    // empty if block
                }
                try {
                    if (!UpdatesAction.hasModulePermission(reminder, session) || !UpdatesAction.stillAccepted(reminder, session)) continue;
                    JSONObject jsonReminderObj = new JSONObject(12);
                    reminderWriter.writeObject(reminder, jsonReminderObj);
                    jsonResponseArray.put((Object)jsonReminderObj);
                }
                catch (OXException e) {
                    if (!OXFolderExceptionCode.NOT_EXISTS.equals(e)) {
                        throw e;
                    }
                    LOG.warn("Cannot load target object of this reminder.", (Throwable)e);
                    UpdatesAction.deleteReminderSafe(reminder, session.getUserId(), reminderSql);
                }
            }
            aJAXRequestResult = new AJAXRequestResult(jsonResponseArray, timestamp, "json");
        }
        catch (Throwable throwable) {
            SearchIterators.close(it);
            throw throwable;
        }
        SearchIterators.close((SearchIterator)it);
        return aJAXRequestResult;
    }
}

