/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.reminder.json.actions;

import com.openexchange.ajax.parser.ReminderParser;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.writer.ReminderWriter;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.reminder.ReminderExceptionCode;
import com.openexchange.groupware.reminder.ReminderHandler;
import com.openexchange.groupware.reminder.ReminderObject;
import com.openexchange.groupware.reminder.json.ReminderAJAXRequest;
import com.openexchange.groupware.reminder.json.actions.AbstractReminderAction;
import com.openexchange.oauth.provider.annotations.OAuthAction;
import com.openexchange.server.ServiceLookup;
import com.openexchange.tools.TimeZoneUtils;
import com.openexchange.tools.session.ServerSession;
import java.util.Date;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Action(method=RequestMethod.PUT, name="remindAgain", description="Remind again (since v6.18.1).", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="id", description="The ID of the reminder whose date shall be changed.")}, requestBody="The JSON representation of the reminder; mainly containing the field \u201calarm\u201d which provides the new reminder date. E.g. { \"alarm\": 1283418027381 }", responseDescription="The JSON representation of the updated reminder.")
@OAuthAction(value="write_reminders")
public final class RemindAgainAction
extends AbstractReminderAction {
    private static final Logger LOG = LoggerFactory.getLogger(RemindAgainAction.class);

    public RemindAgainAction(ServiceLookup services) {
        super(services);
    }

    @Override
    protected AJAXRequestResult perform(ReminderAJAXRequest req) throws OXException, JSONException {
        int reminderId = req.checkInt("id");
        TimeZone tz = req.getTimeZone();
        String timeZoneId = req.getParameter("timezone");
        TimeZone timeZone = null == timeZoneId ? tz : TimeZoneUtils.getTimeZone(timeZoneId);
        JSONObject jreminder = (JSONObject)req.getData();
        ReminderObject reminder = new ReminderObject();
        new ReminderParser(tz).parse(reminder, jreminder);
        if (null == reminder.getDate()) {
            throw ReminderExceptionCode.MANDATORY_FIELD_ALARM.create();
        }
        reminder.setObjectId(reminderId);
        ServerSession session = req.getSession();
        ReminderHandler reminderSql = new ReminderHandler(session.getContext());
        ReminderObject storageReminder = reminderSql.loadReminder(reminder.getObjectId());
        if (!RemindAgainAction.hasModulePermission(storageReminder, session)) {
            throw ReminderExceptionCode.UNEXPECTED_ERROR.create("No module permission.");
        }
        reminder.setModule(storageReminder.getModule());
        reminder.setDescription(storageReminder.getDescription());
        reminder.setFolder(storageReminder.getFolder());
        reminder.setTargetId(storageReminder.getTargetId());
        reminder.setUser(storageReminder.getUser());
        reminderSql.remindAgain(reminder, session, session.getContext());
        Date timestamp = reminder.getLastModified();
        ReminderWriter reminderWriter = new ReminderWriter(timeZone);
        JSONObject jsonReminderObj = new JSONObject();
        reminderWriter.writeObject(reminder, jsonReminderObj);
        return new AJAXRequestResult(jsonReminderObj, timestamp, "json");
    }
}

