/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.ldap;

import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.cache.CacheFolderStorage;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.CachingUserStorage;
import com.openexchange.groupware.ldap.RdbUserStorage;
import com.openexchange.groupware.ldap.User;
import com.openexchange.passwordmechs.IPasswordMech;
import com.openexchange.server.impl.DBPool;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import java.sql.Connection;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UserStorage {
    private static final Logger LOG = LoggerFactory.getLogger(UserStorage.class);
    private static volatile UserStorage instance;
    public static final int SEARCH_LOGIN_NAME = 1;
    public static final int SEARCH_DISPLAY_NAME = 2;

    protected UserStorage() {
    }

    public boolean isGuest(int userId, int contextId) throws OXException {
        return this.isGuest(userId, ContextStorage.getInstance().getContext(contextId));
    }

    public abstract boolean isGuest(int var1, Context var2) throws OXException;

    public abstract int getUserId(String var1, Context var2) throws OXException;

    public User getUser(int userId, int contextId) throws OXException {
        return this.getUser(userId, ContextStorage.getInstance().getContext(contextId));
    }

    public User getUser(int userId, int contextId, Connection con) throws OXException {
        if (con == null) {
            return this.getUser(userId, contextId);
        }
        return this.getUser(ContextStorage.getInstance().getContext(contextId), userId, con);
    }

    public abstract User getUser(int var1, Context var2) throws OXException;

    public abstract User loadIfAbsent(int var1, Context var2, Connection var3) throws OXException;

    public abstract User getUser(Context var1, int var2, Connection var3) throws OXException;

    public abstract User[] getUser(Context var1, int[] var2) throws OXException;

    public abstract User[] getUser(Context var1, int[] var2, Connection var3) throws OXException;

    public User[] getUser(Context ctx) throws OXException {
        return this.getUser(ctx, false, false);
    }

    public abstract User[] getUser(Context var1, boolean var2, boolean var3) throws OXException;

    public abstract User[] getUser(Connection var1, Context var2, boolean var3, boolean var4) throws OXException;

    public abstract User[] getGuestsCreatedBy(Connection var1, Context var2, int var3) throws OXException;

    public final void updateUser(User user, Context context) throws OXException {
        this.updateUser(null, user, context);
    }

    public void updatePassword(Connection connection, Context context, int userId, IPasswordMech mech, String password) throws OXException {
        this.updatePasswordInternal(connection, context, userId, mech, password);
    }

    protected abstract void updatePasswordInternal(Connection var1, Context var2, int var3, IPasswordMech var4, String var5) throws OXException;

    public final void updateUser(Connection con, User user, Context context) throws OXException {
        this.updateUserInternal(con, user, context);
        CacheFolderStorage.dropUserEntries(user.getId(), context.getContextId());
    }

    protected abstract void updateUserInternal(Connection var1, User var2, Context var3) throws OXException;

    public abstract String getUserAttribute(String var1, int var2, Context var3) throws OXException;

    public abstract void setUserAttribute(String var1, String var2, int var3, Context var4) throws OXException;

    public abstract void setAttribute(String var1, String var2, int var3, Context var4) throws OXException;

    public abstract void setAttribute(Connection var1, String var2, String var3, int var4, Context var5) throws OXException;

    public User searchUser(String email, Context context) throws OXException {
        return this.searchUser(email, context, true);
    }

    public User searchUser(String email, Context context, boolean considerAliases) throws OXException {
        return this.searchUser(email, context, considerAliases, false, false);
    }

    public abstract User searchUser(String var1, Context var2, boolean var3, boolean var4, boolean var5) throws OXException;

    public abstract User[] searchUserByMailLogin(String var1, Context var2) throws OXException;

    public abstract User[] searchUserByName(String var1, Context var2, int var3) throws OXException;

    public int[] listAllUser(Context context) throws OXException {
        return this.listAllUser(null, context, false, false);
    }

    public abstract int[] listAllUser(Connection var1, Context var2, boolean var3, boolean var4) throws OXException;

    public abstract int[] listAllUser(Connection var1, int var2, boolean var3, boolean var4) throws OXException;

    public abstract int[] resolveIMAPLogin(String var1, Context var2) throws OXException;

    protected abstract void startInternal() throws OXException;

    protected abstract void stopInternal() throws OXException;

    public abstract int[] listModifiedUser(Date var1, Context var2) throws OXException;

    public abstract void invalidateUser(Context var1, int var2) throws OXException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createUser(Context context, User user) throws OXException {
        Connection con = null;
        try {
            con = DBPool.pickupWriteable(context);
            int n = this.createUser(con, context, user);
            return n;
        }
        finally {
            DBPool.closeWriterSilent(context, con);
        }
    }

    public abstract int createUser(Connection var1, Context var2, User var3) throws OXException;

    public abstract void deleteUser(Context var1, int var2) throws OXException;

    public abstract void deleteUser(Connection var1, Context var2, int var3) throws OXException;

    public final void invalidateUser(Context ctx, int[] userIds) throws OXException {
        for (int member : userIds) {
            this.invalidateUser(ctx, member);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void start() throws OXException {
        UserStorage tmp = instance;
        if (null != tmp) return;
        Class<UserStorage> clazz = UserStorage.class;
        synchronized (UserStorage.class) {
            tmp = instance;
            if (null != tmp) return;
            tmp = new CachingUserStorage(new RdbUserStorage());
            tmp.startInternal();
            instance = tmp;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void stop() throws OXException {
        UserStorage tmp = instance;
        if (null == tmp) return;
        Class<UserStorage> clazz = UserStorage.class;
        synchronized (UserStorage.class) {
            tmp = instance;
            if (null == tmp) return;
            tmp.stopInternal();
            instance = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UserStorage getInstance() {
        UserStorage tmp = instance;
        if (null != tmp) return tmp;
        Class<UserStorage> clazz = UserStorage.class;
        synchronized (UserStorage.class) {
            tmp = instance;
            if (null != tmp) return tmp;
            try {
                tmp = new CachingUserStorage(new RdbUserStorage());
                tmp.startInternal();
                instance = tmp;
            }
            catch (OXException e) {
                LOG.warn("", (Throwable)e);
            }
            return tmp;
        }
    }

    @Deprecated
    public static User getStorageUser(int uid, Context context) throws OXException {
        return UserStorage.getInstance().getUser(uid, context);
    }

    @Deprecated
    public static User getStorageUser(int uid, int contextId) throws OXException {
        return UserStorage.getInstance().getUser(uid, ContextStorage.getStorageContext(contextId));
    }

    @Deprecated
    public static User getStorageUser(Session session) throws OXException {
        if (session instanceof ServerSession) {
            return ((ServerSession)session).getUser();
        }
        return UserStorage.getStorageUser(session.getUserId(), session.getContextId());
    }
}

