/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.webdav;

import com.openexchange.database.provider.DBProvider;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.infostore.webdav.EntityLockManager;
import com.openexchange.groupware.infostore.webdav.Lock;
import com.openexchange.groupware.infostore.webdav.LockManager;
import com.openexchange.groupware.infostore.webdav.LockManagerImpl;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class EntityLockManagerImpl
extends LockManagerImpl<Lock>
implements EntityLockManager {
    public EntityLockManagerImpl(String tablename) {
        super(tablename);
    }

    public EntityLockManagerImpl(DBProvider provider, String tablename) {
        super(provider, tablename);
    }

    @Override
    protected Lock newLock() {
        return new Lock();
    }

    @Override
    public List<Lock> findLocks(int entity, Session session) throws OXException {
        return this.findLocks(Arrays.asList(entity), session).get(entity);
    }

    @Override
    public Map<Integer, List<Lock>> findLocks(List<Integer> entities, Session session) throws OXException {
        return this.findLocks(entities, this.getContextFrom(session));
    }

    @Override
    public Map<Integer, List<Lock>> findLocks(List<Integer> entities, Context context) throws OXException {
        return this.findLocksByEntity(entities, context);
    }

    @Override
    public boolean isLocked(int entity, Context ctx, User user) throws OXException {
        return this.existsLockForEntity(Collections.singletonList(entity), ctx);
    }

    @Override
    public int lock(int entity, long timeout, LockManager.Scope scope, LockManager.Type type, String ownerDesc, Context ctx, User user) throws OXException {
        return this.createLock(entity, timeout, scope, type, ownerDesc, ctx, user, new Object[0]);
    }

    @Override
    public void unlock(int id, Session session) throws OXException {
        this.removeLock(id, this.getContextFrom(session));
    }

    @Override
    public void removeAll(int entity, Session session) throws OXException {
        this.removeAllFromEntity(entity, this.getContextFrom(session));
    }

    @Override
    public void relock(int lockId, long timeout, LockManager.Scope scope, LockManager.Type write, String owner, Context context, User userObject) throws OXException {
        this.updateLock(lockId, timeout, scope, write, owner, context, new Object[0]);
    }

    @Override
    public void insertLock(int entity, Lock lock, Session session) throws OXException {
        Context ctx = this.getContextFrom(session);
        User user = UserStorage.getInstance().getUser(session.getUserId(), ctx);
        this.createLockForceId(entity, lock.getId(), lock.getTimeout(), lock.getScope(), lock.getType(), lock.getOwnerDescription(), ctx, user, new Object[0]);
    }

    @Override
    public void transferLocks(Context ctx, int from_user, int to_user) throws OXException {
        this.reassign(ctx, from_user, to_user);
    }

    private Context getContextFrom(Session session) throws OXException {
        return session instanceof ServerSession ? ((ServerSession)session).getContext() : ContextStorage.getInstance().getContext(session);
    }
}

