/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.facade.impl;

import com.openexchange.database.provider.DBProvider;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.ObjectPermission;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.InfostoreExceptionCodes;
import com.openexchange.groupware.infostore.facade.impl.DbMetadataLoader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ObjectPermissionLoader
extends DbMetadataLoader<List<ObjectPermission>> {
    private static final DbMetadataLoader.ResultProcessor<Map<Integer, List<ObjectPermission>>> RESULT_PROCESSOR = new DbMetadataLoader.ResultProcessor<Map<Integer, List<ObjectPermission>>>(){

        @Override
        public Map<Integer, List<ObjectPermission>> process(ResultSet results) throws SQLException {
            HashMap<Integer, List<ObjectPermission>> objectPermissions = new HashMap<Integer, List<ObjectPermission>>();
            while (results.next()) {
                Integer id = results.getInt(1);
                ArrayList<ObjectPermission> permissions = (ArrayList<ObjectPermission>)objectPermissions.get(id);
                if (null == permissions) {
                    permissions = new ArrayList<ObjectPermission>();
                    objectPermissions.put(id, permissions);
                }
                permissions.add(new ObjectPermission(results.getInt(2), results.getBoolean(3), results.getInt(4)));
            }
            return objectPermissions;
        }
    };

    public ObjectPermissionLoader(DBProvider provider) {
        super(provider);
    }

    @Override
    protected DocumentMetadata set(DocumentMetadata document, List<ObjectPermission> metadata) {
        document.setObjectPermissions(metadata);
        return document;
    }

    @Override
    public Map<Integer, List<ObjectPermission>> load(Collection<Integer> ids, Context context) throws OXException {
        if (null == ids || 0 == ids.size()) {
            return Collections.emptyMap();
        }
        ArrayList<Integer> parameters = new ArrayList<Integer>(ids.size() + 1);
        parameters.add(context.getContextId());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT object_id,permission_id,group_flag,bits FROM object_permission WHERE cid=? AND object_id");
        if (1 == ids.size()) {
            stringBuilder.append("=?;");
            Integer id = ids.iterator().next();
            parameters.add(id);
        } else {
            Iterator<Integer> iterator = ids.iterator();
            stringBuilder.append(" IN (?");
            Integer id = iterator.next();
            parameters.add(id);
            do {
                stringBuilder.append(",?");
                id = iterator.next();
                parameters.add(id);
            } while (iterator.hasNext());
            stringBuilder.append(");");
        }
        try {
            return this.performQuery(context, stringBuilder.toString(), RESULT_PROCESSOR, parameters.toArray(new Object[parameters.size()]));
        }
        catch (SQLException e) {
            throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
    }

    public Map<Integer, List<ObjectPermission>> load(long folderID, Context context) throws OXException {
        String query = "SELECT object_id,permission_id,group_flag,bits FROM object_permission WHERE cid=? AND folder_id=?;";
        try {
            return this.performQuery(context, query, RESULT_PROCESSOR, context.getContextId(), (int)folderID);
        }
        catch (SQLException e) {
            throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
    }
}

