/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.facade.impl;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.database.impl.Tools;
import com.openexchange.groupware.results.CustomizableDelta;
import com.openexchange.groupware.results.CustomizableTimedResult;
import com.openexchange.groupware.results.Delta;
import com.openexchange.groupware.results.TimedResult;
import com.openexchange.tools.iterator.CustomizableSearchIterator;
import com.openexchange.tools.iterator.Customizer;
import com.openexchange.tools.iterator.SearchIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class MetadataLoader<T> {
    protected MetadataLoader() {
    }

    protected abstract DocumentMetadata set(DocumentMetadata var1, T var2);

    public abstract Map<Integer, T> load(Collection<Integer> var1, Context var2) throws OXException;

    public T load(int id, Context context) throws OXException {
        Integer identifier = id;
        return this.load(Collections.singleton(identifier), context).get(identifier);
    }

    public Delta<DocumentMetadata> add(Delta<DocumentMetadata> delta, Context context, Map<Integer, T> knownMetadata) throws OXException {
        return new CustomizableDelta(delta, this.getMetadataCustomizer(context, knownMetadata));
    }

    public TimedResult<DocumentMetadata> add(TimedResult<DocumentMetadata> timedResult, Context context, Map<Integer, T> knownMetadata) throws OXException {
        return new CustomizableTimedResult(timedResult, this.getMetadataCustomizer(context, knownMetadata));
    }

    public TimedResult<DocumentMetadata> add(TimedResult<DocumentMetadata> timedResult, Context context, Collection<Integer> ids) throws OXException {
        return new CustomizableTimedResult(timedResult, this.getMetadataCustomizer(context, this.load(ids, context)));
    }

    public SearchIterator<DocumentMetadata> add(SearchIterator<DocumentMetadata> searchIterator, Context context, Collection<Integer> ids) throws OXException {
        return new CustomizableSearchIterator(searchIterator, this.getMetadataCustomizer(context, this.load(ids, context)));
    }

    public DocumentMetadata add(DocumentMetadata document, Context context, Map<Integer, T> knownMetadata) throws OXException {
        return this.add(Collections.singletonList(document), context, knownMetadata).get(0);
    }

    public List<DocumentMetadata> add(List<DocumentMetadata> documents, Context context, Collection<Integer> ids) throws OXException {
        return this.add(documents, context, this.load(ids, context));
    }

    public List<DocumentMetadata> add(List<DocumentMetadata> documents, Context context, Map<Integer, T> knownMetadata) throws OXException {
        if (null == knownMetadata) {
            knownMetadata = this.load(Tools.getIDs(documents), context);
        }
        for (DocumentMetadata document : documents) {
            this.set(document, knownMetadata.get(document.getId()));
        }
        return documents;
    }

    private Customizer<DocumentMetadata> getMetadataCustomizer(final Context context, final Map<Integer, T> knownMetadata) {
        return new Customizer<DocumentMetadata>(){

            public DocumentMetadata customize(DocumentMetadata thing) throws OXException {
                if (null != thing) {
                    return MetadataLoader.this.add(thing, context, knownMetadata);
                }
                return thing;
            }
        };
    }
}

