/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.facade.impl;

import com.openexchange.database.provider.DBProvider;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.facade.impl.MetadataLoader;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class DbMetadataLoader<T>
extends MetadataLoader<T> {
    protected DBProvider provider;

    protected DbMetadataLoader(DBProvider provider) {
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <R> R performQuery(Context context, String query, ResultProcessor<R> processor, Object ... args) throws SQLException, OXException {
        R r;
        Connection connection = null;
        PreparedStatement stmt = null;
        ResultSet results = null;
        try {
            connection = this.provider.getReadConnection(context);
            stmt = connection.prepareStatement(query);
            for (int i = 0; i < args.length; ++i) {
                stmt.setObject(i + 1, args[i]);
            }
            results = stmt.executeQuery();
            r = processor.process(results);
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(results, stmt);
            if (null != connection) {
                this.provider.releaseReadConnection(context, connection);
            }
            throw throwable;
        }
        DBUtils.closeSQLStuff(results, stmt);
        if (null != connection) {
            this.provider.releaseReadConnection(context, connection);
        }
        return r;
    }

    protected static interface ResultProcessor<R> {
        public R process(ResultSet var1) throws SQLException;
    }
}

