/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.database.impl;

import com.openexchange.database.Databases;
import com.openexchange.database.provider.DBProvider;
import com.openexchange.database.tx.DBService;
import com.openexchange.exception.OXException;
import com.openexchange.filestore.FileStorage;
import com.openexchange.filestore.FileStorages;
import com.openexchange.filestore.QuotaFileStorage;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.impl.IDGenerator;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.InfostoreExceptionCodes;
import com.openexchange.groupware.infostore.InfostoreTimedResult;
import com.openexchange.groupware.infostore.database.impl.DeleteAllDocumentsAction;
import com.openexchange.groupware.infostore.database.impl.DeleteAllVersionsAction;
import com.openexchange.groupware.infostore.database.impl.DocumentMetadataImpl;
import com.openexchange.groupware.infostore.database.impl.InfostoreQueryCatalog;
import com.openexchange.groupware.infostore.database.impl.PreparedStatementHolder;
import com.openexchange.groupware.infostore.utils.DelUserFolderDiscoverer;
import com.openexchange.groupware.infostore.utils.Metadata;
import com.openexchange.groupware.infostore.webdav.EntityLockManager;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.results.Delta;
import com.openexchange.groupware.results.DeltaImpl;
import com.openexchange.groupware.results.TimedResult;
import com.openexchange.java.Autoboxing;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIteratorAdapter;
import com.openexchange.tools.iterator.SearchIteratorExceptionCodes;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.sql.DBUtils;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseImpl
extends DBService {
    private static final Logger LOG = LoggerFactory.getLogger(DatabaseImpl.class);
    private static final int DOCUMENT_VERSION_NUMBER_WITHOUT_FILE = 0;
    protected static final int INFOSTORE_cid = 0;
    protected static final int INFOSTORE_id = 1;
    protected static final int INFOSTORE_folder_id = 2;
    protected static final int INFOSTORE_version = 3;
    protected static final int INFOSTORE_locked_until = 4;
    protected static final int INFOSTORE_creating_date = 5;
    protected static final int INFOSTORE_last_modified = 6;
    protected static final int INFOSTORE_created_by = 7;
    protected static final int INFOSTORE_changed_by = 8;
    protected static final int INFOSTORE_color_label = 9;
    protected static final int INFOSTORE_DOCUMENT_cid = 10;
    protected static final int INFOSTORE_DOCUMENT_infostore_id = 11;
    protected static final int INFOSTORE_DOCUMENT_version_number = 12;
    protected static final int INFOSTORE_DOCUMENT_creating_date = 13;
    protected static final int INFOSTORE_DOCUMENT_last_modified = 14;
    protected static final int INFOSTORE_DOCUMENT_created_by = 15;
    protected static final int INFOSTORE_DOCUMENT_changed_by = 16;
    protected static final int INFOSTORE_DOCUMENT_title = 17;
    protected static final int INFOSTORE_DOCUMENT_url = 18;
    protected static final int INFOSTORE_DOCUMENT_description = 19;
    protected static final int INFOSTORE_DOCUMENT_categories = 20;
    protected static final int INFOSTORE_DOCUMENT_filename = 21;
    protected static final int INFOSTORE_DOCUMENT_file_store_location = 22;
    protected static final int INFOSTORE_DOCUMENT_file_size = 23;
    protected static final int INFOSTORE_DOCUMENT_file_mimetype = 24;
    protected static final int INFOSTORE_DOCUMENT_file_md5sum = 25;
    protected static final int INFOSTORE_DOCUMENT_file_version_comment = 26;
    private static final Fetch FETCH = Fetch.PREFETCH;
    private static final String[] INFOSTORE_DATACOLUMNS = new String[]{"infostore.cid", "infostore.id", "infostore.folder_id", "infostore.version", "infostore.locked_until", "infostore.creating_date", "infostore.last_modified", "infostore.created_by", "infostore.changed_by", "infostore.color_label", "infostore_document.cid", "infostore_document.infostore_id", "infostore_document.version_number", "infostore_document.creating_date", "infostore_document.last_modified", "infostore_document.created_by", "infostore_document.changed_by", "infostore_document.title", "infostore_document.url", "infostore_document.description", "infostore_document.categories", "infostore_document.filename", "infostore_document.file_store_location", "infostore_document.file_size", "infostore_document.file_mimetype", "infostore_document.file_md5sum", "infostore_document.file_version_comment"};
    private final ThreadLocal<List<FileInfo>> fileIdAddList = new ThreadLocal();
    private final ThreadLocal<List<FileInfo>> fileIdRemoveList = new ThreadLocal();
    private FetchMode fetchMode;
    private static final List<String> userFields = Arrays.asList("changed_by", "created_by");
    private static final List<String> tables = Arrays.asList("infostore", "infostore_document");

    public DatabaseImpl() {
        this(null);
    }

    public DatabaseImpl(DBProvider provider) {
        super(provider);
        switch (FETCH) {
            case PREFETCH: {
                this.fetchMode = new PrefetchMode();
                break;
            }
            case CLOSE_LATER: {
                this.fetchMode = new CloseLaterMode();
                break;
            }
            case CLOSE_IMMEDIATELY: {
                this.fetchMode = new CloseImmediatelyMode();
                break;
            }
            default: {
                this.fetchMode = new PrefetchMode();
            }
        }
    }

    public boolean exists(int id, int version2, Context ctx) throws OXException {
        boolean retval = false;
        Connection con = this.getReadConnection(ctx);
        StringBuilder sql = new StringBuilder();
        if (version2 == -1) {
            sql.append("SELECT id from infostore WHERE cid=? AND id=?");
        } else {
            sql.append("SELECT infostore_id FROM infostore_document WHERE cid=? AND infostore_id=? AND version_number=?");
        }
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement(sql.toString());
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, id);
            if (version2 != -1) {
                stmt.setInt(3, version2);
            }
            if ((result = stmt.executeQuery()).next()) {
                retval = true;
            }
            result.close();
            stmt.close();
        }
        catch (SQLException e) {
            try {
                LOG.error("", (Throwable)e);
                throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, DBUtils.getStatement(stmt));
            }
            catch (Throwable throwable) {
                this.close(stmt, result);
                this.releaseReadConnection(ctx, con);
                throw throwable;
            }
        }
        this.close(stmt, result);
        this.releaseReadConnection(ctx, con);
        return retval;
    }

    public DocumentMetadata getDocumentMetadata(int id, int version2, Context ctx) throws OXException {
        DocumentMetadataImpl dmi = new DocumentMetadataImpl();
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet result = null;
        String versionString = null;
        versionString = version2 == -1 ? "infostore.version" : Integer.toString(version2);
        try {
            int[] columns = this.switchMetadata2DBColumns(Metadata.VALUES_ARRAY, false);
            con = this.getReadConnection(ctx);
            stmt = con.prepareStatement(this.getSQLSelectForInfostoreColumns(columns).toString() + " FROM infostore JOIN infostore_document ON infostore.cid=? AND infostore.id=? AND infostore_document.infostore_id=infostore.id AND infostore_document.cid=? AND infostore_document.version_number = " + versionString);
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, id);
            stmt.setInt(3, ctx.getContextId());
            result = stmt.executeQuery();
            if (result.next()) {
                dmi = new DocumentMetadataImpl();
                dmi = this.fillDocumentMetadata(dmi, columns, result);
            }
            result.close();
            stmt.close();
        }
        catch (SQLException e) {
            try {
                LOG.error("", (Throwable)e);
                throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, DBUtils.getStatement(stmt));
            }
            catch (Throwable throwable) {
                this.close(stmt, result);
                if (con != null) {
                    this.releaseReadConnection(ctx, con);
                }
                throw throwable;
            }
        }
        this.close(stmt, result);
        if (con != null) {
            this.releaseReadConnection(ctx, con);
        }
        if (dmi != null) {
            dmi.setSequenceNumber(System.currentTimeMillis());
        }
        return dmi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DocumentMetadata> getAllVersions(Context ctx, Metadata[] columns, String where) throws OXException {
        ArrayList<DocumentMetadata> result;
        block6: {
            result = new ArrayList<DocumentMetadata>();
            Connection con = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                con = this.getReadConnection(ctx);
                stmt = con.prepareStatement(this.getSQLSelectForInfostoreColumns(this.switchMetadata2DBColumns(columns, true)).toString() + " FROM infostore JOIN infostore_document ON infostore.cid=? AND infostore_document.infostore_id=infostore.id AND infostore_document.cid=? WHERE " + where);
                stmt.setInt(1, ctx.getContextId());
                stmt.setInt(2, ctx.getContextId());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    DocumentMetadataImpl dm = new DocumentMetadataImpl();
                    this.fillDocumentMetadata(dm, this.switchMetadata2DBColumns(columns, true), rs);
                    result.add(dm);
                }
                this.close(stmt, rs);
            }
            catch (SQLException e) {
                LOG.error("SQLException", (Throwable)e);
                break block6;
            }
            finally {
                this.close(stmt, rs);
                this.releaseReadConnection(ctx, con);
            }
            this.releaseReadConnection(ctx, con);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DocumentMetadata> getAllDocuments(Context ctx, Metadata[] columns, String where) throws OXException {
        ArrayList<DocumentMetadata> result;
        block6: {
            result = new ArrayList<DocumentMetadata>();
            Connection con = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                con = this.getReadConnection(ctx);
                stmt = con.prepareStatement(this.getSQLSelectForInfostoreColumns(this.switchMetadata2DBColumns(columns, false)).toString() + " FROM infostore JOIN infostore_document ON infostore.cid=? AND infostore_document.infostore_id=infostore.id AND infostore_document.cid=? AND infostore_document.version_number = infostore.version WHERE " + where);
                stmt.setInt(1, ctx.getContextId());
                stmt.setInt(2, ctx.getContextId());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    DocumentMetadataImpl dm = new DocumentMetadataImpl();
                    this.fillDocumentMetadata(dm, this.switchMetadata2DBColumns(columns, true), rs);
                    result.add(dm);
                }
                this.close(stmt, rs);
            }
            catch (SQLException e) {
                LOG.error("SQLException", (Throwable)e);
                break block6;
            }
            finally {
                this.close(stmt, rs);
                this.releaseReadConnection(ctx, con);
            }
            this.releaseReadConnection(ctx, con);
        }
        return result;
    }

    public InputStream getDocument(int id, int version2, Context ctx) throws OXException {
        InputStream inputStream;
        ResultSet result;
        PreparedStatement stmt;
        Connection con;
        block7: {
            con = null;
            stmt = null;
            result = null;
            con = this.getReadConnection(ctx);
            if (version2 != -1) {
                stmt = con.prepareStatement("SELECT d.file_store_location, i.folder_id FROM infostore_document AS d JOIN infostore AS i ON d.cid=i.cid AND d.infostore_id=i.id WHERE d.cid=? AND d.infostore_id=? AND d.version_number=? AND d.file_store_location IS NOT NULL");
                stmt.setInt(3, version2);
            } else {
                stmt = con.prepareStatement("SELECT d.file_store_location, i.folder_id from infostore_document AS d JOIN infostore AS i ON i.cid=? AND i.id=? AND d.cid=? AND d.infostore_id=? AND d.version_number=i.version AND d.file_store_location is not null");
                stmt.setInt(3, ctx.getContextId());
                stmt.setInt(4, id);
            }
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, id);
            result = stmt.executeQuery();
            if (result.next()) break block7;
            InputStream inputStream2 = null;
            this.close(stmt, result);
            this.releaseReadConnection(ctx, con);
            return inputStream2;
        }
        try {
            String fileStorageLoaction = result.getString(1);
            int folderId = result.getInt(2);
            this.close(stmt, result);
            result = null;
            stmt = null;
            int folderOwner = new OXFolderAccess(con, ctx).getFolderOwner(folderId);
            this.releaseReadConnection(ctx, con);
            con = null;
            QuotaFileStorage fs = FileStorages.getQuotaFileStorageService().getQuotaFileStorage(folderOwner, ctx.getContextId());
            inputStream = fs.getFile(fileStorageLoaction);
        }
        catch (SQLException x) {
            try {
                throw InfostoreExceptionCodes.SQL_PROBLEM.create(x, DBUtils.getStatement(stmt));
            }
            catch (Throwable throwable) {
                this.close(stmt, result);
                this.releaseReadConnection(ctx, con);
                throw throwable;
            }
        }
        this.close(stmt, result);
        this.releaseReadConnection(ctx, con);
        return inputStream;
    }

    public int[] removeDocument(String identifier, Context ctx) throws OXException {
        return this.removeDocumentFromTable(identifier, ctx, "infostore");
    }

    private int[] removeDocumentFromTable(String identifier, Context ctx, String basetablename) throws OXException {
        String documentstable = basetablename.concat("_document");
        Connection writecon = this.getWriteConnection(ctx);
        int[] retval = new int[2];
        int version_nr = 0;
        int current_version = 0;
        int infostore_id = 0;
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            this.startDBTransaction();
            stmt = writecon.prepareStatement("SELECT version_number, infostore_id, version FROM " + documentstable + " JOIN " + basetablename + " ON " + basetablename + ".id = " + documentstable + ".infostore_id " + " AND file_store_location=? AND " + documentstable + ".cid=?");
            stmt.setString(1, identifier);
            stmt.setInt(2, ctx.getContextId());
            result = stmt.executeQuery();
            if (result.next()) {
                version_nr = result.getInt(1);
                infostore_id = result.getInt(2);
                current_version = result.getInt(3);
            }
            result.close();
            stmt.close();
            stmt = writecon.prepareStatement("SELECT version_number FROM " + documentstable + " WHERE infostore_id=? AND cid=?");
            stmt.setInt(1, infostore_id);
            stmt.setInt(2, ctx.getContextId());
            result = stmt.executeQuery();
            TreeSet<Integer> set = new TreeSet<Integer>();
            while (result.next()) {
                set.add(result.getInt(1));
            }
            set.remove(version_nr);
            stmt.close();
            if (version_nr == current_version) {
                stmt = writecon.prepareStatement("UPDATE " + basetablename + " SET version=? " + " WHERE id=? AND  " + basetablename + ".cid=?");
                stmt.setInt(1, (Integer)set.last());
                stmt.setInt(2, infostore_id);
                stmt.setInt(3, ctx.getContextId());
                retval[0] = stmt.executeUpdate();
                stmt.close();
            }
            stmt = writecon.prepareStatement("DELETE FROM " + documentstable + " WHERE cid=? AND file_store_location=?");
            stmt.setInt(1, ctx.getContextId());
            stmt.setString(2, identifier);
            retval[1] = stmt.executeUpdate();
            stmt.close();
            this.commitDBTransaction();
        }
        catch (SQLException e) {
            try {
                this.rollbackDBTransaction();
                throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, DBUtils.getStatement(stmt));
            }
            catch (Throwable throwable) {
                this.close(stmt, result);
                this.finishDBTransaction();
                this.releaseWriteConnection(ctx, writecon);
                throw throwable;
            }
        }
        this.close(stmt, result);
        this.finishDBTransaction();
        this.releaseWriteConnection(ctx, writecon);
        return retval;
    }

    public int getDocumentHolderFor(String fileIdentifier, Context ctx) throws OXException {
        int n;
        Connection con = this.getReadConnection(ctx);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement("SELECT t.created_from FROM infostore AS i JOIN infostore_document AS d ON i.cid=d.cid AND i.id=d.infostore_id JOIN oxfolder_tree AS t ON i.cid=t.cid AND i.folder_id=t.fuid WHERE i.cid=? AND d.file_store_location=?");
            stmt.setInt(1, ctx.getContextId());
            stmt.setString(2, fileIdentifier);
            rs = stmt.executeQuery();
            n = rs.next() ? rs.getInt(1) : -1;
        }
        catch (SQLException e) {
            try {
                throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, DBUtils.getStatement(stmt));
            }
            catch (Throwable throwable) {
                Databases.closeSQLStuff(rs, (Statement)stmt);
                this.releaseReadConnection(ctx, con);
                throw throwable;
            }
        }
        Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
        this.releaseReadConnection(ctx, con);
        return n;
    }

    public int modifyDocument(String oldidentifier, String newidentifier, String description, String mimetype, Context ctx) throws OXException {
        return this.modifyDocumentInTable(oldidentifier, newidentifier, description, mimetype, ctx, "infostore");
    }

    private int modifyDocumentInTable(String oldidentifier, String newidentifier, String description, String mimetype, Context ctx, String basetablename) throws OXException {
        String documentstable = basetablename.concat("_document");
        int retval = -1;
        Connection writecon = this.getWriteConnection(ctx);
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            this.startDBTransaction();
            String olddescription = null;
            stmt = writecon.prepareStatement("SELECT description FROM " + documentstable + " WHERE file_store_location=? AND cid=?");
            stmt.setString(1, oldidentifier);
            stmt.setInt(2, ctx.getContextId());
            result = stmt.executeQuery();
            if (result.next()) {
                olddescription = result.getString(1);
            }
            stmt.close();
            olddescription = olddescription == null ? description : olddescription.concat(description);
            stmt = writecon.prepareStatement("UPDATE " + documentstable + " SET file_store_location=?,  description=?, file_mimetype=? " + "WHERE file_store_location=? AND cid=?");
            stmt.setString(1, newidentifier);
            stmt.setString(2, olddescription);
            stmt.setString(3, mimetype);
            stmt.setString(4, oldidentifier);
            stmt.setInt(5, ctx.getContextId());
            retval = stmt.executeUpdate();
            stmt.close();
            this.commitDBTransaction();
        }
        catch (SQLException e) {
            try {
                this.rollbackDBTransaction();
                throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, DBUtils.getStatement(stmt));
            }
            catch (Throwable throwable) {
                this.close(stmt, result);
                this.finishDBTransaction();
                this.releaseWriteConnection(ctx, writecon);
                throw throwable;
            }
        }
        this.close(stmt, result);
        this.finishDBTransaction();
        this.releaseWriteConnection(ctx, writecon);
        return retval;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] saveDocumentMetadata(String identifier, DocumentMetadata document, User user, Context ctx) throws OXException {
        int[] retval = new int[3];
        PreparedStatement stmt = null;
        Connection writeCon = null;
        try {
            this.startDBTransaction();
            int folder_id = new OXFolderAccess(ctx).getDefaultFolderID(user.getId(), 8);
            writeCon = this.getWriteConnection(ctx);
            int infostore_id = IDGenerator.getId(ctx, 137, writeCon);
            Date date = new Date(System.currentTimeMillis());
            stmt = writeCon.prepareStatement("INSERT INTO infostore (cid, id, folder_id, version, locked_until, color_label, creating_date, last_modified, created_by, changed_by) VALUES (?,?,?,?,?,?,?,?,?,?)");
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, infostore_id);
            stmt.setInt(3, folder_id);
            stmt.setInt(4, 1);
            stmt.setNull(5, 4);
            stmt.setLong(6, document.getColorLabel());
            stmt.setLong(7, date.getTime());
            stmt.setLong(8, date.getTime());
            stmt.setInt(9, user.getId());
            stmt.setInt(10, user.getId());
            retval[0] = stmt.executeUpdate();
            stmt.close();
            stmt = writeCon.prepareStatement("INSERT INTO infostore_document (cid, infostore_id, version_number, creating_date, last_modified, created_by, changed_by, title, url, description, categories, filename) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)");
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, infostore_id);
            stmt.setInt(3, 0);
            stmt.setLong(4, date.getTime());
            stmt.setLong(5, date.getTime());
            stmt.setInt(6, user.getId());
            stmt.setInt(7, user.getId());
            stmt.setString(8, document.getTitle());
            stmt.setString(9, document.getURL());
            stmt.setString(10, document.getDescription());
            stmt.setString(11, document.getCategories());
            stmt.setString(12, document.getFileName());
            retval[1] = stmt.executeUpdate();
            stmt.close();
            stmt = writeCon.prepareStatement("INSERT INTO infostore_document (cid, infostore_id, version_number, creating_date, last_modified, created_by, changed_by, title, url, description, categories, filename, file_store_location, file_size, file_mimetype, file_md5sum) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, infostore_id);
            stmt.setInt(3, 1);
            stmt.setLong(4, date.getTime());
            stmt.setLong(5, date.getTime());
            stmt.setInt(6, user.getId());
            stmt.setInt(7, user.getId());
            stmt.setString(8, document.getTitle());
            stmt.setString(9, document.getURL());
            stmt.setString(10, document.getDescription());
            stmt.setString(11, document.getCategories());
            stmt.setString(12, document.getFileName());
            stmt.setString(13, identifier);
            stmt.setString(14, Long.toString(document.getFileSize()));
            stmt.setString(15, document.getFileMIMEType());
            stmt.setString(16, document.getFileMD5Sum());
            retval[2] = stmt.executeUpdate();
            document.setVersion(1);
            document.setId(infostore_id);
            this.commitDBTransaction();
        }
        catch (SQLException e) {
            try {
                this.rollbackDBTransaction();
                LOG.error("", (Throwable)e);
                throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, DBUtils.getStatement(stmt));
                catch (OXException e2) {
                    this.rollbackDBTransaction();
                    LOG.error("", (Throwable)e2);
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                this.close(stmt, null);
                this.finishDBTransaction();
                if (null == writeCon) throw throwable;
                this.releaseWriteConnection(ctx, writeCon);
                throw throwable;
            }
        }
        this.close(stmt, null);
        this.finishDBTransaction();
        if (null == writeCon) return retval;
        this.releaseWriteConnection(ctx, writeCon);
        return retval;
    }

    public TimedResult<DocumentMetadata> getDocuments(long folderId, Metadata[] columns, Metadata sort, int order, boolean onlyOwnObjects, Context ctx, User user) throws OXException {
        String onlyOwn = "";
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            if (onlyOwnObjects) {
                onlyOwn = " AND created_by=?";
            }
            int[] dbColumns = this.switchMetadata2DBColumns(columns, false);
            StringBuilder sql = new StringBuilder(this.getSQLSelectForInfostoreColumns(dbColumns));
            sql.append(" FROM infostore JOIN infostore_document ON infostore.cid=? AND infostore_document.cid=? AND infostore.id=infostore_document.infostore_id AND infostore_document.version_number=infostore.version AND infostore.folder_id=?");
            sql.append(onlyOwn);
            if (sort != null) {
                sql.append(" ORDER BY ");
                sql.append(INFOSTORE_DATACOLUMNS[this.switchMetadata2DBColumns(new Metadata[]{sort}, false)[0]]);
                if (order == 1) {
                    sql.append(" ASC");
                } else if (order == -1) {
                    sql.append(" DESC");
                }
            }
            con = this.getReadConnection(ctx);
            stmt = con.prepareStatement(sql.toString());
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, ctx.getContextId());
            stmt.setLong(3, folderId);
            if (onlyOwn.length() > 0) {
                stmt.setInt(4, user.getId());
            }
            result = stmt.executeQuery();
            return new InfostoreTimedResult(this.buildIterator(result, stmt, dbColumns, this, ctx, con, true));
        }
        catch (SQLException e) {
            this.close(stmt, result);
            this.releaseReadConnection(ctx, con);
            throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, DBUtils.getStatement(stmt));
        }
        catch (OXException e) {
            this.close(stmt, result);
            this.releaseReadConnection(ctx, con);
            throw InfostoreExceptionCodes.PREFETCH_FAILED.create(e, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet<String> getDocumentFileStoreLocationsperContext(Context ctx) throws OXException {
        Connection con = this.getReadConnection(ctx);
        try {
            SortedSet<String> sortedSet = this.getDocumentFileStoreLocationsperContext(ctx, con);
            return sortedSet;
        }
        finally {
            this.releaseReadConnection(ctx, con);
        }
    }

    public SortedSet<String> getDocumentFileStoreLocationsperContext(Context ctx, Connection con) throws OXException {
        TreeSet<String> treeSet;
        int contextId = ctx.getContextId();
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            TreeSet<String> fileStorageLocations;
            LinkedHashSet<Integer> userIds;
            stmt = con.prepareStatement("SELECT DISTINCT user.id FROM user WHERE user.cid=? AND user.filestore_id>0");
            stmt.setInt(1, contextId);
            result = stmt.executeQuery();
            if (result.next()) {
                userIds = new LinkedHashSet<Integer>(16, 0.9f);
                do {
                    userIds.add(result.getInt(1));
                } while (result.next());
            } else {
                userIds = null;
            }
            this.close(stmt, result);
            result = null;
            stmt = null;
            if (null == userIds) {
                stmt = con.prepareStatement("SELECT file_store_location FROM infostore_document WHERE infostore_document.cid=? AND file_store_location IS NOT NULL");
                stmt.setInt(1, contextId);
                result = stmt.executeQuery();
                fileStorageLocations = new TreeSet<String>();
                while (result.next()) {
                    fileStorageLocations.add(result.getString(1));
                }
            } else {
                stmt = con.prepareStatement("SELECT d.file_store_location FROM infostore_document AS d JOIN infostore AS i ON d.cid=i.cid AND d.infostore_id=i.id WHERE d.cid=? AND d.file_store_location IS NOT NULL AND i.folder_id NOT IN (SELECT t.fuid FROM oxfolder_tree AS t WHERE t.cid=? AND t.module=? AND t.created_from IN (SELECT DISTINCT user.id FROM user WHERE user.cid=? AND user.filestore_id>0))");
                stmt.setInt(1, contextId);
                stmt.setInt(2, contextId);
                stmt.setInt(3, 8);
                stmt.setInt(4, contextId);
                result = stmt.executeQuery();
                fileStorageLocations = new TreeSet();
                while (result.next()) {
                    fileStorageLocations.add(result.getString(1));
                }
                this.close(stmt, result);
                result = null;
                stmt = null;
                for (Integer userId : userIds) {
                    stmt = con.prepareStatement("SELECT d.file_store_location FROM infostore_document AS d JOIN infostore AS i ON d.cid=i.cid AND d.infostore_id=i.id WHERE d.cid=? AND d.file_store_location IS NOT NULL AND i.folder_id IN (SELECT t.fuid FROM oxfolder_tree AS t WHERE t.cid=? AND t.module=? AND t.created_from=?)");
                    stmt.setInt(1, contextId);
                    stmt.setInt(2, contextId);
                    stmt.setInt(3, 8);
                    stmt.setInt(4, userId);
                    result = stmt.executeQuery();
                    while (result.next()) {
                        fileStorageLocations.add(result.getString(1));
                    }
                    this.close(stmt, result);
                    result = null;
                    stmt = null;
                }
            }
            treeSet = fileStorageLocations;
        }
        catch (SQLException e) {
            try {
                LOG.error("", (Throwable)e);
                throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, DBUtils.getStatement(stmt));
            }
            catch (Throwable throwable) {
                this.close(stmt, result);
                throw throwable;
            }
        }
        this.close(stmt, result);
        return treeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet<String> getDocumentFileStoreLocationsPerUser(Context ctx, User usr) throws OXException {
        Connection connection = this.getReadConnection(ctx);
        try {
            SortedSet<String> sortedSet = this.getDocumentFileStoreLocationsPerUser(ctx, usr, connection);
            return sortedSet;
        }
        finally {
            this.releaseReadConnection(ctx, connection);
        }
    }

    private SortedSet<String> getDocumentFileStoreLocationsPerUser(Context ctx, User usr, Connection connection) throws OXException {
        TreeSet<String> treeSet;
        int contextId = ctx.getContextId();
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            TreeSet<String> fileStorageLocations = new TreeSet<String>();
            stmt = connection.prepareStatement("SELECT d.file_store_location FROM infostore_document AS d JOIN infostore AS i ON d.cid=i.cid AND d.infostore_id=i.id WHERE d.cid=? AND d.file_store_location IS NOT NULL AND i.folder_id IN (SELECT t.fuid FROM oxfolder_tree AS t WHERE t.cid=? AND t.module=? AND t.created_from=?)");
            stmt.setInt(1, contextId);
            stmt.setInt(2, contextId);
            stmt.setInt(3, 8);
            stmt.setInt(4, usr.getId());
            result = stmt.executeQuery();
            while (result.next()) {
                fileStorageLocations.add(result.getString(1));
            }
            this.close(stmt, result);
            result = null;
            stmt = null;
            treeSet = fileStorageLocations;
        }
        catch (SQLException e) {
            try {
                LOG.error("", (Throwable)e);
                throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, DBUtils.getStatement(stmt));
            }
            catch (Throwable throwable) {
                this.close(stmt, result);
                throw throwable;
            }
        }
        this.close(stmt, result);
        return treeSet;
    }

    public TimedResult<DocumentMetadata> getVersions(int id, Metadata[] columns, Metadata sort, int order, Context ctx) throws OXException {
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            int[] dbColumns = this.switchMetadata2DBColumns(columns, true);
            StringBuilder sql = new StringBuilder(this.getSQLSelectForInfostoreColumns(dbColumns).toString());
            sql.append(" FROM infostore JOIN infostore_document ON infostore.cid=? AND infostore.id=? AND infostore_document.infostore_id=? AND infostore_document.cid=?");
            if (sort != null) {
                sql.append(" ORDER BY ");
                sql.append(INFOSTORE_DATACOLUMNS[this.switchMetadata2DBColumns(new Metadata[]{sort}, true)[0]]);
                if (order == 1) {
                    sql.append(" ASC");
                } else if (order == -1) {
                    sql.append(" DESC");
                }
            }
            con = this.getReadConnection(ctx);
            stmt = con.prepareStatement(sql.toString());
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, id);
            stmt.setInt(3, id);
            stmt.setInt(4, ctx.getContextId());
            result = stmt.executeQuery();
            return new InfostoreTimedResult(this.buildIterator(result, stmt, dbColumns, this, ctx, con, true));
        }
        catch (SQLException e) {
            this.close(stmt, result);
            this.releaseReadConnection(ctx, con);
            throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, DBUtils.getStatement(stmt));
        }
        catch (OXException e) {
            this.close(stmt, result);
            this.releaseReadConnection(ctx, con);
            throw InfostoreExceptionCodes.PREFETCH_FAILED.create(e, new Object[0]);
        }
    }

    public TimedResult<DocumentMetadata> getDocuments(int[] ids, Metadata[] columns, Context ctx) throws OXException {
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            int i;
            con = this.getReadConnection(ctx);
            int[] dbColumns = this.switchMetadata2DBColumns(columns, false);
            StringBuilder SQL_JOIN = new StringBuilder(this.getSQLSelectForInfostoreColumns(dbColumns));
            SQL_JOIN.append(" FROM infostore JOIN infostore_document ON infostore.cid=? AND infostore_document.cid=? AND infostore.id=infostore_document.infostore_id AND infostore_document.version_number=infostore.version AND (");
            for (i = 0; i < ids.length; ++i) {
                SQL_JOIN.append("infostore.id=?");
                if (i >= ids.length - 1) continue;
                SQL_JOIN.append(" OR ");
            }
            SQL_JOIN.append(") ");
            stmt = con.prepareStatement(SQL_JOIN.toString());
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, ctx.getContextId());
            for (i = 0; i < ids.length; ++i) {
                stmt.setInt(i + 3, ids[i]);
            }
            result = stmt.executeQuery();
            return new InfostoreTimedResult(this.buildIterator(result, stmt, dbColumns, this, ctx, con, true));
        }
        catch (SQLException e) {
            this.close(stmt, result);
            this.releaseReadConnection(ctx, con);
            throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, DBUtils.getStatement(stmt));
        }
        catch (OXException e) {
            this.close(stmt, result);
            this.releaseReadConnection(ctx, con);
            throw InfostoreExceptionCodes.PREFETCH_FAILED.create(e, new Object[0]);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Delta<DocumentMetadata> getDelta(long folderId, long updateSince, Metadata[] columns, Metadata sort, int order, boolean onlyOwnObjects, Context ctx, User user) throws OXException {
        DeltaImpl retval = null;
        String onlyOwn = "";
        StringBuilder ORDER = new StringBuilder();
        if (sort != null) {
            ORDER.append(" ORDER BY ");
            ORDER.append(INFOSTORE_DATACOLUMNS[this.switchMetadata2DBColumns(new Metadata[]{sort}, false)[0]]);
            if (order == 1) {
                ORDER.append(" ASC");
            } else if (order == -1) {
                ORDER.append(" DESC");
            }
        }
        Connection con = null;
        PreparedStatement stmtNew = null;
        PreparedStatement stmtModified = null;
        PreparedStatement stmtDeleted = null;
        ResultSet resultNew = null;
        ResultSet resultModified = null;
        ResultSet resultDeleted = null;
        try {
            con = this.getReadConnection(ctx);
            if (onlyOwnObjects) {
                onlyOwn = " AND created_by=?";
            }
            int[] dbColumns = this.switchMetadata2DBColumns(columns, false);
            StringBuilder SELECT = new StringBuilder(this.getSQLSelectForInfostoreColumns(dbColumns));
            StringBuilder JOIN_NEW = new StringBuilder(" FROM infostore JOIN infostore_document ON infostore.cid=? AND infostore_document.cid=? AND infostore_document.infostore_id=infostore.id AND infostore_document.version_number = infostore.version AND infostore.folder_id=? AND infostore.creating_date>?").append(onlyOwn);
            StringBuilder JOIN_MODIFIED = new StringBuilder(" FROM infostore JOIN infostore_document ON infostore.cid=? AND infostore_document.cid=? AND infostore_document.infostore_id=infostore.id  AND infostore_document.version_number = infostore.version AND infostore.folder_id=? AND infostore.last_modified>? AND infostore.creating_date<infostore.last_modified").append(onlyOwn);
            StringBuilder DELETE_SELECT = new StringBuilder("SELECT id FROM del_infostore WHERE cid=? AND folder_id=? AND last_modified>?").append(onlyOwn);
            stmtNew = con.prepareStatement(SELECT.toString() + JOIN_NEW.toString() + ORDER.toString());
            stmtNew.setInt(1, ctx.getContextId());
            stmtNew.setInt(2, ctx.getContextId());
            stmtNew.setLong(3, folderId);
            stmtNew.setLong(4, updateSince);
            if (onlyOwn.length() > 0) {
                stmtNew.setInt(5, user.getId());
            }
            resultNew = stmtNew.executeQuery();
            stmtModified = con.prepareStatement(SELECT.toString() + JOIN_MODIFIED.toString() + ORDER.toString());
            stmtModified.setInt(1, ctx.getContextId());
            stmtModified.setInt(2, ctx.getContextId());
            stmtModified.setLong(3, folderId);
            stmtModified.setLong(4, updateSince);
            if (onlyOwn.length() > 0) {
                stmtModified.setInt(5, user.getId());
            }
            resultModified = stmtModified.executeQuery();
            stmtDeleted = con.prepareStatement(DELETE_SELECT.toString() + ORDER.toString());
            stmtDeleted.setInt(1, ctx.getContextId());
            stmtDeleted.setLong(2, folderId);
            stmtDeleted.setLong(3, updateSince);
            if (onlyOwn.length() > 0) {
                stmtDeleted.setInt(4, user.getId());
            }
            resultDeleted = stmtDeleted.executeQuery();
            SearchIterator<DocumentMetadata> isiNew = this.buildIterator(resultNew, stmtNew, dbColumns, this, ctx, con, false);
            SearchIterator<DocumentMetadata> isiModified = this.buildIterator(resultModified, stmtModified, dbColumns, this, ctx, con, false);
            SearchIterator<DocumentMetadata> isiDeleted = this.buildIterator(resultDeleted, stmtDeleted, new int[]{1}, this, ctx, con, false);
            retval = new DeltaImpl(isiNew, isiModified, isiDeleted, System.currentTimeMillis());
        }
        catch (SQLException e) {
            try {
                throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, DBUtils.getStatement(stmtNew));
                catch (OXException e2) {
                    throw InfostoreExceptionCodes.PREFETCH_FAILED.create(e2, new Object[0]);
                }
            }
            catch (Throwable throwable) {
                if (!FETCH.equals((Object)Fetch.PREFETCH)) throw throwable;
                this.close(stmtNew, resultNew);
                this.close(stmtModified, resultModified);
                this.close(stmtDeleted, resultDeleted);
                this.releaseReadConnection(ctx, con);
                throw throwable;
            }
        }
        if (!FETCH.equals((Object)Fetch.PREFETCH)) return retval;
        this.close(stmtNew, resultNew);
        this.close(stmtModified, resultModified);
        this.close(stmtDeleted, resultDeleted);
        this.releaseReadConnection(ctx, con);
        return retval;
    }

    public int countDocuments(long folderId, boolean onlyOwnObjects, Context ctx, User user) throws OXException {
        ResultSet result;
        PreparedStatement stmt;
        Connection con;
        block6: {
            int n;
            con = null;
            stmt = null;
            result = null;
            try {
                con = this.getReadConnection(ctx);
                StringBuilder SQL2 = new StringBuilder("SELECT count(id) from infostore where infostore.cid=? AND infostore.folder_id=?");
                if (onlyOwnObjects) {
                    SQL2.append(" AND infostore.created_by=?");
                }
                stmt = con.prepareStatement(SQL2.toString());
                stmt.setInt(1, ctx.getContextId());
                stmt.setLong(2, folderId);
                if (onlyOwnObjects) {
                    stmt.setInt(3, user.getId());
                }
                if (!(result = stmt.executeQuery()).next()) break block6;
                n = result.getInt(1);
            }
            catch (SQLException e) {
                try {
                    throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, DBUtils.getStatement(stmt));
                }
                catch (Throwable throwable) {
                    this.close(stmt, result);
                    this.releaseReadConnection(ctx, con);
                    throw throwable;
                }
            }
            this.close(stmt, result);
            this.releaseReadConnection(ctx, con);
            return n;
        }
        this.close(stmt, result);
        this.releaseReadConnection(ctx, con);
        return 0;
    }

    public int countDocumentsperContext(Context ctx) throws OXException {
        int retval = 0;
        Connection con = this.getReadConnection(ctx);
        try {
            StringBuilder SQL2 = new StringBuilder("SELECT count(id) from infostore where infostore.cid=?");
            PreparedStatement stmt = con.prepareStatement(SQL2.toString());
            stmt.setInt(1, ctx.getContextId());
            ResultSet result = stmt.executeQuery();
            if (result.next()) {
                retval = result.getInt(1);
            }
            result.close();
            stmt.close();
        }
        catch (SQLException e) {
            LOG.error("", (Throwable)e);
            throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, "");
        }
        finally {
            this.releaseReadConnection(ctx, con);
        }
        return retval;
    }

    public boolean hasFolderForeignObjects(long folderId, Context ctx, User user) throws OXException {
        boolean retval = true;
        Connection con = this.getReadConnection(ctx);
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement("SELECT id FROM infostore WHERE cid=? AND folder_id=? AND created_by!=?");
            stmt.setInt(1, ctx.getContextId());
            stmt.setLong(2, folderId);
            stmt.setInt(3, user.getId());
            result = stmt.executeQuery();
            retval = result.next();
        }
        catch (SQLException e) {
            try {
                LOG.error("", (Throwable)e);
                throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, DBUtils.getStatement(stmt));
            }
            catch (Throwable throwable) {
                this.close(stmt, result);
                this.releaseReadConnection(ctx, con);
                throw throwable;
            }
        }
        this.close(stmt, result);
        this.releaseReadConnection(ctx, con);
        return retval;
    }

    public boolean isFolderEmpty(long folderId, Context ctx) throws OXException {
        boolean retval = false;
        Connection con = this.getReadConnection(ctx);
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement("SELECT count(id) FROM infostore WHERE cid=? AND folder_id=?");
            stmt.setInt(1, ctx.getContextId());
            stmt.setLong(2, folderId);
            result = stmt.executeQuery();
            if (result.next() && result.getInt(1) <= 0) {
                retval = true;
            }
        }
        catch (SQLException e) {
            try {
                LOG.error("", (Throwable)e);
                throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, DBUtils.getStatement(stmt));
            }
            catch (Throwable throwable) {
                this.close(stmt, result);
                this.releaseReadConnection(ctx, con);
                throw throwable;
            }
        }
        this.close(stmt, result);
        this.releaseReadConnection(ctx, con);
        return retval;
    }

    public void removeUser(int id, Context ctx, ServerSession session, EntityLockManager locks) throws OXException {
        if (id != ctx.getMailadmin()) {
            this.removePrivate(id, ctx, session);
            this.assignToAdmin(id, ctx);
        } else {
            this.removeAll(ctx, session);
        }
        this.removeFromDel(id, ctx);
        locks.transferLocks(ctx, id, ctx.getMailadmin());
    }

    private void removeFromDel(int id, Context ctx) throws OXException {
        Connection writeCon = null;
        Statement stmt = null;
        StringBuilder query = new StringBuilder("NO QUERY");
        try {
            writeCon = this.getWriteConnection(ctx);
            stmt = writeCon.createStatement();
            for (String table : new String[]{"del_infostore", "del_infostore_document"}) {
                query = new StringBuilder("DELETE FROM ").append(table).append(" WHERE cid = ").append(ctx.getContextId()).append(" AND created_by = ").append(id);
                stmt.executeUpdate(query.toString());
            }
        }
        catch (SQLException x) {
            try {
                throw InfostoreExceptionCodes.SQL_PROBLEM.create(x, query.toString());
            }
            catch (Throwable throwable) {
                Databases.closeSQLStuff(stmt);
                if (writeCon != null) {
                    this.releaseWriteConnection(ctx, writeCon);
                }
                throw throwable;
            }
        }
        Databases.closeSQLStuff((Statement)stmt);
        if (writeCon != null) {
            this.releaseWriteConnection(ctx, writeCon);
        }
    }

    private void removeAll(Context ctx, ServerSession session) throws OXException {
        ArrayList<DocumentMetadata> documents = new ArrayList<DocumentMetadata>();
        com.openexchange.groupware.infostore.database.impl.InfostoreIterator iter = com.openexchange.groupware.infostore.database.impl.InfostoreIterator.allDocumentsWhere(" infostore.cid = " + ctx.getContextId(), Metadata.VALUES_ARRAY, this, ctx);
        if (!iter.hasNext()) {
            return;
        }
        while (iter.hasNext()) {
            DocumentMetadata metadata = (DocumentMetadata)iter.next();
            documents.add(metadata);
        }
        ArrayList<DocumentMetadata> versions = new ArrayList<DocumentMetadata>();
        iter = com.openexchange.groupware.infostore.database.impl.InfostoreIterator.allVersionsWhere(" infostore.cid = " + ctx.getContextId(), Metadata.VALUES_ARRAY, this, ctx);
        while (iter.hasNext()) {
            DocumentMetadata metadata = (DocumentMetadata)iter.next();
            versions.add(metadata);
        }
        InfostoreQueryCatalog catalog = InfostoreQueryCatalog.getInstance();
        DeleteAllDocumentsAction deleteDocumentAction = new DeleteAllDocumentsAction(session);
        deleteDocumentAction.setProvider(this);
        deleteDocumentAction.setContext(ctx);
        deleteDocumentAction.setDocuments(documents);
        deleteDocumentAction.setQueryCatalog(catalog);
        DeleteAllVersionsAction deleteVersionAction = new DeleteAllVersionsAction(session);
        deleteVersionAction.setProvider(this);
        deleteVersionAction.setContext(ctx);
        deleteVersionAction.setDocuments(versions);
        deleteVersionAction.setQueryCatalog(catalog);
        deleteVersionAction.perform();
        try {
            deleteDocumentAction.perform();
        }
        catch (OXException e) {
            try {
                deleteVersionAction.undo();
                throw e;
            }
            catch (OXException e1) {
                LOG.error("Can't roll back deleting versions. Run the consistency tool.", (Throwable)e1);
            }
        }
        ArrayList<String> files = new ArrayList<String>(versions.size());
        for (DocumentMetadata version2 : versions) {
            if (null == version2.getFilestoreLocation()) continue;
            files.add(version2.getFilestoreLocation());
        }
        if (!files.isEmpty()) {
            List<FileStorage> fileStorages = this.getFileStorages(ctx);
            for (String fileId : files) {
                for (FileStorage fileStorage : fileStorages) {
                    try {
                        fileStorage.deleteFile(fileId);
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    private void removePrivate(int id, Context ctx, ServerSession session) throws OXException {
        PreparedStatementHolder holder = null;
        try {
            List<FolderObject> foldersWithPrivateItems = new DelUserFolderDiscoverer(this).discoverFolders(id, ctx);
            if (foldersWithPrivateItems.size() == 0) {
                return;
            }
            LinkedList<String> files = new LinkedList<String>();
            holder = new PreparedStatementHolder(this.getWriteConnection(session.getContext()));
            for (FolderObject folder : foldersWithPrivateItems) {
                this.clearFolder(folder, session, files, holder);
            }
            if (!files.isEmpty()) {
                List<FileStorage> fileStorages = this.getFileStorages(ctx);
                for (String fileId : files) {
                    for (FileStorage fileStorage : fileStorages) {
                        try {
                            fileStorage.deleteFile(fileId);
                        }
                        catch (Exception e) {}
                    }
                }
            }
        }
        catch (SQLException x) {
            LOG.error("", (Throwable)x);
            throw InfostoreExceptionCodes.SQL_PROBLEM.create(x, x.toString());
        }
        catch (OXException x) {
            throw x;
        }
        finally {
            if (holder != null) {
                holder.close();
                this.releaseWriteConnection(session.getContext(), holder.getConnection());
            }
        }
    }

    private void clearFolder(FolderObject folder, ServerSession session, List<String> files, PreparedStatementHolder holder) throws OXException, SQLException {
        com.openexchange.groupware.infostore.database.impl.InfostoreIterator allDocumentsInFolder = com.openexchange.groupware.infostore.database.impl.InfostoreIterator.documents(folder.getObjectID(), Metadata.VALUES_ARRAY, Metadata.ID_LITERAL, 1, -1, -1, this, session.getContext());
        ArrayList<DocumentMetadata> parents = new ArrayList<DocumentMetadata>();
        while (allDocumentsInFolder.hasNext()) {
            DocumentMetadata documentMetadata = allDocumentsInFolder.next();
            parents.add(documentMetadata);
            this.discoverAllFiles(documentMetadata, session, files);
        }
        InfostoreQueryCatalog queries = InfostoreQueryCatalog.getInstance();
        List<String> parentDeletes = queries.getSingleDelete(InfostoreQueryCatalog.Table.INFOSTORE);
        String allChildrenDelete = queries.getAllVersionsDelete(InfostoreQueryCatalog.Table.INFOSTORE_DOCUMENT);
        Integer contextId = Autoboxing.I((int)session.getContextId());
        for (DocumentMetadata documentMetadata : parents) {
            Integer id = Autoboxing.I((int)documentMetadata.getId());
            holder.execute(allChildrenDelete, id, contextId);
            for (String parentDelete : parentDeletes) {
                holder.execute(parentDelete, id, contextId);
            }
        }
    }

    private void discoverAllFiles(DocumentMetadata documentMetadata, ServerSession session, List<String> files) throws OXException {
        com.openexchange.groupware.infostore.database.impl.InfostoreIterator allVersions = com.openexchange.groupware.infostore.database.impl.InfostoreIterator.versions(documentMetadata.getId(), Metadata.VALUES_ARRAY, Metadata.ID_LITERAL, 1, this, session.getContext());
        while (allVersions.hasNext()) {
            DocumentMetadata version2 = allVersions.next();
            String filestoreLocation = version2.getFilestoreLocation();
            if (filestoreLocation == null) continue;
            files.add(filestoreLocation);
        }
    }

    private void assignToAdmin(int id, Context ctx) throws OXException {
        Connection writeCon = null;
        Statement stmt = null;
        StringBuilder query = null;
        try {
            writeCon = this.getWriteConnection(ctx);
            stmt = writeCon.createStatement();
            for (String table : tables) {
                for (String userField : userFields) {
                    query = new StringBuilder("UPDATE ").append(table).append(" SET ").append(userField).append(" = ").append(ctx.getMailadmin()).append(" WHERE cid = ").append(ctx.getContextId()).append(" AND ").append(userField).append(" = ").append(id);
                    stmt.executeUpdate(query.toString());
                }
            }
        }
        catch (SQLException e) {
            throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, query != null ? query.toString() : "");
        }
        catch (OXException e) {
            throw e;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    LOG.debug("", (Throwable)e);
                }
            }
            if (null != writeCon) {
                this.releaseWriteConnection(ctx, writeCon);
            }
        }
    }

    private StringBuffer getSQLSelectForInfostoreColumns(int[] columns) {
        String delete = "";
        StringBuffer select = new StringBuffer("SELECT ");
        for (int i = 0; i < columns.length; ++i) {
            select.append(delete);
            select.append(INFOSTORE_DATACOLUMNS[columns[i]]);
            if (i >= columns.length - 1) continue;
            select.append(", ");
        }
        return select;
    }

    private int[] switchMetadata2DBColumns(Metadata[] columns, boolean versionPriorityHigh) {
        int[] retval = new int[columns.length];
        block24: for (int i = 0; i < columns.length; ++i) {
            switch (columns[i].getId()) {
                default: {
                    continue block24;
                }
                case 5: {
                    if (versionPriorityHigh) {
                        retval[i] = 14;
                        continue block24;
                    }
                    retval[i] = 6;
                    continue block24;
                }
                case 6: {
                    if (versionPriorityHigh) {
                        retval[i] = 14;
                        continue block24;
                    }
                    retval[i] = 6;
                    continue block24;
                }
                case 4: {
                    if (versionPriorityHigh) {
                        retval[i] = 13;
                        continue block24;
                    }
                    retval[i] = 5;
                    continue block24;
                }
                case 3: {
                    if (versionPriorityHigh) {
                        retval[i] = 16;
                        continue block24;
                    }
                    retval[i] = 8;
                    continue block24;
                }
                case 2: {
                    if (versionPriorityHigh) {
                        retval[i] = 15;
                        continue block24;
                    }
                    retval[i] = 7;
                    continue block24;
                }
                case 20: {
                    retval[i] = 2;
                    continue block24;
                }
                case 705: {
                    if (versionPriorityHigh) {
                        retval[i] = 12;
                        continue block24;
                    }
                    retval[i] = 3;
                    continue block24;
                }
                case 700: {
                    retval[i] = 17;
                    continue block24;
                }
                case 702: {
                    retval[i] = 21;
                    continue block24;
                }
                case 751: {
                    retval[i] = 14;
                    continue block24;
                }
                case 1: {
                    retval[i] = 1;
                    continue block24;
                }
                case 102: {
                    retval[i] = 9;
                    continue block24;
                }
                case 704: {
                    retval[i] = 23;
                    continue block24;
                }
                case 703: {
                    retval[i] = 24;
                    continue block24;
                }
                case 706: {
                    retval[i] = 19;
                    continue block24;
                }
                case 707: {
                    retval[i] = 4;
                    continue block24;
                }
                case 701: {
                    retval[i] = 18;
                    continue block24;
                }
                case 100: {
                    retval[i] = 20;
                    continue block24;
                }
                case 708: {
                    retval[i] = 25;
                    continue block24;
                }
                case 709: {
                    retval[i] = 26;
                    continue block24;
                }
                case 710: {
                    retval[i] = 3;
                    continue block24;
                }
                case 752: {
                    retval[i] = 22;
                }
            }
        }
        return retval;
    }

    final DocumentMetadataImpl fillDocumentMetadata(DocumentMetadataImpl dmi, int[] columns, ResultSet result) throws SQLException {
        int currentVersion = -1;
        int versionNumber = -1;
        block29: for (int i = 0; i < columns.length; ++i) {
            switch (columns[i]) {
                default: {
                    continue block29;
                }
                case 0: {
                    continue block29;
                }
                case 1: {
                    dmi.setId(result.getInt(i + 1));
                    continue block29;
                }
                case 2: {
                    dmi.setFolderId(result.getInt(i + 1));
                    continue block29;
                }
                case 3: {
                    currentVersion = result.getInt(i + 1);
                    continue block29;
                }
                case 4: {
                    dmi.setLockedUntil(new Date(result.getLong(i + 1)));
                    if (!result.wasNull()) continue block29;
                    dmi.setLockedUntil(null);
                    continue block29;
                }
                case 5: {
                    dmi.setCreationDate(new Date(result.getLong(i + 1)));
                    continue block29;
                }
                case 6: {
                    dmi.setLastModified(new Date(result.getLong(i + 1)));
                    continue block29;
                }
                case 7: {
                    dmi.setCreatedBy(result.getInt(i + 1));
                    continue block29;
                }
                case 8: {
                    dmi.setModifiedBy(result.getInt(i + 1));
                    continue block29;
                }
                case 9: {
                    dmi.setColorLabel(result.getInt(i + 1));
                    continue block29;
                }
                case 10: {
                    continue block29;
                }
                case 11: {
                    continue block29;
                }
                case 12: {
                    versionNumber = result.getInt(i + 1);
                    continue block29;
                }
                case 13: {
                    dmi.setCreationDate(new Date(result.getLong(i + 1)));
                    continue block29;
                }
                case 14: {
                    dmi.setLastModified(new Date(result.getLong(i + 1)));
                    continue block29;
                }
                case 15: {
                    dmi.setCreatedBy(result.getInt(i + 1));
                    continue block29;
                }
                case 16: {
                    dmi.setModifiedBy(result.getInt(i + 1));
                    continue block29;
                }
                case 17: {
                    dmi.setTitle(result.getString(i + 1));
                    continue block29;
                }
                case 18: {
                    dmi.setURL(result.getString(i + 1));
                    continue block29;
                }
                case 19: {
                    dmi.setDescription(result.getString(i + 1));
                    continue block29;
                }
                case 20: {
                    dmi.setCategories(result.getString(i + 1));
                    continue block29;
                }
                case 21: {
                    dmi.setFileName(result.getString(i + 1));
                    continue block29;
                }
                case 22: {
                    dmi.setFilestoreLocation(result.getString(i + 1));
                    continue block29;
                }
                case 23: {
                    dmi.setFileSize(result.getLong(i + 1));
                    continue block29;
                }
                case 24: {
                    dmi.setFileMIMEType(result.getString(i + 1));
                    continue block29;
                }
                case 25: {
                    dmi.setFileMD5Sum(result.getString(i + 1));
                    continue block29;
                }
                case 26: {
                    dmi.setVersionComment(result.getString(i + 1));
                }
            }
        }
        if (currentVersion != -1 && versionNumber != -1) {
            if (currentVersion == versionNumber) {
                dmi.setIsCurrentVersion(true);
            }
            dmi.setVersion(versionNumber);
        } else if (versionNumber != -1) {
            dmi.setVersion(versionNumber);
        } else if (currentVersion != -1) {
            dmi.setVersion(currentVersion);
        }
        return dmi;
    }

    protected List<FileStorage> getFileStorages(Context ctx) throws OXException {
        return FileStorages.getFileStorage2EntitiesResolver().getFileStoragesUsedBy(ctx.getContextId(), true);
    }

    protected FileStorage getFileStorage(int folderOwner, int contextId) throws OXException {
        return FileStorages.getQuotaFileStorageService().getQuotaFileStorage(folderOwner, contextId);
    }

    @Override
    public void startTransaction() throws OXException {
        this.fileIdRemoveList.set(new ArrayList());
        this.fileIdAddList.set(new ArrayList());
        super.startTransaction();
    }

    @Override
    public void commit() throws OXException {
        List<FileInfo> list = this.fileIdRemoveList.get();
        if (null != list && !list.isEmpty()) {
            if (1 == list.size()) {
                FileInfo removeInfo = list.get(0);
                this.getFileStorage(removeInfo.folderAdmin, removeInfo.contextId).deleteFile(removeInfo.fileId);
            } else {
                HashMap<FileStorage, ArrayList<String>> removalsPerStorage = new HashMap<FileStorage, ArrayList<String>>();
                for (FileInfo fileInfo : list) {
                    FileStorage fileStorage = this.getFileStorage(fileInfo.folderAdmin, fileInfo.contextId);
                    ArrayList<String> removals = (ArrayList<String>)removalsPerStorage.get(fileStorage);
                    if (null == removals) {
                        removals = new ArrayList<String>();
                        removalsPerStorage.put(fileStorage, removals);
                    }
                    removals.add(fileInfo.fileId);
                }
                for (Map.Entry entry : removalsPerStorage.entrySet()) {
                    ((FileStorage)entry.getKey()).deleteFiles(((List)entry.getValue()).toArray(new String[((List)entry.getValue()).size()]));
                }
            }
        }
        super.commit();
    }

    @Override
    public void finish() throws OXException {
        this.fileIdRemoveList.set(null);
        this.fileIdAddList.set(null);
        super.finish();
    }

    @Override
    public void rollback() throws OXException {
        List<FileInfo> list = this.fileIdAddList.get();
        if (null != list && !list.isEmpty()) {
            if (1 == list.size()) {
                FileInfo removeInfo = list.get(0);
                this.getFileStorage(removeInfo.folderAdmin, removeInfo.contextId).deleteFile(removeInfo.fileId);
            } else {
                HashMap<FileStorage, ArrayList<String>> removalsPerStorage = new HashMap<FileStorage, ArrayList<String>>();
                for (FileInfo fileInfo : list) {
                    FileStorage fileStorage = this.getFileStorage(fileInfo.folderAdmin, fileInfo.contextId);
                    ArrayList<String> removals = (ArrayList<String>)removalsPerStorage.get(fileStorage);
                    if (null == removals) {
                        removals = new ArrayList<String>();
                        removalsPerStorage.put(fileStorage, removals);
                    }
                    removals.add(fileInfo.fileId);
                }
                for (Map.Entry entry : removalsPerStorage.entrySet()) {
                    ((FileStorage)entry.getKey()).deleteFiles(((List)entry.getValue()).toArray(new String[((List)entry.getValue()).size()]));
                }
            }
        }
        super.rollback();
    }

    private SearchIterator<DocumentMetadata> buildIterator(ResultSet result, PreparedStatement stmt, int[] dbColumns, DatabaseImpl service, Context ctx, Connection con, boolean closeIfPossible) throws OXException, SQLException {
        return this.fetchMode.buildIterator(result, stmt, dbColumns, service, ctx, con, closeIfPossible);
    }

    public int getMaxActiveVersion(int id, Context context, List<DocumentMetadata> ignoreVersions) throws OXException {
        int i$2;
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        block9: {
            con = null;
            stmt = null;
            rs = null;
            StringBuilder ignoreVersionsList = new StringBuilder(ignoreVersions.size() * 4 + 2);
            ignoreVersionsList.append('(');
            for (DocumentMetadata documentMetadata : ignoreVersions) {
                ignoreVersionsList.append(documentMetadata.getVersion()).append(',');
            }
            ignoreVersionsList.setCharAt(ignoreVersionsList.length() - 1, ')');
            con = this.getReadConnection(context);
            stmt = con.prepareStatement("SELECT max(version_number) FROM infostore_document WHERE cid = ? and infostore_id = ? AND NOT version_number IN " + ignoreVersionsList);
            stmt.setInt(1, context.getContextId());
            stmt.setInt(2, id);
            rs = stmt.executeQuery();
            if (!rs.next()) break block9;
            int i$2 = rs.getInt(1);
            this.close(stmt, rs);
            if (con != null) {
                this.releaseReadConnection(context, con);
            }
            return i$2;
        }
        try {
            i$2 = -1;
        }
        catch (SQLException e) {
            try {
                throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, DBUtils.getStatement(stmt));
            }
            catch (Throwable throwable) {
                this.close(stmt, rs);
                if (con != null) {
                    this.releaseReadConnection(context, con);
                }
                throw throwable;
            }
        }
        this.close(stmt, rs);
        if (con != null) {
            this.releaseReadConnection(context, con);
        }
        return i$2;
    }

    public static class InfostoreIterator
    implements SearchIterator<DocumentMetadata> {
        private DocumentMetadata next;
        private Statement stmt;
        private ResultSet rs;
        private final int[] columns;
        private final DatabaseImpl d;
        private Context ctx;
        private Connection readCon;
        private final List<OXException> warnings = new ArrayList<OXException>(2);

        public InfostoreIterator(ResultSet rs, Statement stmt, int[] columns, DatabaseImpl d, Context ctx, Connection readCon) throws OXException {
            this.rs = rs;
            this.stmt = stmt;
            this.columns = columns;
            this.d = d;
            this.ctx = ctx;
            this.readCon = readCon;
            try {
                if (rs.next()) {
                    this.next = d.fillDocumentMetadata(new DocumentMetadataImpl(), columns, rs);
                } else {
                    this.close();
                }
            }
            catch (SQLException e) {
                throw SearchIteratorExceptionCodes.SQL_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
        }

        public InfostoreIterator(ResultSet rs, int[] columns, DatabaseImpl d) {
            this.rs = rs;
            this.columns = columns;
            this.d = d;
        }

        public boolean hasNext() throws OXException {
            return this.next != null;
        }

        public int size() {
            return -1;
        }

        public boolean hasSize() {
            return false;
        }

        public DocumentMetadata next() throws OXException, OXException {
            try {
                DocumentMetadata retval = null;
                retval = this.next;
                if (this.rs.next()) {
                    this.next = this.d.fillDocumentMetadata(new DocumentMetadataImpl(), this.columns, this.rs);
                    while (this.next == null && this.rs.next()) {
                        this.next = this.d.fillDocumentMetadata(new DocumentMetadataImpl(), this.columns, this.rs);
                    }
                    if (this.next == null) {
                        this.close();
                    }
                } else {
                    this.close();
                }
                return retval;
            }
            catch (SQLException exc) {
                throw SearchIteratorExceptionCodes.SQL_ERROR.create((Throwable)exc, new Object[]{exc.getMessage()});
            }
        }

        public void close() {
            this.next = null;
            Databases.closeSQLStuff((ResultSet)this.rs, (Statement)this.stmt);
            this.rs = null;
            this.stmt = null;
            if (this.readCon != null) {
                this.d.releaseReadConnection(this.ctx, this.readCon);
            }
        }

        public void addWarning(OXException warning) {
            this.warnings.add(warning);
        }

        public OXException[] getWarnings() {
            return this.warnings.isEmpty() ? null : this.warnings.toArray(new OXException[this.warnings.size()]);
        }

        public boolean hasWarnings() {
            return !this.warnings.isEmpty();
        }
    }

    class CloseImmediatelyMode
    implements FetchMode {
        CloseImmediatelyMode() {
        }

        @Override
        public SearchIterator<DocumentMetadata> buildIterator(ResultSet result, PreparedStatement stmt, int[] dbColumns, DatabaseImpl impl, Context ctx, Connection con, boolean closeIfPossible) {
            if (closeIfPossible) {
                DatabaseImpl.this.close(stmt, result);
                DatabaseImpl.this.releaseReadConnection(ctx, con);
            }
            return new InfostoreIterator(result, dbColumns, impl);
        }
    }

    static class CloseLaterMode
    implements FetchMode {
        CloseLaterMode() {
        }

        @Override
        public SearchIterator<DocumentMetadata> buildIterator(ResultSet result, PreparedStatement stmt, int[] dbColumns, DatabaseImpl impl, Context ctx, Connection con, boolean closeIfPossible) throws OXException {
            return new InfostoreIterator(result, stmt, dbColumns, impl, ctx, con);
        }
    }

    class PrefetchMode
    implements FetchMode {
        PrefetchMode() {
        }

        @Override
        public SearchIterator<DocumentMetadata> buildIterator(ResultSet result, PreparedStatement stmt, int[] dbColumns, DatabaseImpl impl, Context ctx, Connection con, boolean closeIfPossible) throws SQLException {
            ArrayList<DocumentMetadataImpl> resultList = new ArrayList<DocumentMetadataImpl>();
            while (result.next()) {
                DocumentMetadataImpl dmi = new DocumentMetadataImpl();
                DatabaseImpl.this.fillDocumentMetadata(dmi, dbColumns, result);
                resultList.add(dmi);
            }
            if (closeIfPossible) {
                DatabaseImpl.this.close(stmt, result);
                DatabaseImpl.this.releaseReadConnection(ctx, con);
            }
            return new SearchIteratorAdapter(resultList.iterator());
        }
    }

    protected static interface FetchMode {
        public SearchIterator<DocumentMetadata> buildIterator(ResultSet var1, PreparedStatement var2, int[] var3, DatabaseImpl var4, Context var5, Connection var6, boolean var7) throws OXException, SQLException;
    }

    private static class FileInfo {
        final String fileId;
        final int folderAdmin;
        final int contextId;

        FileInfo(String fileId, int folderAdmin, int contextId) {
            this.fileId = fileId;
            this.folderAdmin = folderAdmin;
            this.contextId = contextId;
        }
    }

    private static enum Fetch {
        PREFETCH,
        CLOSE_LATER,
        CLOSE_IMMEDIATELY;

    }
}

