/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.database.impl;

import com.openexchange.database.provider.DBProvider;
import com.openexchange.database.tx.AbstractDBAction;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.InfostoreExceptionCodes;
import com.openexchange.groupware.infostore.database.impl.AbstractInfostoreAction;
import com.openexchange.groupware.infostore.database.impl.InfostoreQueryCatalog;
import com.openexchange.groupware.infostore.utils.Metadata;
import com.openexchange.session.Session;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public abstract class AbstractDocumentListAction
extends AbstractInfostoreAction {
    private List<DocumentMetadata> documents;

    protected AbstractDocumentListAction(Session optSession) {
        super(optSession);
    }

    protected AbstractDocumentListAction(DBProvider provider, InfostoreQueryCatalog queryCatalog, Context context, List<DocumentMetadata> documents, Session session) {
        super(session);
        this.setQueryCatalog(queryCatalog);
        this.setContext(context);
        this.setProvider(provider);
        this.setDocuments(documents);
    }

    public int doUpdates(String query, final Metadata[] fields, List<DocumentMetadata> docs) throws OXException {
        AbstractDBAction.UpdateBlock[] updates = new AbstractDBAction.UpdateBlock[docs.size()];
        int i = 0;
        for (final DocumentMetadata doc : docs) {
            updates[i++] = new AbstractDBAction.Update(query){

                @Override
                public void fillStatement() throws SQLException {
                    AbstractDocumentListAction.this.fillStmt(this.stmt, fields, doc, AbstractDocumentListAction.this.getAdditionals(doc));
                }
            };
        }
        return this.doUpdates(updates);
    }

    protected abstract Object[] getAdditionals(DocumentMetadata var1);

    public void setDocuments(List<DocumentMetadata> documents) {
        this.documents = documents;
    }

    public List<DocumentMetadata> getDocuments() {
        return this.documents;
    }

    public List<DocumentMetadata>[] getSlices(int batchSize, List<DocumentMetadata> documents) {
        boolean addOne = 0 != documents.size() % batchSize;
        int numberOfSlices = documents.size() / batchSize;
        if (addOne) {
            ++numberOfSlices;
        }
        List[] slices = new List[numberOfSlices];
        int max = documents.size();
        for (int i = 0; i < numberOfSlices; ++i) {
            List<DocumentMetadata> slice;
            int start = i * batchSize;
            int end = (i + 1) * batchSize;
            if (end > max) {
                end = max;
            }
            slices[i] = slice = documents.subList(start, end);
        }
        return slices;
    }

    protected void assureExistence() throws OXException {
        Connection writeCon = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            writeCon = this.getProvider().getWriteConnection(this.getContext());
            stmt = writeCon.prepareStatement("SELECT id FROM infostore WHERE cid = " + this.getContext().getContextId() + " AND id = ? FOR UPDATE");
            for (DocumentMetadata document : this.getDocuments()) {
                stmt.setInt(1, document.getId());
                rs = stmt.executeQuery();
                if (rs.next()) continue;
                throw InfostoreExceptionCodes.DOCUMENT_NOT_EXIST.create();
            }
        }
        catch (SQLException e) {
            try {
                throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, DBUtils.getStatement(stmt));
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                if (writeCon != null) {
                    this.getProvider().releaseWriteConnection(this.getContext(), writeCon);
                }
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        if (writeCon != null) {
            this.getProvider().releaseWriteConnection(this.getContext(), writeCon);
        }
    }
}

