/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.contexts.impl;

import com.openexchange.groupware.contexts.impl.ContextExtended;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ContextImpl
implements ContextExtended {
    private static final long serialVersionUID = 8570995404471786200L;
    private final int contextId;
    private String name;
    private String[] loginInfo;
    private int mailadmin = -1;
    private int filestoreId = -1;
    private String filestoreName;
    private String[] filestorageAuth;
    private long fileStorageQuota;
    private boolean enabled = true;
    private boolean updating = false;
    private boolean readOnly = false;
    private final Map<String, List<String>> attributes;

    public ContextImpl(int contextId) {
        this.contextId = contextId;
        this.attributes = new ConcurrentHashMap<String, List<String>>();
    }

    public int getContextId() {
        return this.contextId;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ContextImpl)) {
            return false;
        }
        return this.contextId == ((ContextImpl)obj).contextId;
    }

    public int hashCode() {
        return this.contextId;
    }

    public String toString() {
        return "ContextImpl cid: " + this.contextId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getMailadmin() {
        return this.mailadmin;
    }

    public long getFileStorageQuota() {
        return this.fileStorageQuota;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setMailadmin(int mailadmin) {
        this.mailadmin = mailadmin;
    }

    public void setFileStorageQuota(long fileStorageQuota) {
        this.fileStorageQuota = fileStorageQuota;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int getFilestoreId() {
        return this.filestoreId;
    }

    public void setFilestoreId(int filestoreId) {
        this.filestoreId = filestoreId;
    }

    public String getFilestoreName() {
        return this.filestoreName;
    }

    public void setFilestoreName(String filestoreName) {
        this.filestoreName = filestoreName;
    }

    public void setFilestoreAuth(String[] filestoreAuth) {
        this.filestorageAuth = filestoreAuth;
    }

    public String[] getFileStorageAuth() {
        return (String[])this.filestorageAuth.clone();
    }

    public String[] getLoginInfo() {
        return (String[])this.loginInfo.clone();
    }

    public void setLoginInfo(String[] loginInfo) {
        this.loginInfo = (String[])loginInfo.clone();
    }

    @Override
    public void setUpdating(boolean updating) {
        this.updating = updating;
    }

    public boolean isUpdating() {
        return this.updating;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public Map<String, List<String>> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public void addAttribute(String attrName, String value) {
        List<String> list = this.attributes.get(attrName);
        if (list == null) {
            list = new LinkedList<String>();
            this.attributes.put(attrName, list);
        }
        if (!list.contains(value)) {
            list.add(value);
        }
    }
}

