/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.contexts.impl;

import com.openexchange.exception.Category;
import com.openexchange.exception.DisplayableOXExceptionCode;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;

public enum ContextExceptionCodes implements DisplayableOXExceptionCode
{
    NO_MAILADMIN("Cannot resolve mailadmin for context %d.", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_CONFIGURATION, 1),
    NOT_FOUND("Cannot find context %d.", "The account %1$d was not found.", Category.CATEGORY_CONFIGURATION, 2),
    NO_CONNECTION("Cannot get connection to database.", "Could not connect to the context storage.", Category.CATEGORY_SERVICE_DOWN, 5),
    SQL_ERROR("SQL problem: %1$s.", "Error while reading/writing data from/to the database.", Category.CATEGORY_ERROR, 6),
    UPDATE("Updating database ... Try again later.", "The server is currently down for maintenance. Please try again later.", Category.CATEGORY_TRY_AGAIN, 7),
    NO_MAPPING("Context \"%s\" cannot be found.", "The account \"%1$s\" was not found.", Category.CATEGORY_USER_INPUT, 10),
    CONCURRENT_ATTRIBUTES_UPDATE("Denied concurrent update for context attributes for context %1$d.", "Denied concurrent update of user attributes.", Category.CATEGORY_ERROR, 11);

    private final String message;
    private final String displayMessage;
    private final Category category;
    private final int number;

    private ContextExceptionCodes(String message, String displayMessage, Category category, int number) {
        this.message = message;
        this.displayMessage = displayMessage;
        this.category = category;
        this.number = number;
    }

    public String getPrefix() {
        return "CTX";
    }

    public String getMessage() {
        return this.message;
    }

    public String getDisplayMessage() {
        return this.displayMessage;
    }

    public Category getCategory() {
        return this.category;
    }

    public int getNumber() {
        return this.number;
    }

    public boolean equals(OXException e) {
        return OXExceptionFactory.getInstance().equals((OXExceptionCode)this, e);
    }

    public OXException create() {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, new Object[0]);
    }

    public OXException create(Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, (Throwable)null, args);
    }

    public OXException create(Throwable cause, Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, cause, args);
    }
}

