/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.contact.helpers;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.ContactExceptionCodes;
import com.openexchange.groupware.contact.helpers.AbstractContactSwitcherWithDelegate;
import com.openexchange.groupware.contact.helpers.ContactSwitcher;
import com.openexchange.groupware.container.Contact;
import com.openexchange.java.Strings;
import com.openexchange.mail.mime.QuotedInternetAddress;
import javax.mail.internet.AddressException;

public class ContactSwitcherForEmailAddresses
extends AbstractContactSwitcherWithDelegate {
    public ContactSwitcherForEmailAddresses() {
    }

    public ContactSwitcherForEmailAddresses(ContactSwitcher delegate) {
        this();
        this.setDelegate(delegate);
    }

    @Override
    public Object email1(Object ... objects) throws OXException {
        try {
            return this.delegate.email1(ContactSwitcherForEmailAddresses.validate(objects));
        }
        catch (OXException e) {
            Contact contact = (Contact)objects[0];
            contact.addWarning(e);
            return contact;
        }
    }

    @Override
    public Object email2(Object ... objects) throws OXException {
        try {
            return this.delegate.email2(ContactSwitcherForEmailAddresses.validate(objects));
        }
        catch (OXException e) {
            Contact contact = (Contact)objects[0];
            contact.addWarning(e);
            return contact;
        }
    }

    @Override
    public Object email3(Object ... objects) throws OXException {
        try {
            return this.delegate.email3(ContactSwitcherForEmailAddresses.validate(objects));
        }
        catch (OXException e) {
            Contact contact = (Contact)objects[0];
            contact.addWarning(e);
            return contact;
        }
    }

    private static Object[] validate(Object[] switcherParameters) throws OXException {
        String emailAddress;
        if (null != switcherParameters && 1 < switcherParameters.length && null != switcherParameters[1] && String.class.isInstance(switcherParameters[1]) && !Strings.isEmpty((String)(emailAddress = (String)switcherParameters[1]))) {
            try {
                new QuotedInternetAddress(emailAddress).validate();
            }
            catch (AddressException e) {
                throw ContactExceptionCodes.INVALID_EMAIL.create(e, emailAddress);
            }
        }
        return switcherParameters;
    }
}

