/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.contact;

import com.openexchange.config.ConfigurationService;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContactConfig {
    private static final String FILENAME = "contact.properties";
    private static final ContactConfig SINGLETON = new ContactConfig();
    private static final Logger LOG = LoggerFactory.getLogger(ContactConfig.class);
    private final Properties props = new Properties();
    private long maxImageSize = 33750000L;

    private ContactConfig() {
    }

    public static ContactConfig getInstance() {
        return SINGLETON;
    }

    public void initialize(ConfigurationService configuration) {
        Properties props = configuration.getFile(FILENAME);
        if (null == props) {
            LOG.info("Configuration file {} is missing. Using defaults.", (Object)FILENAME);
        } else {
            this.props.clear();
            this.props.putAll((Map<?, ?>)props);
            LOG.info("Read configuration file {}.", (Object)FILENAME);
        }
        this.parse();
    }

    private void parse() {
        try {
            this.maxImageSize = Long.parseLong(this.getString(Property.MAX_IMAGE_SIZE));
        }
        catch (NumberFormatException e) {
            LOG.error("Unable to parse value of property {} in {}.", new Object[]{Property.MAX_IMAGE_SIZE.propertyName, FILENAME, e});
            this.maxImageSize = 33750000L;
        }
    }

    public String getProperty(String key) {
        this.logNotInitialized();
        return this.props.getProperty(key);
    }

    public String getString(Property key) {
        this.logNotInitialized();
        return this.props.getProperty(key.propertyName, key.defaultValue);
    }

    public Boolean getBoolean(Property key) {
        this.logNotInitialized();
        return Boolean.valueOf(this.props.getProperty(key.propertyName, key.defaultValue));
    }

    private void logNotInitialized() {
        if (this.props.isEmpty()) {
            LOG.info("Configuration file {} not read. Using defaults.", (Object)FILENAME);
        }
    }

    public long getMaxImageSize() {
        this.logNotInitialized();
        return this.maxImageSize;
    }

    public static enum Property {
        AUTO_SEARCH("com.openexchange.contact.mailAddressAutoSearch", Boolean.TRUE.toString()),
        SINGLE_FOLDER_SEARCH("com.openexchange.contact.singleFolderSearch", Boolean.TRUE.toString()),
        LETTER_FIELD("contact_first_letter_field", "field02"),
        CHARACTER_SEARCH("com.openexchange.contacts.characterSearch", Boolean.TRUE.toString()),
        ALL_FOLDERS_FOR_AUTOCOMPLETE("com.openexchange.contacts.allFoldersForAutoComplete", Boolean.TRUE.toString()),
        MAX_IMAGE_SIZE("max_image_size", "33750000"),
        VALIDATE_CONTACT_EMAIL("validate_contact_email", Boolean.TRUE.toString()),
        SCALE_IMAGES("com.openexchange.contact.image.scaleImages", Boolean.TRUE.toString()),
        SCALED_IMAGE_WIDTH("com.openexchange.contact.image.maxWidth", "250"),
        SCALED_IMAGE_HEIGHT("com.openexchange.contact.image.maxHeight", "250"),
        SCALE_TYPE("com.openexchange.contact.image.scaleType", "2");

        private String propertyName;
        private String defaultValue;

        private Property(String keyName, String value) {
            this.propertyName = keyName;
            this.defaultValue = value;
        }
    }
}

