/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.attach.json.actions;

import com.openexchange.ajax.parser.AttachmentParser;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.writer.AttachmentWriter;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.AttachmentField;
import com.openexchange.groupware.attach.AttachmentMetadata;
import com.openexchange.groupware.attach.json.actions.AbstractAttachmentAction;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.results.TimedResult;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.json.OXJSONWriter;
import com.openexchange.server.ServiceLookup;
import com.openexchange.tools.TimeZoneUtils;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIterators;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Action(method=RequestMethod.PUT, name="list", description="Get a list of attachments.", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="columns", description="A comma-separated list of columns to return. Each column is specified by a numeric column identifier. Column identifiers for attachments are defined in Common object data (with only id, created_by and creation_date available) and Attachment object."), @Parameter(name="attached", description="The Object ID of the Object."), @Parameter(name="folder", description="The Folder ID of the Object."), @Parameter(name="module", description="The Module type of the Object.")}, requestBody="An array of with object IDs of requested attachments.", responseDescription="Response with timestamp: An array with attachment data. Each array element describes one attachment and is itself an array. The elements of each array contain the information specified by the corresponding identifiers in the columns parameter.")
public final class ListAction
extends AbstractAttachmentAction {
    private static final Logger LOG = LoggerFactory.getLogger(ListAction.class);

    public ListAction(ServiceLookup serviceLookup) {
        super(serviceLookup);
    }

    @Override
    public AJAXRequestResult perform(AJAXRequestData requestData, ServerSession session) throws OXException {
        try {
            ListAction.require(requestData, "folder", "module", "attached");
            int folderId = this.requireNumber(requestData, "folder");
            int attachedId = this.requireNumber(requestData, "attached");
            int moduleId = this.requireNumber(requestData, "module");
            JSONArray idsArray = (JSONArray)requestData.requireData();
            int[] ids = new int[idsArray.length()];
            for (int i = 0; i < idsArray.length(); ++i) {
                try {
                    ids[i] = idsArray.getInt(i);
                    continue;
                }
                catch (JSONException e) {
                    String string = idsArray.getString(i);
                    try {
                        ids[i] = Integer.parseInt(string);
                        continue;
                    }
                    catch (NumberFormatException e1) {
                        throw AjaxExceptionCodes.IMVALID_PARAMETER.create(string);
                    }
                }
            }
            AttachmentField[] columns = PARSER.getColumns(requestData.getParameterValues("columns"));
            String timeZoneId = requestData.getParameter("timezone");
            JSONValue jsonValue = this.list(session, folderId, attachedId, moduleId, ids, columns, timeZoneId);
            return new AJAXRequestResult((Object)jsonValue, "apiResponse");
        }
        catch (JSONException e) {
            throw AjaxExceptionCodes.JSON_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        catch (AttachmentParser.UnknownColumnException e) {
            throw AjaxExceptionCodes.UNEXPECTED_ERROR.create((Throwable)((Object)e), e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JSONValue list(ServerSession session, int folderId, int attachedId, int moduleId, int[] ids, AttachmentField[] fields, String timeZoneId) throws OXException {
        JSONValue jSONValue;
        SearchIterator iter = null;
        User user = session.getUser();
        TimeZone tz = null == timeZoneId ? TimeZoneUtils.getTimeZone(user.getTimeZone()) : TimeZoneUtils.getTimeZone(timeZoneId);
        try {
            ATTACHMENT_BASE.startTransaction();
            Context ctx = session.getContext();
            UserConfiguration userConfig = session.getUserConfiguration();
            TimedResult<AttachmentMetadata> result = ATTACHMENT_BASE.getAttachments(session, folderId, attachedId, moduleId, ids, fields, ctx, user, userConfig);
            iter = result.results();
            OXJSONWriter w = new OXJSONWriter();
            AttachmentWriter aWriter = new AttachmentWriter(w);
            aWriter.timedResult(result.sequenceNumber());
            aWriter.writeAttachments(iter, fields, tz);
            aWriter.endTimedResult();
            ATTACHMENT_BASE.commit();
            jSONValue = w.getObject();
        }
        catch (Throwable t) {
            try {
                this.rollback();
                if (t instanceof OXException) {
                    throw (OXException)t;
                }
                throw new OXException(t);
            }
            catch (Throwable throwable) {
                try {
                    ATTACHMENT_BASE.finish();
                }
                catch (OXException e) {
                    LOG.error("", (Throwable)e);
                }
                SearchIterators.close(iter);
                throw throwable;
            }
        }
        try {
            ATTACHMENT_BASE.finish();
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
        }
        SearchIterators.close((SearchIterator)iter);
        return jSONValue;
    }
}

