/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.attach.json;

import com.openexchange.ajax.requesthandler.AJAXActionService;
import com.openexchange.ajax.requesthandler.AJAXActionServiceFactory;
import com.openexchange.documentation.annotations.Module;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.json.actions.AllAction;
import com.openexchange.groupware.attach.json.actions.AttachAction;
import com.openexchange.groupware.attach.json.actions.DetachAction;
import com.openexchange.groupware.attach.json.actions.GetAction;
import com.openexchange.groupware.attach.json.actions.GetDocumentAction;
import com.openexchange.groupware.attach.json.actions.ListAction;
import com.openexchange.groupware.attach.json.actions.UpdatesAction;
import com.openexchange.server.ServiceLookup;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Module(name="attachment", description="Allows file attachments to arbitrary objects. Object addresses are defined analogous to the Link module. An Attachment always belongs to an object (called 'attached') in a certain folder of a certain module.")
public class AttachmentActionFactory
implements AJAXActionServiceFactory {
    private final Map<String, AJAXActionService> actions = new ConcurrentHashMap<String, AJAXActionService>(8, 0.9f, 1);

    public AttachmentActionFactory(ServiceLookup services) {
        this.actions.put("document", new GetDocumentAction(services));
        this.actions.put("get", new GetAction(services));
        this.actions.put("attach", new AttachAction(services));
        this.actions.put("detach", new DetachAction(services));
        this.actions.put("updates", new UpdatesAction(services));
        this.actions.put("all", new AllAction(services));
        this.actions.put("list", new ListAction(services));
    }

    @Override
    public AJAXActionService createActionService(String action) throws OXException {
        return this.actions.get(action);
    }

    public Collection<? extends AJAXActionService> getSupportedServices() {
        return Collections.unmodifiableCollection(this.actions.values());
    }
}

