/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.attach.impl;

import com.google.common.base.Strings;
import com.openexchange.groupware.attach.AttachmentField;
import com.openexchange.groupware.attach.AttachmentMetadata;
import java.util.List;

public class AttachmentQueryCatalog {
    private static final AttachmentField[] DB_FIELDS = new AttachmentField[]{AttachmentField.CREATED_BY_LITERAL, AttachmentField.CREATION_DATE_LITERAL, AttachmentField.FILE_MIMETYPE_LITERAL, AttachmentField.FILE_SIZE_LITERAL, AttachmentField.FILENAME_LITERAL, AttachmentField.ATTACHED_ID_LITERAL, AttachmentField.MODULE_ID_LITERAL, AttachmentField.RTF_FLAG_LITERAL, AttachmentField.ID_LITERAL, AttachmentField.COMMENT_LITERAL, AttachmentField.FILE_ID_LITERAL};
    private static final String REMEMBER_DEL = "INSERT INTO del_attachment (id, del_date, cid, attached, module) VALUES (?,?,?,?,?)";
    private static final String INSERT;
    private static final String UPDATE;
    private static final String FIELDS;
    private static final String SELECT_BY_ID;
    private static final String SELECT_NEWEST_CREATION_DATE = "SELECT attached,MAX(creation_date) AS creation_date FROM prg_attachment WHERE cid=? AND module=? AND attached IN (";
    private static final String SELECT_FILE_ID = "SELECT file_id FROM prg_attachment WHERE id = ? AND cid = ? ";

    public AttachmentField[] getFields() {
        return DB_FIELDS;
    }

    public String getInsert() {
        return INSERT;
    }

    public String getDelete(String tablename, List<AttachmentMetadata> attachments2) {
        StringBuilder builder = new StringBuilder("DELETE FROM ").append(tablename).append(" WHERE id IN (");
        for (AttachmentMetadata m : attachments2) {
            builder.append(m.getId()).append(',');
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append(") and cid = ?");
        return builder.toString();
    }

    public String getInsertIntoDel() {
        return REMEMBER_DEL;
    }

    public String getUpdate() {
        return UPDATE;
    }

    public String getSelectFileId() {
        return SELECT_FILE_ID;
    }

    public void appendColumnList(StringBuilder select, AttachmentField[] columns) {
        this.appendColumnListWithPrefix(select, columns, null);
    }

    public void appendColumnListWithPrefix(StringBuilder select, AttachmentField[] columns, String prefix) {
        prefix = Strings.isNullOrEmpty((String)prefix) ? "" : prefix + ".";
        for (AttachmentField field : columns) {
            select.append(prefix).append(field);
            select.append(',');
        }
        select.setLength(select.length() - 1);
    }

    public String getSelectById() {
        return SELECT_BY_ID;
    }

    public String getSelectNewestCreationDate() {
        return SELECT_NEWEST_CREATION_DATE;
    }

    static {
        StringBuilder updateBuffer = new StringBuilder("UPDATE prg_attachment SET ");
        StringBuilder insertBuffer = new StringBuilder("INSERT INTO prg_attachment (");
        StringBuilder questionMarks = new StringBuilder();
        StringBuilder fieldsBuffer = new StringBuilder();
        StringBuilder selectByIdBuffer = new StringBuilder("SELECT ");
        for (AttachmentField field : DB_FIELDS) {
            fieldsBuffer.append(field.getName());
            fieldsBuffer.append(", ");
            questionMarks.append("?, ");
            updateBuffer.append(field);
            updateBuffer.append(" = ?, ");
        }
        updateBuffer.setLength(updateBuffer.length() - 2);
        fieldsBuffer.append("cid");
        questionMarks.append('?');
        updateBuffer.append("WHERE cid = ? AND id = ?");
        insertBuffer.append((CharSequence)fieldsBuffer);
        insertBuffer.append(") VALUES ( ");
        insertBuffer.append((CharSequence)questionMarks);
        insertBuffer.append(')');
        INSERT = insertBuffer.toString();
        FIELDS = fieldsBuffer.toString();
        UPDATE = updateBuffer.toString();
        selectByIdBuffer.append(FIELDS);
        selectByIdBuffer.append(" FROM prg_attachment WHERE id = ? AND cid = ?");
        SELECT_BY_ID = selectByIdBuffer.toString();
    }
}

