/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.virtual;

import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.FolderStorageDiscoverer;
import com.openexchange.folderstorage.FolderType;
import com.openexchange.folderstorage.StoragePriority;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VirtualFolderStorageRegistry
implements FolderStorageDiscoverer {
    private static final VirtualFolderStorageRegistry instance = new VirtualFolderStorageRegistry();
    private final ConcurrentMap<String, List<FolderStorage>> registry = new ConcurrentHashMap<String, List<FolderStorage>>();
    private final List<FolderStorage> genStorages = new CopyOnWriteArrayList<FolderStorage>();
    private final ConcurrentMap<ContentType, FolderStorage> contentTypes = new ConcurrentHashMap<ContentType, FolderStorage>();

    public static VirtualFolderStorageRegistry getInstance() {
        return instance;
    }

    private VirtualFolderStorageRegistry() {
    }

    public boolean addFolderStorage(String treeId, FolderStorage folderStorage) {
        if (!(FolderStorage.ALL_TREE_ID.equals(treeId) && StoragePriority.HIGHEST.equals(folderStorage.getStoragePriority()) || FolderStorage.REAL_TREE_ID.equals(treeId))) {
            return false;
        }
        ContentType[] contentTypes = folderStorage.getSupportedContentTypes();
        if (null != contentTypes && contentTypes.length > 0) {
            boolean success = true;
            HashSet<ContentType> added = new HashSet<ContentType>(contentTypes.length);
            for (int j = 0; success && j < contentTypes.length; ++j) {
                if (null == this.contentTypes.putIfAbsent(contentTypes[j], folderStorage)) {
                    added.add(contentTypes[j]);
                    continue;
                }
                Logger log = LoggerFactory.getLogger(VirtualFolderStorageRegistry.class);
                log.error("Duplicate folder storage for content type \"{}\"", (Object)contentTypes[j].toString(), (Object)new Throwable());
                success = false;
            }
            if (!success) {
                for (ContentType contentType : added) {
                    this.contentTypes.remove(contentType);
                }
                return false;
            }
        }
        if (FolderStorage.ALL_TREE_ID.equals(treeId)) {
            this.genStorages.add(folderStorage);
        } else {
            CopyOnWriteArrayList<FolderStorage> tmp;
            CopyOnWriteArrayList<FolderStorage> storages = (CopyOnWriteArrayList<FolderStorage>)this.registry.get(treeId);
            if (null == storages && null == (storages = (List)this.registry.putIfAbsent(treeId, tmp = new CopyOnWriteArrayList<FolderStorage>()))) {
                storages = tmp;
            }
            storages.add(folderStorage);
        }
        return true;
    }

    @Override
    public FolderStorage getFolderStorage(String treeId, String folderId) {
        List storages;
        if (!this.genStorages.isEmpty()) {
            for (FolderStorage folderStorage : this.genStorages) {
                if (!folderStorage.getFolderType().servesTreeId(treeId)) continue;
                return folderStorage;
            }
        }
        if (null == (storages = (List)this.registry.get(treeId))) {
            return null;
        }
        for (FolderStorage folderStorage : storages) {
            if (!folderStorage.getFolderType().servesFolderId(folderId)) continue;
            return folderStorage;
        }
        return null;
    }

    @Override
    public FolderStorage[] getFolderStoragesForParent(String treeId, String parentId) {
        List storages;
        if (!this.genStorages.isEmpty()) {
            for (FolderStorage folderStorage : this.genStorages) {
                FolderType folderType = folderStorage.getFolderType();
                if (!folderType.servesTreeId(treeId) || !folderType.servesParentId(parentId)) continue;
                return new FolderStorage[]{folderStorage};
            }
        }
        if (null == (storages = (List)this.registry.get(treeId))) {
            return new FolderStorage[0];
        }
        ArrayList<FolderStorage> l = new ArrayList<FolderStorage>(4);
        for (FolderStorage folderStorage : storages) {
            if (!folderStorage.getFolderType().servesParentId(parentId)) continue;
            l.add(folderStorage);
        }
        return l.toArray(new FolderStorage[l.size()]);
    }

    @Override
    public FolderStorage[] getFolderStoragesForTreeID(String treeId) {
        List storages;
        if (!this.genStorages.isEmpty()) {
            for (FolderStorage folderStorage : this.genStorages) {
                FolderType folderType = folderStorage.getFolderType();
                if (!folderType.servesTreeId(treeId)) continue;
                return new FolderStorage[]{folderStorage};
            }
        }
        if (null == (storages = (List)this.registry.get(treeId))) {
            return new FolderStorage[0];
        }
        return storages.toArray(new FolderStorage[storages.size()]);
    }

    @Override
    public FolderStorage[] getTreeFolderStorages(String treeId) {
        List storages;
        if (!this.genStorages.isEmpty()) {
            for (FolderStorage folderStorage : this.genStorages) {
                if (StoragePriority.HIGHEST.equals(folderStorage.getStoragePriority()) || !folderStorage.getFolderType().servesTreeId(treeId)) continue;
                return new FolderStorage[]{folderStorage};
            }
        }
        if (null == (storages = (List)this.registry.get(treeId))) {
            return new FolderStorage[0];
        }
        return storages.toArray(new FolderStorage[storages.size()]);
    }

    @Override
    public FolderStorage getFolderStorageByContentType(String treeId, ContentType contentType) {
        FolderStorage folderStorage = (FolderStorage)this.contentTypes.get(contentType);
        if (null == folderStorage) {
            return null;
        }
        if (folderStorage.getFolderType().servesTreeId(treeId)) {
            return folderStorage;
        }
        return null;
    }

    public void removeFolderStorage(String treeId, FolderStorage folderStorage) {
        if (!(FolderStorage.ALL_TREE_ID.equals(treeId) && StoragePriority.HIGHEST.equals(folderStorage.getStoragePriority()) || FolderStorage.REAL_TREE_ID.equals(treeId))) {
            return;
        }
        if (FolderStorage.ALL_TREE_ID.equals(treeId)) {
            this.genStorages.remove(folderStorage);
        } else {
            List storages = (List)this.registry.get(treeId);
            if (null == storages) {
                return;
            }
            storages.remove(folderStorage);
        }
        ContentType[] contentTypes = folderStorage.getSupportedContentTypes();
        if (null != contentTypes && contentTypes.length > 0) {
            for (ContentType contentType : contentTypes) {
                this.contentTypes.remove(contentType);
            }
        }
    }
}

