/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.database.getfolder;

import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.database.DatabaseFolder;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.server.impl.OCLPermission;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class SystemRootFolder {
    private static final ConcurrentMap<Locale, List<String[]>> CACHED_SUBFOLDERS = new ConcurrentHashMap<Locale, List<String[]>>(16);

    private SystemRootFolder() {
    }

    public static DatabaseFolder getSystemRootFolder() {
        OCLPermission guestPermission = new OCLPermission(Integer.MAX_VALUE, 0);
        guestPermission.setFolderAdmin(false);
        guestPermission.setGroupPermission(true);
        guestPermission.setAllPermission(2, 0, 0, 0);
        FolderObject fo = FolderObject.createVirtualFolderObject(0, "root", 5, true, 5, FolderObject.VIRTUAL_FOLDER_PERMISSION, guestPermission);
        DatabaseFolder retval = new DatabaseFolder(fo);
        retval.setSubfolderIDs(null);
        retval.setSubscribedSubfolders(true);
        return retval;
    }

    public static List<String[]> getSystemRootFolderSubfolder(User user, UserPermissionBits userPerm, Context ctx, Connection con) throws OXException {
        return SystemRootFolder.getSystemRootFolderSubfolder(user.getLocale());
    }

    private static List<String[]> getSystemRootFolderSubfolder(Locale locale) {
        ArrayList<String[]> list = (ArrayList<String[]>)CACHED_SUBFOLDERS.get(locale);
        if (null == list) {
            StringHelper sh = StringHelper.valueOf(locale);
            ArrayList<String[]> newList = new ArrayList<String[]>(4);
            newList.add(new String[]{String.valueOf(1), sh.getString("Private folders")});
            newList.add(new String[]{String.valueOf(2), sh.getString("Public folders")});
            newList.add(new String[]{String.valueOf(3), sh.getString("Shared folders")});
            newList.add(new String[]{String.valueOf(9), sh.getString("Infostore")});
            list = CACHED_SUBFOLDERS.putIfAbsent(locale, newList);
            if (null == list) {
                list = newList;
            }
        }
        return list;
    }
}

