/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.database;

import com.openexchange.context.ContextService;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.SortableId;
import com.openexchange.folderstorage.StorageParameters;
import com.openexchange.folderstorage.database.DatabaseId;
import com.openexchange.folderstorage.osgi.FolderStorageServices;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.userconf.UserPermissionService;
import java.sql.Connection;
import java.util.List;
import java.util.Locale;

public final class DatabaseFolderStorageUtility {
    private static final int RADIX = 10;

    private DatabaseFolderStorageUtility() {
    }

    public static int getUnsignedInteger(String s) {
        int digit;
        if (s == null) {
            return -1;
        }
        int max = s.length();
        if (max <= 0) {
            return -1;
        }
        if (s.charAt(0) == '-') {
            return -1;
        }
        int result = 0;
        int i = 0;
        int limit = -2147483647;
        int multmin = -214748364;
        if (i < max) {
            if ((digit = DatabaseFolderStorageUtility.digit(s.charAt(i++))) < 0) {
                return -1;
            }
            result = -digit;
        }
        while (i < max) {
            if ((digit = DatabaseFolderStorageUtility.digit(s.charAt(i++))) < 0) {
                return -1;
            }
            if (result < -214748364) {
                return -1;
            }
            if ((result *= 10) < -2147483647 + digit) {
                return -1;
            }
            result -= digit;
        }
        return -result;
    }

    private static int digit(char c) {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
        }
        return -1;
    }

    public static boolean hasSharedPrefix(String str) {
        return null != str && str.startsWith("u:", 0);
    }

    public static UserPermissionBits getUserPermissionBits(Connection connection, StorageParameters storageParameters) throws OXException {
        Session session = storageParameters.getSession();
        if (session != null && ServerSession.class.isInstance(session)) {
            return ((ServerSession)session).getUserPermissionBits();
        }
        UserPermissionService userPermissionService = FolderStorageServices.requireService(UserPermissionService.class);
        if (null == connection) {
            return userPermissionService.getUserPermissionBits(storageParameters.getUserId(), storageParameters.getContextId());
        }
        Context context = storageParameters.getContext();
        if (context == null) {
            context = FolderStorageServices.requireService(ContextService.class).getContext(storageParameters.getContextId());
        }
        return userPermissionService.getUserPermissionBits(connection, storageParameters.getUserId(), context);
    }

    public static SortableId[] extractIDs(List<FolderObject> folders2) {
        SortableId[] ret = new SortableId[folders2.size()];
        for (int i = 0; i < ret.length; ++i) {
            FolderObject folderObject = folders2.get(i);
            String id = String.valueOf(folderObject.getObjectID());
            ret[i] = new DatabaseId(id, i, folderObject.getFolderName());
        }
        return ret;
    }

    public static void localizeFolderNames(List<FolderObject> folders2, Locale locale) throws OXException {
        StringHelper stringHelper = null;
        for (FolderObject folderObject : folders2) {
            if (!folderObject.isDefaultFolder()) continue;
            int module = folderObject.getModule();
            if (2 == module) {
                if (null == stringHelper) {
                    stringHelper = StringHelper.valueOf(locale);
                }
                folderObject.setFolderName(stringHelper.getString("Calendar"));
                continue;
            }
            if (3 == module) {
                if (null == stringHelper) {
                    stringHelper = StringHelper.valueOf(locale);
                }
                folderObject.setFolderName(stringHelper.getString("Contacts"));
                continue;
            }
            if (1 != module) continue;
            if (null == stringHelper) {
                stringHelper = StringHelper.valueOf(locale);
            }
            folderObject.setFolderName(stringHelper.getString("Tasks"));
        }
    }
}

