/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.cache.osgi;

import com.openexchange.caching.CacheKey;
import com.openexchange.caching.events.CacheEvent;
import com.openexchange.caching.events.CacheEventService;
import com.openexchange.caching.events.CacheListener;
import com.openexchange.folderstorage.cache.memory.FolderMapManagement;
import com.openexchange.folderstorage.internal.Tools;
import java.io.Serializable;
import java.util.ArrayList;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FolderMapInvalidator
implements CacheListener,
ServiceTrackerCustomizer<CacheEventService, CacheEventService> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FolderMapInvalidator.class);
    private static final String REGION = FolderMapManagement.REGION;
    private final BundleContext context;

    public FolderMapInvalidator(BundleContext context) {
        this.context = context;
    }

    public void onEvent(Object sender, CacheEvent cacheEvent, boolean fromRemote) {
        if (fromRemote) {
            int contextId;
            LOGGER.debug("Handling incoming remote cache event: {}", (Object)cacheEvent);
            if (REGION.equals(cacheEvent.getRegion()) && (contextId = Tools.getUnsignedInteger(cacheEvent.getGroupName())) > 0) {
                for (Serializable cacheKey : cacheEvent.getKeys()) {
                    FolderMapInvalidator.handleCacheKey(cacheKey, contextId);
                }
            }
        }
    }

    public static void handleCacheKey(Serializable cacheKey, int contextId) {
        if (cacheKey instanceof CacheKey) {
            CacheKey key = (CacheKey)cacheKey;
            int optUser = key.getContextId();
            String[] keys = key.getKeys();
            if (null == keys || 0 == keys.length) {
                if (0 < optUser) {
                    FolderMapManagement.getInstance().dropFor(optUser, contextId, false);
                } else {
                    FolderMapManagement.getInstance().dropFor(contextId, false);
                }
            } else {
                String treeId = String.valueOf(keys[0]);
                ArrayList<String> folderIds = new ArrayList<String>(keys.length - 1);
                for (int i = 1; i < keys.length; ++i) {
                    folderIds.add(String.valueOf(keys[i]));
                }
                FolderMapManagement.getInstance().dropFor(folderIds, treeId, optUser, contextId, null, false);
            }
        }
    }

    public CacheEventService addingService(ServiceReference<CacheEventService> reference) {
        CacheEventService service = (CacheEventService)this.context.getService(reference);
        service.addListener(REGION, (CacheListener)this);
        return service;
    }

    public void modifiedService(ServiceReference<CacheEventService> reference, CacheEventService service) {
    }

    public void removedService(ServiceReference<CacheEventService> reference, CacheEventService service) {
        service.removeListener(REGION, (CacheListener)this);
        this.context.ungetService(reference);
    }
}

