/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.cache.osgi;

import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.cache.CacheFolderStorageRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CacheFolderStorageServiceTracker
implements ServiceTrackerCustomizer<FolderStorage, FolderStorage> {
    private static final Logger LOG = LoggerFactory.getLogger(CacheFolderStorageServiceTracker.class);
    private final BundleContext context;

    public CacheFolderStorageServiceTracker(BundleContext context) {
        this.context = context;
    }

    public FolderStorage addingService(ServiceReference<FolderStorage> reference) {
        FolderStorage addedService = (FolderStorage)this.context.getService(reference);
        Object obj = reference.getProperty("tree");
        if (null == obj) {
            LOG.error("Missing tree identifier property \"tree\" for {}", (Object)addedService.getClass().getName());
            this.context.ungetService(reference);
            return null;
        }
        String treeId = obj.toString();
        if (CacheFolderStorageRegistry.getInstance().addFolderStorage(treeId, addedService)) {
            return addedService;
        }
        this.context.ungetService(reference);
        return null;
    }

    public void modifiedService(ServiceReference<FolderStorage> reference, FolderStorage service) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference<FolderStorage> reference, FolderStorage service) {
        if (null != service) {
            try {
                Object obj = reference.getProperty("tree");
                if (null == obj) {
                    LOG.error("Missing tree identifier property \"tree\" for {}", (Object)service.getClass().getName());
                    return;
                }
                String treeId = obj.toString();
                CacheFolderStorageRegistry.getInstance().removeFolderStorage(treeId, service);
            }
            finally {
                this.context.ungetService(reference);
            }
        }
    }
}

