/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.database.provider;

import com.openexchange.database.provider.DBProvider;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.server.impl.DBPool;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBPoolProvider
implements DBProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DBPoolProvider.class);

    @Override
    public Connection getReadConnection(Context ctx) throws OXException {
        try {
            return DBPool.pickup(ctx);
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void releaseReadConnection(Context ctx, Connection con) {
        if (con != null) {
            DBPool.closeReaderSilent(ctx, con);
        }
    }

    @Override
    public Connection getWriteConnection(Context ctx) throws OXException {
        return DBPool.pickupWriteable(ctx);
    }

    @Override
    public void releaseWriteConnection(Context ctx, Connection con) {
        if (con == null) {
            return;
        }
        DBUtils.autocommit(con);
        DBPool.closeWriterSilent(ctx, con);
    }

    @Override
    public void releaseWriteConnectionAfterReading(Context ctx, Connection con) {
        if (con == null) {
            return;
        }
        DBUtils.autocommit(con);
        DBPool.closeWriterAfterReading(ctx, con);
    }
}

