/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.contact.internal;

import com.openexchange.ajax.fileholder.IFileHolder;
import com.openexchange.config.cascade.ConfigViewFactory;
import com.openexchange.contact.ContactService;
import com.openexchange.contact.vcard.VCardExport;
import com.openexchange.contact.vcard.VCardImport;
import com.openexchange.contact.vcard.VCardService;
import com.openexchange.contact.vcard.storage.VCardStorageFactory;
import com.openexchange.contact.vcard.storage.VCardStorageService;
import com.openexchange.conversion.DataExceptionCodes;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.container.Contact;
import com.openexchange.java.Streams;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.session.ServerSession;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class VCardUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VCardExport exportContact(Contact contact, Session session) throws OXException {
        VCardService vCardService = ServerServiceRegistry.getInstance().getService(VCardService.class, true);
        InputStream originalVCard = null;
        try {
            VCardStorageService vCardStorageService;
            if (null != contact.getVCardId() && (vCardStorageService = VCardUtil.getVCardStorageService(session.getContextId())) != null) {
                originalVCard = vCardStorageService.getVCard(contact.getVCardId(), session.getContextId());
            }
            VCardExport vCardExport = vCardService.exportContact(contact, originalVCard, vCardService.createParameters(session));
            return vCardExport;
        }
        finally {
            Streams.close(originalVCard);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportContact(Contact contact, Session session, OutputStream outputStream) throws OXException {
        VCardExport vCardExport = VCardUtil.exportContact(contact, session);
        try {
            InputStream inputStream = null;
            byte[] buffer = new byte[65535];
            try {
                int len;
                inputStream = vCardExport.getVCard().getStream();
                while ((len = inputStream.read(buffer, 0, buffer.length)) > 0) {
                    outputStream.write(buffer, 0, len);
                }
            }
            finally {
                Streams.close((Closeable)inputStream);
            }
        }
        catch (IOException e) {
            throw DataExceptionCodes.IO_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        finally {
            Streams.close((Closeable)vCardExport);
        }
    }

    public static VCardImport importContact(InputStream inputStream, ServerSession session, boolean keepOriginalVCard) throws OXException {
        VCardService vCardService = ServerServiceRegistry.getInstance().getService(VCardService.class, true);
        return vCardService.importVCard(inputStream, null, vCardService.createParameters(session).setKeepOriginalVCard(keepOriginalVCard));
    }

    public static Contact importContactToDefaultFolder(InputStream inputStream, ServerSession session) throws OXException {
        int defaultFolderID = new OXFolderAccess(session.getContext()).getDefaultFolderID(session.getUserId(), 3);
        return VCardUtil.importContactToFolder(inputStream, String.valueOf(defaultFolderID), session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Contact importContactToFolder(InputStream inputStream, String folderID, ServerSession session) throws OXException {
        Contact contact;
        ContactService contactService = ServerServiceRegistry.getInstance().getService(ContactService.class, true);
        VCardStorageService vCardStorage = VCardUtil.getVCardStorageService(session.getContextId());
        boolean keepOriginalVCard = null != vCardStorage && contactService.supports(session, folderID, ContactField.VCARD_ID);
        VCardImport vCardImport = null;
        boolean saved = false;
        String vCardID = null;
        try {
            IFileHolder originalVCard;
            vCardImport = VCardUtil.importContact(inputStream, session, keepOriginalVCard);
            Contact contact2 = vCardImport.getContact();
            if (vCardStorage != null && null != (originalVCard = vCardImport.getVCard())) {
                try {
                    vCardID = vCardStorage.saveVCard(originalVCard.getStream(), session.getContextId());
                    contact2.setVCardId(vCardID);
                }
                finally {
                    Streams.close((Closeable)originalVCard);
                }
            }
            contactService.createContact(session, folderID, contact2);
            saved = true;
            contact = contact2;
        }
        catch (Throwable throwable) {
            Streams.close(vCardImport);
            if (null != vCardID && !saved) {
                vCardStorage.deleteVCard(vCardID, session.getContextId());
            }
            throw throwable;
        }
        Streams.close((Closeable)vCardImport);
        if (null != vCardID && !saved) {
            vCardStorage.deleteVCard(vCardID, session.getContextId());
        }
        return contact;
    }

    public static VCardStorageService getVCardStorageService(int contextId) throws OXException {
        VCardStorageFactory vCardStorageFactory = ServerServiceRegistry.getInstance().getService(VCardStorageFactory.class, false);
        if (vCardStorageFactory != null) {
            return vCardStorageFactory.getVCardStorageService(ServerServiceRegistry.getInstance().getService(ConfigViewFactory.class), contextId);
        }
        return null;
    }

    private VCardUtil() {
    }
}

