/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.consistency;

import com.openexchange.config.ConfigurationService;
import com.openexchange.consistency.ConsistencyExceptionCodes;
import com.openexchange.consistency.ConsistencyMBean;
import com.openexchange.consistency.Entity;
import com.openexchange.consistency.EntityImpl;
import com.openexchange.consistency.MBeanEntity;
import com.openexchange.consistency.osgi.ConsistencyServiceLookup;
import com.openexchange.consistency.solver.CreateDummyFileForAttachmentSolver;
import com.openexchange.consistency.solver.CreateDummyFileForInfoitemSolver;
import com.openexchange.consistency.solver.CreateDummyFileForSnippetSolver;
import com.openexchange.consistency.solver.CreateInfoitemSolver;
import com.openexchange.consistency.solver.DeleteAttachmentSolver;
import com.openexchange.consistency.solver.DeleteBrokenPreviewReferencesSolver;
import com.openexchange.consistency.solver.DeleteBrokenVCardReferencesSolver;
import com.openexchange.consistency.solver.DeleteInfoitemSolver;
import com.openexchange.consistency.solver.DeleteSnippetSolver;
import com.openexchange.consistency.solver.DoNothingSolver;
import com.openexchange.consistency.solver.ProblemSolver;
import com.openexchange.consistency.solver.RecordSolver;
import com.openexchange.consistency.solver.RemoveFileSolver;
import com.openexchange.database.DatabaseService;
import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.filestore.FileStorage;
import com.openexchange.filestore.FileStorageCodes;
import com.openexchange.filestore.QuotaFileStorage;
import com.openexchange.groupware.attach.AttachmentBase;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.database.impl.DatabaseImpl;
import com.openexchange.groupware.ldap.User;
import com.openexchange.report.internal.Tools;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.management.MBeanException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Consistency
implements ConsistencyMBean {
    private static final Logger LOG = LoggerFactory.getLogger(Consistency.class);

    protected Consistency() {
    }

    @Override
    public List<String> listMissingFilesInContext(int contextId) throws MBeanException {
        try {
            LOG.info("Listing missing files in context {}", (Object)contextId);
            DoNothingSolver doNothing = new DoNothingSolver();
            RecordSolver recorder = new RecordSolver();
            Context ctx = this.getContext(contextId);
            this.checkOneEntity(new EntityImpl(ctx), recorder, recorder, recorder, recorder, doNothing, recorder, this.getDatabase(), this.getAttachments(), this.getFileStorage(ctx));
            return recorder.getProblems();
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
            Exception wrapMe = new Exception(e.getMessage());
            throw new MBeanException(wrapMe, e.getMessage());
        }
        catch (RuntimeException e) {
            LOG.error("", (Throwable)e);
            throw e;
        }
        catch (Error e) {
            LOG.error("", (Throwable)e);
            throw e;
        }
    }

    @Override
    public Map<MBeanEntity, List<String>> listMissingFilesInFilestore(int filestoreId) throws MBeanException {
        try {
            LOG.info("Listing missing files in filestore {}", (Object)filestoreId);
            return this.listMissing(this.getEntitiesForFilestore(filestoreId));
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
            Exception wrapMe = new Exception(e.getMessage());
            throw new MBeanException(wrapMe, e.getMessage());
        }
        catch (RuntimeException e) {
            LOG.error("", (Throwable)e);
            throw e;
        }
        catch (Error e) {
            LOG.error("", (Throwable)e);
            throw e;
        }
    }

    @Override
    public Map<MBeanEntity, List<String>> listMissingFilesInDatabase(int databaseId) throws MBeanException {
        try {
            LOG.info("List missing files in database {}", (Object)databaseId);
            return this.listMissing(this.toEntities(this.getContextsForDatabase(databaseId)));
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
            Exception wrapMe = new Exception(e.getMessage());
            throw new MBeanException(wrapMe, e.getMessage());
        }
        catch (RuntimeException e) {
            LOG.error("", (Throwable)e);
            throw e;
        }
        catch (Error e) {
            LOG.error("", (Throwable)e);
            throw e;
        }
    }

    @Override
    public Map<MBeanEntity, List<String>> listAllMissingFiles() throws MBeanException {
        try {
            LOG.info("List all missing files");
            return this.listMissing(this.toEntities(this.getAllContexts()));
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
            Exception wrapMe = new Exception(e.getMessage());
            throw new MBeanException(wrapMe, e.getMessage());
        }
        catch (RuntimeException e) {
            LOG.error("", (Throwable)e);
            throw e;
        }
        catch (Error e) {
            LOG.error("", (Throwable)e);
            throw e;
        }
    }

    @Override
    public List<String> listUnassignedFilesInContext(int contextId) throws MBeanException {
        try {
            LOG.info("List all unassigned files in context {}", (Object)contextId);
            DoNothingSolver doNothing = new DoNothingSolver();
            RecordSolver recorder = new RecordSolver();
            Context ctx = this.getContext(contextId);
            this.checkOneEntity(new EntityImpl(ctx), doNothing, doNothing, doNothing, doNothing, recorder, doNothing, this.getDatabase(), this.getAttachments(), this.getFileStorage(ctx));
            return recorder.getProblems();
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
            Exception wrapMe = new Exception(e.getMessage());
            throw new MBeanException(wrapMe, e.getMessage());
        }
        catch (RuntimeException e) {
            LOG.error("", (Throwable)e);
            throw e;
        }
        catch (Error e) {
            LOG.error("", (Throwable)e);
            throw e;
        }
    }

    @Override
    public Map<MBeanEntity, List<String>> listUnassignedFilesInFilestore(int filestoreId) throws MBeanException {
        try {
            LOG.info("List all unassigned files in filestore {}", (Object)filestoreId);
            return this.listUnassigned(this.getEntitiesForFilestore(filestoreId));
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
            Exception wrapMe = new Exception(e.getMessage());
            throw new MBeanException(wrapMe, e.getMessage());
        }
        catch (RuntimeException e) {
            LOG.error("", (Throwable)e);
            throw e;
        }
        catch (Error e) {
            LOG.error("", (Throwable)e);
            throw e;
        }
    }

    @Override
    public Map<MBeanEntity, List<String>> listUnassignedFilesInDatabase(int databaseId) throws MBeanException {
        try {
            LOG.info("List all unassigned files in database {}", (Object)databaseId);
            return this.listUnassigned(this.toEntities(this.getContextsForDatabase(databaseId)));
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
            Exception wrapMe = new Exception(e.getMessage());
            throw new MBeanException(wrapMe, e.getMessage());
        }
        catch (RuntimeException e) {
            LOG.error("", (Throwable)e);
            throw e;
        }
        catch (Error e) {
            LOG.error("", (Throwable)e);
            throw e;
        }
    }

    @Override
    public Map<MBeanEntity, List<String>> listAllUnassignedFiles() throws MBeanException {
        try {
            LOG.info("List all unassigned files");
            return this.listUnassigned(this.toEntities(this.getAllContexts()));
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
            Exception wrapMe = new Exception(e.getMessage());
            throw new MBeanException(wrapMe, e.getMessage());
        }
        catch (RuntimeException e) {
            LOG.error("", (Throwable)e);
            throw e;
        }
        catch (Error e) {
            LOG.error("", (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteContextFromConfigDB(Connection configCon, int contextId) throws SQLException {
        Statement stmt = null;
        try {
            LOG.debug("Deleting context_server2dbpool mapping for context {}", (Object)contextId);
            stmt = configCon.prepareStatement("DELETE FROM context_server2db_pool WHERE cid=?");
            stmt.setInt(1, contextId);
            stmt.executeUpdate();
            stmt.close();
            try {
                Database.reset(contextId);
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
            }
            LOG.debug("Deleting login2context entries for context {}", (Object)contextId);
            stmt = configCon.prepareStatement("DELETE FROM login2context WHERE cid=?");
            stmt.setInt(1, contextId);
            stmt.executeUpdate();
            stmt.close();
            LOG.debug("Deleting context entry for context {}", (Object)contextId);
            stmt = configCon.prepareStatement("DELETE FROM context WHERE cid=?");
            stmt.setInt(1, contextId);
            stmt.executeUpdate();
            stmt.close();
        }
        finally {
            if (null != stmt) {
                stmt.close();
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<String> checkOrRepairConfigDB(boolean repair) throws MBeanException {
        ArrayList<String> i$;
        if (repair) {
            LOG.info("Repair inconsistent configdb");
        } else {
            LOG.info("List inconsistent configdb");
        }
        DatabaseService databaseService = null;
        Connection confCon = null;
        Connection poolCon = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<String> ret = new ArrayList<String>();
        HashMap schemaMap = new HashMap();
        try {
            List ctxs;
            databaseService = ConsistencyServiceLookup.getService(DatabaseService.class, true);
            Map<String, Integer> schemaPoolMap = Tools.getAllSchemata(LOG);
            confCon = databaseService.getReadOnly();
            stmt = confCon.prepareStatement("SELECT db_schema,cid FROM context_server2db_pool");
            rs = stmt.executeQuery();
            while (rs.next()) {
                String schema = rs.getString(1);
                Integer ctx = rs.getInt(2);
                if (schemaMap.containsKey(schema)) {
                    ((List)schemaMap.get(schema)).add(ctx);
                    continue;
                }
                ctxs = new ArrayList<Integer>();
                ctxs.add(ctx);
                schemaMap.put(schema, ctxs);
            }
            DBUtils.closeSQLStuff(rs, stmt);
            stmt = null;
            for (String schema : schemaMap.keySet()) {
                ctxs = (List)schemaMap.get(schema);
                Integer poolid = schemaPoolMap.get(schema);
                poolCon = databaseService.get(poolid.intValue(), schema);
                String contextids = "";
                for (Integer c : ctxs) {
                    contextids = contextids + c + ",";
                }
                contextids = contextids.substring(0, contextids.length() - 1);
                stmt = poolCon.prepareStatement("SELECT cid FROM login2user WHERE cid IN (" + contextids + ") GROUP BY cid");
                rs = stmt.executeQuery();
                while (rs.next()) {
                    Integer ctx = rs.getInt(1);
                    ctxs.remove(ctx);
                }
                if (ctxs.size() > 0) {
                    LOG.info("Schema {} is broken", (Object)schema);
                    for (Integer ctx : ctxs) {
                        if (repair) {
                            LOG.info("Deleting inconsistent entry for context {} from configdb", (Object)ctx);
                            this.deleteContextFromConfigDB(confCon, ctx);
                            ret.add("Deleted inconsistent entry for context " + ctx + " from configdb");
                            continue;
                        }
                        LOG.info("Context {} does not exist anymore", (Object)ctx);
                        ret.add("Context " + ctx + " does not exist anymore");
                    }
                }
                DBUtils.closeSQLStuff(rs, stmt);
                stmt = null;
                databaseService.back(poolid.intValue(), poolCon);
                poolCon = null;
            }
            if (ret.size() == 0 && repair) {
                ret.add("there was nothing to repair");
            }
            DBUtils.closeSQLStuff(rs, stmt);
            stmt = null;
            i$ = ret;
        }
        catch (SQLException e) {
            try {
                LOG.error("", (Throwable)e);
                Exception wrapMe = new Exception(e.getMessage());
                throw new MBeanException(wrapMe, e.getMessage());
                catch (OXException e2) {
                    LOG.error("", (Throwable)e2);
                    wrapMe = new Exception(e2.getMessage());
                    throw new MBeanException(wrapMe, e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                if (databaseService != null) {
                    if (null != confCon) {
                        databaseService.backReadOnly(confCon);
                    }
                    if (null != poolCon) {
                        databaseService.backReadOnly(poolCon);
                    }
                }
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        if (databaseService != null) {
            if (null != confCon) {
                databaseService.backReadOnly(confCon);
            }
            if (null != poolCon) {
                databaseService.backReadOnly(poolCon);
            }
        }
        return i$;
    }

    private Map<MBeanEntity, List<String>> listMissing(List<Entity> entities) throws OXException {
        HashMap<MBeanEntity, List<String>> retval = new HashMap<MBeanEntity, List<String>>();
        DoNothingSolver doNothing = new DoNothingSolver();
        for (Entity entity : entities) {
            RecordSolver recorder = new RecordSolver();
            this.checkOneEntity(entity, recorder, recorder, recorder, recorder, doNothing, recorder, this.getDatabase(), this.getAttachments(), this.getFileStorage(entity));
            retval.put(this.toMBeanEntity(entity), recorder.getProblems());
        }
        return retval;
    }

    private MBeanEntity toMBeanEntity(Entity entity) {
        switch (entity.getType()) {
            case Context: {
                return new MBeanEntity(entity.getContext().getContextId());
            }
            case User: {
                return new MBeanEntity(entity.getContext().getContextId(), entity.getUser().getId());
            }
        }
        throw new IllegalArgumentException("Unknown entity type: " + (Object)((Object)entity.getType()));
    }

    private Map<MBeanEntity, List<String>> listUnassigned(List<Entity> entities) throws OXException {
        HashMap<MBeanEntity, List<String>> retval = new HashMap<MBeanEntity, List<String>>();
        DoNothingSolver doNothing = new DoNothingSolver();
        for (Entity entity : entities) {
            RecordSolver recorder = new RecordSolver();
            this.checkOneEntity(entity, doNothing, doNothing, doNothing, doNothing, recorder, doNothing, this.getDatabase(), this.getAttachments(), this.getFileStorage(entity));
            retval.put(this.toMBeanEntity(entity), recorder.getProblems());
        }
        return retval;
    }

    @Override
    public void repairFilesInContext(int contextId, String resolverPolicy) throws MBeanException {
        try {
            ArrayList<Context> repairMe = new ArrayList<Context>();
            repairMe.add(this.getContext(contextId));
            this.repair(this.toEntities(repairMe), resolverPolicy);
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
            Exception wrapMe = new Exception(e.getMessage());
            throw new MBeanException(wrapMe, e.getMessage());
        }
        catch (RuntimeException e) {
            LOG.error("", (Throwable)e);
            throw e;
        }
        catch (Error e) {
            LOG.error("", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void repairFilesInFilestore(int filestoreId, String resolverPolicy) throws MBeanException {
        try {
            this.repair(this.toEntities(this.getContextsForFilestore(filestoreId)), resolverPolicy);
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
            Exception wrapMe = new Exception(e.getMessage());
            throw new MBeanException(wrapMe, e.getMessage());
        }
        catch (RuntimeException e) {
            LOG.error("", (Throwable)e);
            throw e;
        }
        catch (Error e) {
            LOG.error("", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void repairFilesInDatabase(int databaseId, String resolverPolicy) throws MBeanException {
        try {
            this.repair(this.toEntities(this.getContextsForDatabase(databaseId)), resolverPolicy);
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
            Exception wrapMe = new Exception(e.getMessage());
            throw new MBeanException(wrapMe, e.getMessage());
        }
        catch (RuntimeException e) {
            LOG.error("", (Throwable)e);
            throw e;
        }
        catch (Error e) {
            LOG.error("", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void repairAllFiles(String resolverPolicy) throws MBeanException {
        try {
            this.repair(this.toEntities(this.getAllContexts()), resolverPolicy);
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
            Exception wrapMe = new Exception(e.getMessage());
            throw new MBeanException(wrapMe, e.getMessage());
        }
        catch (RuntimeException e) {
            LOG.error("", (Throwable)e);
            throw e;
        }
        catch (Error e) {
            LOG.error("", (Throwable)e);
            throw e;
        }
    }

    private void repair(List<Entity> entities, String policy) throws OXException {
        DatabaseImpl database = this.getDatabase();
        AttachmentBase attachments2 = this.getAttachments();
        for (Entity entity : entities) {
            FileStorage storage = this.getFileStorage(entity);
            ResolverPolicy resolvers = ResolverPolicy.parse(policy, database, attachments2, storage, this, entity.getContext());
            this.checkOneEntity(entity, resolvers.dbsolver, resolvers.attachmentsolver, resolvers.snippetsolver, new DeleteBrokenPreviewReferencesSolver(), resolvers.filesolver, resolvers.vCardSolver, database, attachments2, storage);
            boolean quotaAware = false;
            ConfigurationService configurationService = ServerServiceRegistry.getServize(ConfigurationService.class);
            if (configurationService != null) {
                quotaAware = configurationService.getBoolProperty("com.openexchange.preview.cache.quotaAware", false);
            }
            Set<String> filesToIgnore = quotaAware ? Collections.emptySet() : (entity.getType().equals((Object)Entity.EntityType.Context) ? this.getPreviewCacheFileStoreLocationsPerContext(entity.getContext()) : Collections.emptySet());
            this.recalculateUsage(storage, filesToIgnore);
        }
    }

    private void output(String text) {
        LOG.info(text);
    }

    private void erroroutput(Exception e) {
        LOG.error("", (Throwable)e);
    }

    private void outputSet(SortedSet<String> set) {
        Iterator itstr = set.iterator();
        StringBuilder sb = new StringBuilder();
        while (itstr.hasNext()) {
            sb.append((String)itstr.next()).append('\n');
        }
        this.output(sb.toString());
    }

    private boolean diffset(SortedSet<String> first, SortedSet<String> second, String name, String name2) {
        boolean retval = false;
        first.removeAll(second);
        if (!first.isEmpty()) {
            this.output("Inconsistencies found in " + name + ", the following files aren't in " + name2 + ':');
            this.outputSet(first);
            retval = true;
        }
        return retval;
    }

    private void checkOneEntity(Entity entity, ProblemSolver dbSolver, ProblemSolver attachmentSolver, ProblemSolver snippetSolver, ProblemSolver previewSolver, ProblemSolver fileSolver, ProblemSolver vCardSolver, DatabaseImpl database, AttachmentBase attach, FileStorage fileStorage) throws OXException {
        LOG.info("Checking entity {}. Using solvers db: {} attachments: {} snippets: {} files: {} vcards: {}", new Object[]{entity, dbSolver.description(), attachmentSolver.description(), snippetSolver.description(), fileSolver.description(), vCardSolver.description()});
        try {
            fileStorage.recreateStateFile();
        }
        catch (OXException e) {
            if (!FileStorageCodes.NO_SUCH_FILE_STORAGE.equals(e)) {
                throw e;
            }
            Object[] logArgs = e.getLogArgs();
            LOG.info("Cannot check files in filestore for entity {} since associated filestore does not (yet) exist: {}", (Object)entity, (Object)(null == logArgs || 0 == logArgs.length ? e.getMessage() : logArgs[0].toString()));
            return;
        }
        LOG.info("Listing all files in filestores");
        SortedSet<String> filestoreset = new TreeSet();
        filestoreset = fileStorage.getFileList();
        LOG.info("Found {} files in the filestore for this entity {}", (Object)filestoreset.size(), (Object)entity);
        try {
            boolean isContext = entity.getType().equals((Object)Entity.EntityType.Context);
            LOG.info("Loading all infostore filestore locations");
            SortedSet<String> dbfileset = isContext ? database.getDocumentFileStoreLocationsperContext(entity.getContext()) : database.getDocumentFileStoreLocationsPerUser(entity.getContext(), entity.getUser());
            LOG.info("Found {} infostore filepaths", (Object)dbfileset.size());
            if (isContext) {
                SortedSet<String> attachmentset = attach.getAttachmentFileStoreLocationsperContext(entity.getContext());
                LOG.info("Found {} attachments", (Object)attachmentset.size());
                SortedSet<String> snippetset = this.getSnippetFileStoreLocationsPerContext(entity.getContext());
                LOG.info("Found {} snippets", (Object)snippetset.size());
                SortedSet<String> previewset = this.getPreviewCacheFileStoreLocationsPerContext(entity.getContext());
                LOG.info("Found {} previews", (Object)previewset.size());
                SortedSet<String> vcardset = this.getVCardFileStoreLocationsPerContext(entity.getContext());
                LOG.info("Found {} vCards", (Object)vcardset.size());
                TreeSet<String> joineddbfileset = new TreeSet<String>(dbfileset);
                joineddbfileset.addAll(attachmentset);
                joineddbfileset.addAll(snippetset);
                joineddbfileset.addAll(previewset);
                joineddbfileset.addAll(vcardset);
                LOG.info("Found {} filestore ids in total. There are {} files in the filespool. A difference of {}", new Object[]{joineddbfileset.size(), filestoreset.size(), Math.abs(joineddbfileset.size() - filestoreset.size())});
                if (this.diffset(dbfileset, filestoreset, "database list", "filestore list")) {
                    dbSolver.solve(entity, dbfileset);
                }
                if (this.diffset(attachmentset, filestoreset, "database list of attachment files", "filestore list")) {
                    attachmentSolver.solve(entity, attachmentset);
                }
                if (this.diffset(snippetset, filestoreset, "database list of snippet files", "filestore list")) {
                    snippetSolver.solve(entity, snippetset);
                }
                if (this.diffset(previewset, filestoreset, "database list of cached previews", "filestore list")) {
                    previewSolver.solve(entity, previewset);
                }
                if (this.diffset(vcardset, filestoreset, "database list of VCard files", "filestore list")) {
                    vCardSolver.solve(entity, vcardset);
                }
                if (this.diffset(filestoreset, joineddbfileset, "filestore list", "one of the databases")) {
                    fileSolver.solve(entity, filestoreset);
                }
            }
        }
        catch (OXException e) {
            this.erroroutput((Exception)((Object)e));
        }
    }

    private void recalculateUsage(FileStorage storage, Set<String> filesToIgnore) {
        try {
            if (storage instanceof QuotaFileStorage) {
                this.output("Recalculating usage...");
                ((QuotaFileStorage)storage).recalculateUsage(filesToIgnore);
            }
        }
        catch (OXException e) {
            this.erroroutput((Exception)((Object)e));
        }
    }

    private List<Entity> toEntities(List<Context> contexts) {
        ArrayList<Entity> entities = new ArrayList<Entity>(contexts.size());
        for (Context ctx : contexts) {
            entities.add(new EntityImpl(ctx));
        }
        return entities;
    }

    protected abstract Context getContext(int var1) throws OXException;

    protected abstract DatabaseImpl getDatabase();

    protected abstract AttachmentBase getAttachments();

    protected abstract FileStorage getFileStorage(Context var1) throws OXException;

    protected abstract FileStorage getFileStorage(Context var1, User var2) throws OXException;

    protected abstract FileStorage getFileStorage(Entity var1) throws OXException;

    protected abstract List<Context> getContextsForFilestore(int var1) throws OXException;

    protected abstract List<Entity> getEntitiesForFilestore(int var1) throws OXException;

    protected abstract List<Context> getContextsForDatabase(int var1) throws OXException;

    protected abstract List<Context> getAllContexts() throws OXException;

    protected abstract SortedSet<String> getSnippetFileStoreLocationsPerContext(Context var1) throws OXException;

    protected abstract SortedSet<String> getVCardFileStoreLocationsPerContext(Context var1) throws OXException;

    protected abstract SortedSet<String> getPreviewCacheFileStoreLocationsPerContext(Context var1) throws OXException;

    protected abstract User getAdmin(Context var1) throws OXException;

    private static final class ResolverPolicy {
        final ProblemSolver dbsolver;
        final ProblemSolver attachmentsolver;
        final ProblemSolver snippetsolver;
        final ProblemSolver filesolver;
        final ProblemSolver vCardSolver;

        public ResolverPolicy(ProblemSolver dbsolver, ProblemSolver attachmentsolver, ProblemSolver snippetsolver, ProblemSolver filesolver, ProblemSolver vCardSolver) {
            this.dbsolver = dbsolver;
            this.attachmentsolver = attachmentsolver;
            this.snippetsolver = snippetsolver;
            this.filesolver = filesolver;
            this.vCardSolver = vCardSolver;
        }

        public static ResolverPolicy parse(String list, DatabaseImpl database, AttachmentBase attach, FileStorage storage, Consistency consistency, Context context) throws OXException {
            String[] options = list.split("\\s*,\\s*");
            ProblemSolver dbsolver = new DoNothingSolver();
            ProblemSolver attachmentsolver = new DoNothingSolver();
            ProblemSolver snippetsolver = new DoNothingSolver();
            ProblemSolver filesolver = new DoNothingSolver();
            ProblemSolver vCardSolver = new DoNothingSolver();
            for (String option : options) {
                String[] tuple = option.split("\\s*:\\s*");
                if (tuple.length != 2) {
                    throw ConsistencyExceptionCodes.MALFORMED_POLICY.create();
                }
                String condition = tuple[0];
                String action = tuple[1];
                if ("missing_file_for_infoitem".equals(condition)) {
                    if ("create_dummy".equals(action)) {
                        dbsolver = new CreateDummyFileForInfoitemSolver(database, storage, consistency.getAdmin(context));
                        continue;
                    }
                    if ("delete".equals(action)) {
                        dbsolver = new DeleteInfoitemSolver(database);
                        continue;
                    }
                    dbsolver = new DoNothingSolver();
                    continue;
                }
                if ("missing_file_for_attachment".equals(condition)) {
                    if ("create_dummy".equals(action)) {
                        attachmentsolver = new CreateDummyFileForAttachmentSolver(attach, storage);
                        continue;
                    }
                    if ("delete".equals(action)) {
                        attachmentsolver = new DeleteAttachmentSolver(attach);
                        continue;
                    }
                    attachmentsolver = new DoNothingSolver();
                    continue;
                }
                if ("missing_file_for_snippet".equals(condition)) {
                    if ("create_dummy".equals(action)) {
                        snippetsolver = new CreateDummyFileForSnippetSolver(storage);
                        continue;
                    }
                    if ("delete".equals(action)) {
                        snippetsolver = new DeleteSnippetSolver();
                        continue;
                    }
                    snippetsolver = new DoNothingSolver();
                    continue;
                }
                if ("missing_file_for_vcard".equals(condition)) {
                    if ("delete".equals(action)) {
                        vCardSolver = new DeleteBrokenVCardReferencesSolver();
                        continue;
                    }
                    vCardSolver = new DoNothingSolver();
                    continue;
                }
                if (!"missing_entry_for_file".equals(condition)) continue;
                filesolver = "create_admin_infoitem".equals(action) ? new CreateInfoitemSolver(database, storage, consistency.getAdmin(context)) : ("delete".equals(action) ? new RemoveFileSolver(storage) : new DoNothingSolver());
            }
            return new ResolverPolicy(dbsolver, attachmentsolver, snippetsolver, filesolver, vCardSolver);
        }
    }
}

