/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.configuration;

import com.openexchange.java.Strings;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;

public final class ClientWhitelist {
    private final ConcurrentMap<Pattern, Pattern> map = new ConcurrentHashMap<Pattern, Pattern>(4, 0.9f, 1);
    private final ConcurrentMap<String, Boolean> allowedCache = new ConcurrentHashMap<String, Boolean>(4, 0.9f, 1);

    public ClientWhitelist add(String wildcardPatterns) {
        String[] wps;
        if (null == wildcardPatterns) {
            return this;
        }
        this.allowedCache.clear();
        for (String wildcardPattern : wps = wildcardPatterns.split(" *, *", 0)) {
            if (Strings.isEmpty((String)wildcardPattern)) continue;
            this.add(Pattern.compile(Strings.wildcardToRegex((String)ClientWhitelist.removeQuotes(wildcardPattern.trim())), 2));
        }
        return this;
    }

    public boolean add(Pattern pattern) {
        this.allowedCache.clear();
        return null == this.map.putIfAbsent(pattern, pattern);
    }

    public int size() {
        return this.map.size();
    }

    public boolean contains(Pattern pattern) {
        return this.map.containsKey(pattern);
    }

    public boolean remove(Pattern pattern) {
        this.allowedCache.clear();
        return null != this.map.remove(pattern);
    }

    public void clear() {
        this.map.clear();
        this.allowedCache.clear();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Set<Pattern> getPatterns() {
        return new HashSet<Pattern>(this.map.keySet());
    }

    public boolean isAllowed(String clientId) {
        if (null == clientId) {
            return false;
        }
        Boolean cached = (Boolean)this.allowedCache.get(clientId);
        if (null != cached) {
            return cached;
        }
        for (Pattern pattern : this.map.keySet()) {
            if (!pattern.matcher(clientId).matches()) continue;
            this.allowedCache.put(clientId, Boolean.TRUE);
            return true;
        }
        this.allowedCache.put(clientId, Boolean.FALSE);
        return false;
    }

    private static String removeQuotes(String quoted) {
        int end;
        if (quoted.length() < 2 || quoted.charAt(0) != '\"') {
            return quoted;
        }
        String retval = quoted.substring(1);
        if (retval.charAt(end = retval.length() - 1) == '\"') {
            retval = retval.substring(0, end);
        }
        return retval;
    }
}

