/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.concurrent;

import com.openexchange.concurrent.TimeoutListener;
import com.openexchange.exception.OXException;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.timer.ScheduledTimerTask;
import com.openexchange.timer.TimerService;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class TimeoutConcurrentSet<E> {
    private final ConcurrentMap<E, ElementWrapper<E>> map;
    private final ScheduledTimerTask timeoutTask;
    private final boolean forceTimeout;
    private TimeoutListener<E> defaultTimeoutListener;
    private volatile boolean disposed;

    public TimeoutConcurrentSet(int shrinkerIntervalSeconds) throws OXException {
        this(shrinkerIntervalSeconds, false);
    }

    public TimeoutConcurrentSet(int shrinkerIntervalSeconds, boolean forceTimeout) throws OXException {
        this.forceTimeout = forceTimeout;
        this.map = new ConcurrentHashMap<E, ElementWrapper<E>>();
        TimerService timer = ServerServiceRegistry.getInstance().getService(TimerService.class, true);
        this.timeoutTask = timer.scheduleWithFixedDelay(new TimedRunnable<E>(this.map), 1000L, (long)(shrinkerIntervalSeconds * 1000));
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.disposed) {
            return;
        }
        TimeoutConcurrentSet timeoutConcurrentSet = this;
        synchronized (timeoutConcurrentSet) {
            if (this.disposed) {
                return;
            }
            this.timeoutTask.cancel(true);
            TimerService timer = ServerServiceRegistry.getInstance().getService(TimerService.class);
            if (null != timer) {
                timer.purge();
            }
            this.clear();
            this.disposed = true;
        }
    }

    public void clear() {
        this.map.clear();
    }

    public void timeoutAll() {
        if (this.disposed) {
            throw new IllegalStateException("time-out map was disposed.");
        }
        Iterator it = this.map.values().iterator();
        while (it.hasNext()) {
            ElementWrapper vw = (ElementWrapper)it.next();
            it.remove();
            if (vw.timeoutListener == null) continue;
            vw.timeoutListener.onTimeout(vw.value);
        }
    }

    public void timeout(E element) {
        if (this.disposed) {
            throw new IllegalStateException("time-out map was disposed.");
        }
        ElementWrapper vw = (ElementWrapper)this.map.remove(element);
        if (vw != null && vw.timeoutListener != null) {
            vw.timeoutListener.onTimeout(vw.value);
        }
    }

    public boolean add(E element, int timeToLiveSeconds) {
        return this.add(element, timeToLiveSeconds, this.defaultTimeoutListener);
    }

    public boolean add(E element, int timeToLiveSeconds, TimeoutListener<E> timeoutListener) {
        if (this.disposed) {
            throw new IllegalStateException("time-out map was disposed.");
        }
        ElementWrapper<E> vw = this.map.putIfAbsent(element, new ElementWrapper<E>(element, timeToLiveSeconds * 1000, this.forceTimeout, timeoutListener));
        if (null == vw) {
            return true;
        }
        vw.touch();
        return false;
    }

    public boolean contains(E element) {
        if (this.disposed) {
            throw new IllegalStateException("time-out map was disposed.");
        }
        return this.map.containsKey(element);
    }

    public Iterator<E> iterator() {
        if (this.disposed) {
            throw new IllegalStateException("time-out map was disposed.");
        }
        return new ElementIterator(this.map.values().iterator());
    }

    public E getAny() {
        if (this.disposed) {
            throw new IllegalStateException("time-out map was disposed.");
        }
        if (this.map.isEmpty()) {
            return null;
        }
        Iterator iterator = this.map.values().iterator();
        return iterator.hasNext() ? (E)((ElementWrapper)iterator.next()).touch() : null;
    }

    public boolean remove(E element) {
        if (this.disposed) {
            throw new IllegalStateException("time-out map was disposed.");
        }
        return null != this.map.remove(element);
    }

    public TimeoutListener<E> getDefaultTimeoutListener() {
        return this.defaultTimeoutListener;
    }

    public void setDefaultTimeoutListener(TimeoutListener<E> defaultTimeoutListener) {
        this.defaultTimeoutListener = defaultTimeoutListener;
    }

    private static final class ElementIterator<E>
    implements Iterator<E> {
        private final Iterator<ElementWrapper<E>> delegatee;

        public ElementIterator(Iterator<ElementWrapper<E>> delegatee) {
            this.delegatee = delegatee;
        }

        @Override
        public boolean hasNext() {
            return this.delegatee.hasNext();
        }

        @Override
        public E next() {
            return this.delegatee.next().touch();
        }

        @Override
        public void remove() {
            this.delegatee.remove();
        }
    }

    private static final class TimedRunnable<E>
    implements Runnable {
        private final ConcurrentMap<E, ElementWrapper<E>> tmap;

        TimedRunnable(ConcurrentMap<E, ElementWrapper<E>> tmap) {
            this.tmap = tmap;
        }

        @Override
        public void run() {
            long now = System.currentTimeMillis();
            Iterator it = this.tmap.values().iterator();
            while (it.hasNext()) {
                ElementWrapper vw = (ElementWrapper)it.next();
                if (now - vw.lastAccessed <= vw.ttl) continue;
                it.remove();
                if (vw.timeoutListener == null) continue;
                vw.timeoutListener.onTimeout(vw.value);
            }
        }
    }

    private static final class ElementWrapper<E> {
        public final E value;
        public final long ttl;
        public final TimeoutListener<E> timeoutListener;
        public final boolean forceTimeout;
        public volatile long lastAccessed;

        public ElementWrapper(E value, long ttl, boolean forceTimeout, TimeoutListener<E> timeoutListener) {
            this.value = value;
            this.ttl = ttl;
            this.lastAccessed = System.currentTimeMillis();
            this.timeoutListener = timeoutListener;
            this.forceTimeout = forceTimeout;
        }

        public E touch() {
            if (this.forceTimeout) {
                return this.value;
            }
            this.lastAccessed = System.currentTimeMillis();
            return this.value;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ElementWrapper)) {
                return false;
            }
            ElementWrapper other = (ElementWrapper)obj;
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }
}

