/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.cache.impl;

import com.openexchange.cache.impl.QueryCacheKey;
import com.openexchange.caching.Cache;
import com.openexchange.caching.CacheKey;
import com.openexchange.caching.CacheService;
import com.openexchange.exception.OXException;
import com.openexchange.java.Autoboxing;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class FolderQueryCacheManager {
    private static final String REGION_NAME = "OXFolderQueryCache";
    private static volatile FolderQueryCacheManager instance;
    private Cache folderQueryCache;
    private final Lock cacheLock = new ReentrantLock(true);
    private static final QueryCacheKey.Module MODULE;

    private FolderQueryCacheManager() throws OXException {
        this.initCache();
    }

    public static boolean isInitialized() {
        return instance != null;
    }

    public static void initInstance() throws OXException {
        FolderQueryCacheManager.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FolderQueryCacheManager getInstance() throws OXException {
        if (instance != null) return instance;
        Class<FolderQueryCacheManager> clazz = FolderQueryCacheManager.class;
        synchronized (FolderQueryCacheManager.class) {
            if (instance != null) return instance;
            instance = new FolderQueryCacheManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void initCache() throws OXException {
        if (this.folderQueryCache != null) {
            return;
        }
        this.folderQueryCache = ServerServiceRegistry.getInstance().getService(CacheService.class).getCache(REGION_NAME);
    }

    public void releaseCache() throws OXException {
        if (this.folderQueryCache == null) {
            return;
        }
        this.folderQueryCache.clear();
        this.folderQueryCache = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void releaseInstance() throws OXException {
        if (instance == null) return;
        Class<FolderQueryCacheManager> clazz = FolderQueryCacheManager.class;
        synchronized (FolderQueryCacheManager.class) {
            if (instance == null) return;
            instance = null;
            CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
            if (null == cacheService) return;
            cacheService.freeCache(REGION_NAME);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public LinkedList<Integer> getFolderQuery(int queryNum, Session session) {
        return this.getFolderQuery(queryNum, session.getUserId(), session.getContextId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedList<Integer> getFolderQuery(int queryNum, int userId, int cid) {
        if (null == this.folderQueryCache) {
            return null;
        }
        this.cacheLock.lock();
        try {
            LinkedList retval;
            Object tmp = this.folderQueryCache.getFromGroup((Serializable)FolderQueryCacheManager.createUserKey(userId), FolderQueryCacheManager.createContextKey(cid));
            if (null == tmp) {
                LinkedList<Integer> linkedList = null;
                return linkedList;
            }
            Map map = (Map)tmp;
            LinkedList q = (LinkedList)map.get(this.createQueryKey(queryNum));
            if (null == q) {
                LinkedList<Integer> linkedList = null;
                return linkedList;
            }
            LinkedList linkedList = retval = (LinkedList)q.clone();
            return linkedList;
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    public void putFolderQuery(int queryNum, LinkedList<Integer> q, Session session) throws OXException {
        this.putFolderQuery(queryNum, q, session.getUserId(), session.getContextId());
    }

    public void putFolderQuery(int queryNum, LinkedList<Integer> q, int userId, int cid) throws OXException {
        this.putFolderQuery(queryNum, q, userId, cid, false);
    }

    public void putFolderQuery(int queryNum, LinkedList<Integer> q, Session session, boolean append) throws OXException {
        this.putFolderQuery(queryNum, q, session.getUserId(), session.getContextId(), append);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putFolderQuery(int queryNum, LinkedList<Integer> q, int userId, int cid, boolean append) throws OXException {
        if (null == this.folderQueryCache) {
            return;
        }
        if (q == null) {
            return;
        }
        CacheKey queryKey = this.createQueryKey(queryNum);
        this.cacheLock.lock();
        try {
            LinkedList tmp;
            boolean insertMap = false;
            HashMap<CacheKey, LinkedList> map = (HashMap<CacheKey, LinkedList>)this.folderQueryCache.getFromGroup((Serializable)FolderQueryCacheManager.createUserKey(userId), FolderQueryCacheManager.createContextKey(cid));
            if (map == null) {
                map = new HashMap<CacheKey, LinkedList>();
                insertMap = true;
            }
            if ((tmp = (LinkedList)map.get(queryKey)) == null || !append) {
                LinkedList clone = (LinkedList)q.clone();
                map.put(queryKey, clone);
            } else {
                LinkedList clone = (LinkedList)q.clone();
                tmp.addAll(clone);
            }
            if (insertMap) {
                this.folderQueryCache.putInGroup((Serializable)FolderQueryCacheManager.createUserKey(userId), FolderQueryCacheManager.createContextKey(cid), (Serializable)map);
            }
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    public void invalidateContextQueries(Session session) {
        this.invalidateContextQueries(session.getContextId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateContextQueries(int cid) {
        if (null == this.folderQueryCache) {
            return;
        }
        this.cacheLock.lock();
        try {
            this.folderQueryCache.invalidateGroup(FolderQueryCacheManager.createContextKey(cid));
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    private CacheKey createQueryKey(int queryNum) {
        return this.folderQueryCache.newCacheKey(MODULE.getNum(), queryNum);
    }

    private static Integer createUserKey(int userId) {
        return Autoboxing.I((int)userId);
    }

    private static String createContextKey(int cid) {
        return Integer.toString(cid);
    }

    static {
        MODULE = QueryCacheKey.Module.FOLDER;
    }
}

