/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.cache.impl;

import com.openexchange.caching.Cache;
import com.openexchange.caching.CacheKey;
import com.openexchange.caching.CacheService;
import com.openexchange.caching.ElementAttributes;
import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.java.Autoboxing;
import com.openexchange.lock.LockService;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.threadpool.ThreadPools;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import com.openexchange.tools.oxfolder.OXFolderProperties;
import com.openexchange.tools.sql.DBUtils;
import gnu.trove.set.hash.TIntHashSet;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FolderCacheManager {
    private static final Logger LOG = LoggerFactory.getLogger(FolderCacheManager.class);
    private static final String REGION_NAME = "OXFolderCache";
    private static volatile FolderCacheManager instance;
    private volatile Cache folderCache;
    private final Lock cacheLock = new ReentrantLock();

    public static boolean isInitialized() {
        return instance != null;
    }

    public static boolean isEnabled() {
        return OXFolderProperties.isEnableFolderCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initInstance() throws OXException {
        if (instance != null) return;
        Class<FolderCacheManager> clazz = FolderCacheManager.class;
        synchronized (FolderCacheManager.class) {
            if (instance != null) return;
            instance = new FolderCacheManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FolderCacheManager getInstance() throws OXException {
        if (!OXFolderProperties.isEnableFolderCache()) {
            throw OXFolderExceptionCode.CACHE_NOT_ENABLED.create();
        }
        if (instance != null) return instance;
        Class<FolderCacheManager> clazz = FolderCacheManager.class;
        synchronized (FolderCacheManager.class) {
            if (instance != null) return instance;
            instance = new FolderCacheManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void releaseInstance() {
        if (instance == null) return;
        Class<FolderCacheManager> clazz = FolderCacheManager.class;
        synchronized (FolderCacheManager.class) {
            if (instance == null) return;
            instance = null;
            CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
            if (null == cacheService) return;
            try {
                cacheService.freeCache(REGION_NAME);
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
            }
            return;
        }
    }

    private FolderCacheManager() throws OXException {
        this.initCache();
    }

    public void initCache() throws OXException {
        if (this.folderCache != null) {
            return;
        }
        this.folderCache = ServerServiceRegistry.getInstance().getService(CacheService.class).getCache(REGION_NAME);
    }

    public void releaseCache() throws OXException {
        Cache folderCache = this.folderCache;
        if (folderCache == null) {
            return;
        }
        folderCache.clear();
        this.folderCache = null;
    }

    CacheKey getCacheKeyUsing(int cid, int objectId, Cache folderCache) {
        return folderCache.newCacheKey(cid, objectId);
    }

    public void clearFor(final Context ctx, boolean async) {
        Runnable task = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            @Override
            public void run() {
                int contextId = ctx.getContextId();
                Connection con = null;
                PreparedStatement stmt = null;
                ResultSet rs = null;
                try {
                    con = Database.get(contextId, false);
                    stmt = con.prepareStatement("SELECT fuid FROM oxfolder_tree WHERE cid=?");
                    stmt.setInt(1, contextId);
                    rs = stmt.executeQuery();
                    TIntHashSet folderIds = new TIntHashSet(1024);
                    while (rs.next()) {
                        folderIds.add(rs.getInt(1));
                    }
                    DBUtils.closeSQLStuff(rs, stmt);
                    stmt = con.prepareStatement("SELECT fuid FROM del_oxfolder_tree WHERE cid=?");
                    stmt.setInt(1, contextId);
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        folderIds.add(rs.getInt(1));
                    }
                    DBUtils.closeSQLStuff(rs, stmt);
                    rs = null;
                    stmt = null;
                    Database.back(contextId, false, con);
                    con = null;
                    FolderCacheManager.this.removeFolderObjects(folderIds.toArray(), ctx);
                }
                catch (Exception x) {
                    DBUtils.closeSQLStuff(rs, stmt);
                    if (null != con) {
                        Database.back(contextId, false, con);
                    }
                    catch (Throwable throwable) {
                        DBUtils.closeSQLStuff(rs, stmt);
                        if (null != con) {
                            Database.back(contextId, false, con);
                        }
                        throw throwable;
                    }
                }
                DBUtils.closeSQLStuff(rs, stmt);
                if (null != con) {
                    Database.back(contextId, false, con);
                }
            }
        };
        if (async && ThreadPools.getThreadPool() != null) {
            ThreadPools.getThreadPool().submit(ThreadPools.task((Runnable)task));
        } else {
            task.run();
        }
    }

    public FolderObject getFolderObject(int objectId, boolean fromCache, Context ctx, Connection readCon) throws OXException {
        Object object;
        Cache folderCache = this.folderCache;
        if (null == folderCache) {
            throw OXFolderExceptionCode.CACHE_NOT_ENABLED.create();
        }
        CacheKey cacheKey = this.getCacheKeyUsing(ctx.getContextId(), objectId, folderCache);
        if (fromCache) {
            object = folderCache.get((Serializable)cacheKey);
            if (object instanceof FolderObject) {
                return ((FolderObject)object).clone();
            }
            if (null == readCon) {
                FolderObject cloned = this.putFolderObject(new LoadingFolderProvider(objectId, ctx, null), ctx, false, null, true);
                if (null != cloned) {
                    return cloned;
                }
            } else {
                this.putIfAbsentInternal(new LoadingFolderProvider(objectId, ctx, readCon), ctx, null, cacheKey);
            }
        } else {
            this.putFolderObject(FolderCacheManager.loadFolderObjectInternal(objectId, ctx, readCon), ctx, true, null);
        }
        object = folderCache.get((Serializable)cacheKey);
        if (object instanceof FolderObject) {
            return ((FolderObject)object).clone();
        }
        FolderObject fo = FolderCacheManager.loadFolderObjectInternal(objectId, ctx, readCon);
        this.putFolderObject(fo, ctx, false == fromCache, null);
        return fo.clone();
    }

    public FolderObject getFolderObject(int objectId, Context ctx) {
        Cache folderCache = this.folderCache;
        if (null == folderCache) {
            return null;
        }
        Object tmp = folderCache.get((Serializable)this.getCacheKeyUsing(ctx.getContextId(), objectId, folderCache));
        if (tmp instanceof FolderObject) {
            return ((FolderObject)tmp).clone();
        }
        return null;
    }

    public List<FolderObject> getTrimedFolderObjects(int[] objectIds, Context ctx) {
        Cache folderCache = this.folderCache;
        if (null == folderCache) {
            return Collections.emptyList();
        }
        ArrayList<FolderObject> ret = new ArrayList<FolderObject>(objectIds.length);
        int contextId = ctx.getContextId();
        for (int objectId : objectIds) {
            Object tmp = folderCache.get((Serializable)this.getCacheKeyUsing(contextId, objectId, folderCache));
            if (!(tmp instanceof FolderObject)) continue;
            ret.add(((FolderObject)tmp).clone());
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FolderObject loadFolderObject(int folderId, Context ctx, Connection readCon) throws OXException {
        Object object;
        Cache folderCache = this.folderCache;
        if (null == folderCache) {
            throw OXFolderExceptionCode.CACHE_NOT_ENABLED.create();
        }
        CacheKey key = this.getCacheKeyUsing(ctx.getContextId(), folderId, folderCache);
        if (folderCache.isReplicated()) {
            LockService lockService = ServerServiceRegistry.getInstance().getService(LockService.class);
            Lock lock = null == lockService ? this.cacheLock : lockService.getSelfCleaningLockFor(new StringBuilder(32).append(REGION_NAME).append('-').append(ctx.getContextId()).append('-').append(folderId).toString());
            lock.lock();
            try {
                Object tmp = folderCache.get((Serializable)key);
                if (tmp instanceof FolderObject) {
                    folderCache.remove((Serializable)key);
                    CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
                    if (null != cacheService) {
                        try {
                            Cache globalCache = cacheService.getCache("GlobalFolderCache");
                            CacheKey cacheKey = cacheService.newCacheKey(1, new String[]{FolderStorage.REAL_TREE_ID, String.valueOf(folderId)});
                            globalCache.removeFromGroup((Serializable)cacheKey, String.valueOf(ctx.getContextId()));
                        }
                        catch (OXException e) {
                            LOG.warn("", (Throwable)e);
                        }
                    }
                }
            }
            finally {
                lock.unlock();
            }
        }
        if (null != readCon) {
            this.putIfAbsent(FolderCacheManager.loadFolderObjectInternal(folderId, ctx, readCon), ctx, null);
        }
        if ((object = folderCache.get((Serializable)key)) instanceof FolderObject) {
            return ((FolderObject)object).clone();
        }
        FolderObject fo = FolderCacheManager.loadFolderObjectInternal(folderId, ctx, readCon);
        this.putFolderObject(fo, ctx, true, null);
        return fo.clone();
    }

    public FolderObject putIfAbsent(FolderObject folderObj, Context ctx, ElementAttributes elemAttribs) throws OXException {
        if (!folderObj.containsObjectID()) {
            throw OXFolderExceptionCode.MISSING_FOLDER_ATTRIBUTE.create("id", Autoboxing.I((int)-1), Autoboxing.I((int)ctx.getContextId()));
        }
        Cache folderCache = this.folderCache;
        if (null == folderCache) {
            throw OXFolderExceptionCode.CACHE_NOT_ENABLED.create();
        }
        return this.putIfAbsentInternal(new InstanceFolderProvider(folderObj.clone()), ctx, elemAttribs, this.getCacheKeyUsing(ctx.getContextId(), folderObj.getObjectID(), folderCache));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FolderObject putIfAbsentInternal(FolderProvider folderProvider, Context ctx, ElementAttributes elemAttribs, CacheKey cacheKey) throws OXException {
        FolderObject retval;
        Cache folderCache = this.folderCache;
        if (null == folderCache) {
            throw OXFolderExceptionCode.CACHE_NOT_ENABLED.create();
        }
        CacheKey key = null == cacheKey ? this.getCacheKeyUsing(ctx.getContextId(), folderProvider.getObjectID(), folderCache) : cacheKey;
        LockService lockService = ServerServiceRegistry.getInstance().getService(LockService.class);
        Lock lock = null == lockService ? this.cacheLock : lockService.getSelfCleaningLockFor(new StringBuilder(32).append(REGION_NAME).append('-').append(ctx.getContextId()).append('-').append(folderProvider.getObjectID()).toString());
        lock.lock();
        try {
            Object tmp = folderCache.get((Serializable)key);
            if (tmp instanceof FolderObject) {
                retval = (FolderObject)tmp;
            } else {
                Condition cond = null;
                if (tmp instanceof Condition) {
                    cond = (Condition)tmp;
                }
                if (elemAttribs == null || folderCache.isDistributed()) {
                    folderCache.put((Serializable)key, (Serializable)folderProvider.getFolderObject(), false);
                } else {
                    folderCache.put((Serializable)key, (Serializable)folderProvider.getFolderObject(), elemAttribs, false);
                }
                if (null != cond) {
                    cond.signalAll();
                }
                retval = null;
            }
        }
        finally {
            lock.unlock();
        }
        return null == retval ? retval : retval.clone();
    }

    public void putFolderObject(FolderObject folderObj, Context ctx) throws OXException {
        this.putFolderObject(folderObj, ctx, true, null);
    }

    public void putFolderObject(FolderObject folderObj, Context ctx, boolean overwrite, ElementAttributes elemAttribs) throws OXException {
        if (!folderObj.containsObjectID()) {
            throw OXFolderExceptionCode.MISSING_FOLDER_ATTRIBUTE.create("id", Autoboxing.I((int)-1), Autoboxing.I((int)ctx.getContextId()));
        }
        this.putFolderObject(new InstanceFolderProvider(folderObj), ctx, overwrite, elemAttribs, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FolderObject putFolderObject(FolderProvider folderProvider, Context ctx, boolean overwrite, ElementAttributes elemAttribs, boolean returnFolder) throws OXException {
        Cache folderCache = this.folderCache;
        if (null == folderCache) {
            return null;
        }
        if (null != elemAttribs) {
            elemAttribs.setIsLateral(false);
        }
        CacheKey key = this.getCacheKeyUsing(ctx.getContextId(), folderProvider.getObjectID(), folderCache);
        LockService lockService = ServerServiceRegistry.getInstance().getService(LockService.class);
        Lock lock = null == lockService ? this.cacheLock : lockService.getSelfCleaningLockFor(new StringBuilder(32).append(REGION_NAME).append('-').append(ctx.getContextId()).append('-').append(folderProvider.getObjectID()).toString());
        lock.lock();
        try {
            Object currentFromCache = folderCache.get((Serializable)key);
            Condition cond = null;
            if (overwrite) {
                if (currentFromCache instanceof FolderObject) {
                    folderCache.remove((Serializable)key);
                    CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
                    if (null != cacheService) {
                        try {
                            Cache globalCache = cacheService.getCache("GlobalFolderCache");
                            CacheKey cacheKey = cacheService.newCacheKey(1, new String[]{FolderStorage.REAL_TREE_ID, String.valueOf(folderProvider.getObjectID())});
                            globalCache.removeFromGroup((Serializable)cacheKey, String.valueOf(ctx.getContextId()));
                        }
                        catch (OXException e) {
                            LOG.warn("", (Throwable)e);
                        }
                    }
                } else if (currentFromCache instanceof Condition) {
                    cond = (Condition)currentFromCache;
                }
            } else {
                if (currentFromCache instanceof FolderObject) {
                    FolderObject cacheService = returnFolder ? ((FolderObject)currentFromCache).clone() : null;
                    return cacheService;
                }
                if (currentFromCache instanceof Condition) {
                    cond = (Condition)currentFromCache;
                }
            }
            FolderObject clone = folderProvider.getFolderObject().clone();
            if (elemAttribs == null || folderCache.isDistributed()) {
                folderCache.put((Serializable)key, (Serializable)clone, false);
            } else {
                folderCache.put((Serializable)key, (Serializable)clone, elemAttribs, false);
            }
            if (null != cond) {
                cond.signalAll();
            }
            FolderObject folderObject = returnFolder ? clone : null;
            return folderObject;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFolderObject(int folderId, Context ctx) throws OXException {
        CacheService cacheService;
        Cache folderCache = this.folderCache;
        if (null == folderCache) {
            return;
        }
        if (folderId > 0) {
            CacheKey cacheKey = this.getCacheKeyUsing(ctx.getContextId(), folderId, folderCache);
            LockService lockService = ServerServiceRegistry.getInstance().getService(LockService.class);
            Lock lock = null == lockService ? this.cacheLock : lockService.getSelfCleaningLockFor(new StringBuilder(32).append(REGION_NAME).append('-').append(ctx.getContextId()).append('-').append(folderId).toString());
            lock.lock();
            try {
                Object tmp = folderCache.get((Serializable)cacheKey);
                if (!(tmp instanceof Condition)) {
                    folderCache.remove((Serializable)cacheKey);
                }
            }
            finally {
                lock.unlock();
            }
        }
        if (null != (cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class))) {
            try {
                Cache globalCache = cacheService.getCache("GlobalFolderCache");
                CacheKey cacheKey = cacheService.newCacheKey(1, new String[]{FolderStorage.REAL_TREE_ID, String.valueOf(folderId)});
                globalCache.removeFromGroup((Serializable)cacheKey, String.valueOf(ctx.getContextId()));
            }
            catch (OXException e) {
                LOG.warn("", (Throwable)e);
            }
        }
    }

    public void removeFolderObjects(int[] folderIds, Context ctx) throws OXException {
        if (folderIds == null || folderIds.length == 0) {
            return;
        }
        Cache folderCache = this.folderCache;
        if (null == folderCache) {
            return;
        }
        ArrayList<CacheKey> cacheKeys = new ArrayList<CacheKey>(folderIds.length);
        for (int key : folderIds) {
            if (key <= 0) continue;
            cacheKeys.add(this.getCacheKeyUsing(ctx.getContextId(), key, folderCache));
        }
        folderCache.remove(cacheKeys);
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        if (null != cacheService) {
            try {
                Cache globalCache = cacheService.getCache("GlobalFolderCache");
                for (int key : folderIds) {
                    CacheKey cacheKey = cacheService.newCacheKey(1, new String[]{FolderStorage.REAL_TREE_ID, String.valueOf(key)});
                    globalCache.removeFromGroup((Serializable)cacheKey, String.valueOf(ctx.getContextId()));
                }
            }
            catch (OXException e) {
                LOG.warn("", (Throwable)e);
            }
        }
    }

    public void clearAll() throws OXException {
        Cache folderCache = this.folderCache;
        if (null == folderCache) {
            return;
        }
        folderCache.clear();
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        if (null != cacheService) {
            try {
                Cache globalCache = cacheService.getCache("GlobalFolderCache");
                globalCache.clear();
            }
            catch (OXException e) {
                LOG.warn("", (Throwable)e);
            }
        }
    }

    public ElementAttributes getDefaultFolderObjectAttributes() throws OXException {
        Cache folderCache = this.folderCache;
        if (null == folderCache) {
            return null;
        }
        return folderCache.getDefaultElementAttributes();
    }

    static FolderObject loadFolderObjectInternal(int folderId, Context ctx, Connection readCon) throws OXException {
        if (folderId <= 0) {
            throw OXFolderExceptionCode.NOT_EXISTS.create(folderId, ctx.getContextId());
        }
        return FolderObject.loadFolderObjectFromDB(folderId, ctx, readCon);
    }

    private static final class LoadingFolderProvider
    implements FolderProvider {
        private final Connection readCon;
        private final int folderId;
        private final Context ctx;

        LoadingFolderProvider(int folderId, Context ctx, Connection readCon) {
            this.folderId = folderId;
            this.ctx = ctx;
            this.readCon = readCon;
        }

        @Override
        public FolderObject getFolderObject() throws OXException {
            return FolderCacheManager.loadFolderObjectInternal(this.folderId, this.ctx, this.readCon);
        }

        @Override
        public int getObjectID() {
            return this.folderId;
        }
    }

    private static final class InstanceFolderProvider
    implements FolderProvider {
        private final FolderObject folderObject;

        InstanceFolderProvider(FolderObject folderObject) {
            this.folderObject = folderObject;
        }

        @Override
        public FolderObject getFolderObject() {
            return this.folderObject;
        }

        @Override
        public int getObjectID() {
            return this.folderObject.getObjectID();
        }
    }

    private static interface FolderProvider {
        public FolderObject getFolderObject() throws OXException;

        public int getObjectID();
    }
}

