/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.responseRenderers.actions;

import com.openexchange.ajax.container.ByteArrayFileHolder;
import com.openexchange.ajax.container.FileHolder;
import com.openexchange.ajax.container.ThresholdFileHolder;
import com.openexchange.ajax.container.TmpFileFileHolder;
import com.openexchange.ajax.fileholder.IFileHolder;
import com.openexchange.ajax.helper.ImageUtils;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestDataTools;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.cache.CachedResource;
import com.openexchange.ajax.requesthandler.cache.ResourceCache;
import com.openexchange.ajax.requesthandler.cache.ResourceCaches;
import com.openexchange.ajax.requesthandler.converters.preview.AbstractPreviewResultConverter;
import com.openexchange.ajax.requesthandler.responseRenderers.FileResponseRenderer;
import com.openexchange.ajax.requesthandler.responseRenderers.actions.IDataWrapper;
import com.openexchange.ajax.requesthandler.responseRenderers.actions.IFileResponseRendererAction;
import com.openexchange.exception.OXException;
import com.openexchange.imagetransformation.BasicTransformedImage;
import com.openexchange.imagetransformation.Constants;
import com.openexchange.imagetransformation.ImageTransformationService;
import com.openexchange.imagetransformation.ImageTransformations;
import com.openexchange.imagetransformation.ScaleType;
import com.openexchange.java.Streams;
import com.openexchange.java.Strings;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.threadpool.AbstractTask;
import com.openexchange.threadpool.Task;
import com.openexchange.threadpool.ThreadPools;
import com.openexchange.tools.images.ImageTransformationUtility;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformImageAction
implements IFileResponseRendererAction {
    static final Logger LOG = LoggerFactory.getLogger(FileResponseRenderer.class);
    private final AtomicReference<ImageTransformationService> scalerReference = new AtomicReference();

    public void setScaler(ImageTransformationService scaler) {
        this.scalerReference.set(scaler);
    }

    @Override
    public void call(IDataWrapper data) throws Exception {
        IFileHolder file = this.transformIfImage(data.getRequestData(), data.getResult(), data.getFile(), data.getDelivery(), data.getTmpDirReference());
        if (null == file) {
            throw new FileResponseRenderer.FileResponseRendererActionException(404, "File not found.");
        }
        data.setFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IFileHolder transformIfImage(AJAXRequestData request, AJAXRequestResult result, IFileHolder fileHolder, String delivery, AtomicReference<File> tmpDirReference) throws IOException, OXException, FileResponseRenderer.FileResponseRendererActionException {
        Boolean compress;
        Boolean rotate;
        InputStream stream;
        String cacheKey;
        CachedResource cachedResource;
        String formatName;
        Boolean compress2;
        if (!this.isImage(fileHolder)) {
            return fileHolder;
        }
        ImageTransformationService scaler = this.scalerReference.get();
        if (null == scaler) {
            return fileHolder;
        }
        Boolean transformationNeeded = request.getParameter("transformationNeeded", Boolean.class, true);
        if (null != transformationNeeded && !transformationNeeded.booleanValue()) {
            return fileHolder;
        }
        IFileHolder file = fileHolder;
        boolean transform = false;
        if (request.isSet("cropWidth") || request.isSet("cropHeight")) {
            transform = true;
        }
        if (!transform && (request.isSet("width") || request.isSet("height"))) {
            transform = true;
        }
        if (!transform) {
            Boolean rotate2;
            Boolean bl = rotate2 = request.isSet("rotate") ? request.getParameter("rotate", Boolean.class) : null;
            if (null != rotate2 && rotate2.booleanValue()) {
                transform = true;
            }
        }
        Boolean bl = compress2 = request.isSet("compress") ? request.getParameter("compress", Boolean.class) : null;
        if (!transform && null != compress2 && compress2.booleanValue()) {
            transform = true;
        }
        if (!transform && ("jpeg".equals(formatName = Strings.toLowerCase((CharSequence)ImageTransformationUtility.getImageFormat(file.getContentType()))) || "jpg".equals(formatName)) && !"download".equalsIgnoreCase(delivery)) {
            InputStream stream2;
            if (!file.repetitive()) {
                file = new ThresholdFileHolder(file);
            }
            if (null == (stream2 = file.getStream())) {
                LOG.warn("(Possible) Image file misses stream data");
                return file;
            }
            try {
                if (ImageTransformationUtility.requiresRotateTransformation(stream2)) {
                    transform = true;
                }
            }
            finally {
                Streams.close((Closeable)stream2);
            }
        }
        if (!transform) {
            return file;
        }
        final ServerSession session = request.getSession();
        if (null == session) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create("session");
        }
        ResourceCache tmp = ResourceCaches.getResourceCache();
        final ResourceCache resourceCache = null == tmp ? null : (tmp.isEnabledFor(session.getContextId(), session.getUserId()) ? tmp : null);
        String eTag = result.getHeader("ETag");
        boolean isValidEtag = !Strings.isEmpty((String)eTag);
        String previewLanguage = AbstractPreviewResultConverter.getUserLanguage(session);
        if (null != resourceCache && isValidEtag && AJAXRequestDataTools.parseBoolParameter("cache", request, true) && null != (cachedResource = resourceCache.get(cacheKey = ResourceCaches.generatePreviewCacheKey(eTag, request, previewLanguage), 0, session.getContextId()))) {
            Object ret;
            InputStream inputStream;
            String contentType = cachedResource.getFileType();
            if (null == contentType) {
                contentType = "image/jpeg";
            }
            if (null == (inputStream = cachedResource.getInputStream())) {
                ByteArrayFileHolder responseFileHolder = new ByteArrayFileHolder(cachedResource.getBytes());
                responseFileHolder.setContentType(contentType);
                responseFileHolder.setName(cachedResource.getFileName());
                ret = responseFileHolder;
            } else {
                ret = new FileHolder(inputStream, cachedResource.getSize(), contentType, cachedResource.getFileName());
            }
            return ret;
        }
        if (!file.repetitive()) {
            ThresholdFileHolder tmp2 = new ThresholdFileHolder(file);
            file.close();
            file = tmp2;
        }
        if (null == (stream = file.getStream())) {
            LOG.warn("(Possible) Image file misses stream data");
            return file;
        }
        if (ImageUtils.isAnimatedGif(stream)) {
            return fileHolder;
        }
        ImageTransformations transformations = scaler.transfom(file, (Object)session.getSessionID());
        Boolean bl2 = rotate = request.isSet("rotate") ? request.getParameter("rotate", Boolean.class) : null;
        if (null == rotate && !"download".equalsIgnoreCase(delivery) || null != rotate && rotate.booleanValue()) {
            transformations.rotate();
        }
        if (request.isSet("cropWidth") || request.isSet("cropHeight")) {
            int cropX = this.optIntParameter(request, "cropX");
            int cropY = this.optIntParameter(request, "cropY");
            int cropWidth = this.optIntParameter(request, "cropWidth");
            int cropHeight = this.optIntParameter(request, "cropHeight");
            transformations.crop(cropX, cropY, cropWidth, cropHeight);
        }
        if (request.isSet("width") || request.isSet("height")) {
            int maxWidth = this.optIntParameter(request, "width");
            if (maxWidth > Constants.getMaxWidth()) {
                throw AjaxExceptionCodes.BAD_REQUEST.create("Width " + maxWidth + " exceeds max. supported width " + Constants.getMaxWidth());
            }
            int maxHeight = this.optIntParameter(request, "height");
            if (maxHeight > Constants.getMaxHeight()) {
                throw AjaxExceptionCodes.BAD_REQUEST.create("Height " + maxHeight + " exceeds max. supported height " + Constants.getMaxHeight());
            }
            ScaleType scaleType = ScaleType.getType((String)request.getParameter("scaleType"));
            try {
                transformations.scale(maxWidth, maxHeight, scaleType);
            }
            catch (IllegalArgumentException e) {
                throw AjaxExceptionCodes.BAD_REQUEST_CUSTOM.create(e, e.getMessage());
            }
        }
        Boolean bl3 = compress = request.isSet("compress") ? request.getParameter("compress", Boolean.class) : null;
        if (null == compress && !"download".equalsIgnoreCase(delivery) || null != compress && compress.booleanValue()) {
            transformations.compress();
        }
        boolean cachingAdvised = false;
        try {
            Object imageFile;
            BasicTransformedImage transformedImage;
            String contentTypeByFileName;
            String fileContentType = file.getContentType();
            if (!(null != fileContentType && Strings.toLowerCase((CharSequence)fileContentType).startsWith("image/") || null == (contentTypeByFileName = FileResponseRenderer.getContentTypeByFileName(file.getName())))) {
                fileContentType = contentTypeByFileName;
            }
            try {
                transformedImage = transformations.getTransformedImage(fileContentType);
                if (null == transformedImage) {
                    return file.repetitive() ? file : null;
                }
                int expenses = transformedImage.getTransformationExpenses();
                if (expenses >= 3) {
                    cachingAdvised = true;
                }
            }
            catch (IOException ioe) {
                if ("Unsupported Image Type".equals(ioe.getMessage())) {
                    return this.handleFailure(file);
                }
                throw ioe;
            }
            ThresholdFileHolder optImageFileHolder = null;
            IFileHolder fh = transformedImage.getImageFile();
            if (null != fh) {
                optImageFileHolder = (ThresholdFileHolder)fh;
            }
            final int size = (int)transformedImage.getSize();
            final String contentType = fileContentType;
            final String fileName = file.getName();
            if (cachingAdvised && null != resourceCache && isValidEtag && AJAXRequestDataTools.parseBoolParameter("cache", request, true)) {
                File imgFile;
                File tempFile;
                final String cacheKey2 = ResourceCaches.generatePreviewCacheKey(eTag, request, previewLanguage);
                File file2 = tempFile = null == optImageFileHolder ? null : optImageFileHolder.getTempFile();
                if (null != tempFile) {
                    File newTempFile = TmpFileFileHolder.newTempFile(false);
                    FileUtils.copyFile((File)tempFile, (File)newTempFile, (boolean)false);
                    tempFile = newTempFile;
                }
                final byte[] bytes = null == (imgFile = tempFile) ? (null == optImageFileHolder ? transformedImage.getImageData() : optImageFileHolder.toByteArray()) : null;
                AbstractTask<Void> task = new AbstractTask<Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Void call() {
                        try {
                            CachedResource preview = null != imgFile ? new CachedResource(new FileInputStream(imgFile), fileName, contentType, (long)size) : new CachedResource(bytes, fileName, contentType, (long)size);
                            resourceCache.save(cacheKey2, preview, 0, session.getContextId());
                        }
                        catch (Exception e) {
                            LOG.warn("Could not cache preview.", (Throwable)e);
                        }
                        finally {
                            if (null != imgFile) {
                                imgFile.delete();
                            }
                        }
                        return null;
                    }
                };
                ThreadPools.submitElseExecute((Task)task);
            }
            if (null == optImageFileHolder) {
                TransformedImageInputStreamClosure closure = new TransformedImageInputStreamClosure(transformedImage);
                imageFile = new FileHolder(closure, (long)size, contentType, fileName);
            } else {
                optImageFileHolder.setName(fileName);
                optImageFileHolder.setContentType(contentType);
                imageFile = optImageFileHolder;
            }
            Streams.close((Closeable)file);
            return imageFile;
        }
        catch (RuntimeException e) {
            IFileHolder returnValue;
            if (LOG.isDebugEnabled() && file.repetitive()) {
                try {
                    File tmpFile = this.writeBrokenImage2Disk(file, tmpDirReference);
                    LOG.error("Unable to transform image from {}. Unparseable image file is written to disk at: {}", new Object[]{file.getName(), tmpFile.getPath(), e});
                }
                catch (Exception x) {
                    LOG.error("Unable to transform image from {}", (Object)file.getName(), (Object)e);
                }
            } else {
                LOG.error("Unable to transform image from {}", (Object)file.getName(), (Object)e);
            }
            Object object = returnValue = file.repetitive() ? file : null;
            if (returnValue == null) {
                throw new FileResponseRenderer.FileResponseRendererActionException(404, "File not found.");
            }
            return returnValue;
        }
    }

    private int optIntParameter(AJAXRequestData request, String name) throws OXException {
        if (request.isSet(name)) {
            Integer integer = request.getParameter(name, Integer.TYPE);
            return null != integer ? integer : 0;
        }
        return 0;
    }

    private boolean isImage(IFileHolder file) {
        String fileName;
        if (0L == file.getLength()) {
            return false;
        }
        String contentType = file.getContentType();
        return null != contentType && contentType.startsWith("image/") || (fileName = file.getName()) != null && (contentType = MimeType2ExtMap.getContentType(fileName)).startsWith("image/");
    }

    private IFileHolder handleFailure(IFileHolder file) {
        LOG.warn("Unable to transform image from {}", (Object)file.getName());
        return file.repetitive() ? file : null;
    }

    private File writeBrokenImage2Disk(IFileHolder file, AtomicReference<File> tmpDirReference) throws IOException, OXException, FileNotFoundException {
        String contentType;
        int pos;
        String suffix = null;
        String name = file.getName();
        if (null != name && (pos = name.lastIndexOf(46)) > 0 && pos < name.length() - 1) {
            suffix = name.substring(pos);
        }
        if (null == suffix && null != (contentType = file.getContentType())) {
            suffix = "." + MimeType2ExtMap.getFileExtension(contentType);
        }
        return this.write2Disk(file, "brokenimage-", suffix, tmpDirReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File write2Disk(IFileHolder file, String prefix, String suffix, AtomicReference<File> tmpDirReference) throws IOException, OXException, FileNotFoundException {
        File directory = tmpDirReference.get();
        File newFile = File.createTempFile(null == prefix ? "open-xchange-" : prefix, null == suffix ? ".tmp" : suffix, directory);
        InputStream is = file.getStream();
        FileOutputStream out = new FileOutputStream(newFile);
        try {
            int read;
            int len = 8192;
            byte[] buf = new byte[8192];
            while ((read = is.read(buf, 0, 8192)) > 0) {
                ((OutputStream)out).write(buf, 0, read);
            }
            out.flush();
        }
        catch (Throwable throwable) {
            Streams.close((Closeable[])new Closeable[]{is, out});
            throw throwable;
        }
        Streams.close((Closeable[])new Closeable[]{is, out});
        return newFile;
    }

    private final class TransformedImageInputStreamClosure
    implements IFileHolder.InputStreamClosure {
        private final BasicTransformedImage transformedImage;

        TransformedImageInputStreamClosure(BasicTransformedImage transformedImage) {
            this.transformedImage = transformedImage;
        }

        public InputStream newStream() throws OXException, IOException {
            return this.transformedImage.getImageStream();
        }
    }
}

