/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.responseRenderers.actions;

import com.openexchange.ajax.AJAXUtility;
import com.openexchange.ajax.container.ThresholdFileHolder;
import com.openexchange.ajax.fileholder.IFileHolder;
import com.openexchange.ajax.fileholder.Readable;
import com.openexchange.ajax.helper.DownloadUtility;
import com.openexchange.ajax.requesthandler.responseRenderers.FileResponseRenderer;
import com.openexchange.ajax.requesthandler.responseRenderers.actions.IDataWrapper;
import com.openexchange.ajax.requesthandler.responseRenderers.actions.IFileResponseRendererAction;
import com.openexchange.exception.OXException;
import com.openexchange.java.HTMLDetector;
import com.openexchange.java.Strings;
import com.openexchange.mail.mime.ContentType;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareResponseHeaderAction
implements IFileResponseRendererAction {
    private static final Logger LOG = LoggerFactory.getLogger(FileResponseRenderer.class);

    @Override
    public void call(IDataWrapper data) throws OXException, IOException {
        if ("download".equalsIgnoreCase(data.getDelivery()) || "application/octet-stream".equals(data.getContentType()) && !"view".equalsIgnoreCase(data.getDelivery())) {
            StringBuilder sb = new StringBuilder(32);
            sb.append(Strings.isEmpty((String)data.getContentDisposition()) ? "attachment" : this.checkedContentDisposition(data.getContentDisposition().trim(), data.getFile()));
            DownloadUtility.appendFilenameParameter(data.getFileName(), null, data.getUserAgent(), sb);
            data.getResponse().setHeader("Content-Disposition", sb.toString());
            data.getResponse().setContentType("application/octet-stream");
            data.setLength(data.getFile().getLength());
            this.setContentLengthHeader(data.getLength(), data.getResponse());
        } else {
            String cts;
            String contentTypeByFileName = FileResponseRenderer.getContentTypeByFileName(data.getFileName());
            long fileLength = data.getFile().getLength();
            if (null == data.getFileContentType() || "application/octet-stream".equals(data.getFileContentType())) {
                if (null == contentTypeByFileName) {
                    ThresholdFileHolder temp = new ThresholdFileHolder(0x100000, 8192);
                    data.addCloseable((Closeable)((Object)temp));
                    temp.write(data.getDocumentData());
                    fileLength = temp.getLength();
                    data.setDocumentData((Readable)temp.getClosingRandomAccess());
                    cts = this.detectMimeType(temp.getStream());
                    if ("text/plain".equals(cts)) {
                        cts = HTMLDetector.containsHTMLTags((InputStream)temp.getStream(), (boolean)true) ? "text/html" : cts;
                    }
                } else {
                    cts = contentTypeByFileName;
                }
            } else if (null != contentTypeByFileName && !this.equalPrimaryTypes(data.getFileContentType(), contentTypeByFileName)) {
                ThresholdFileHolder temp = new ThresholdFileHolder(0x100000, 8192);
                data.addCloseable((Closeable)((Object)temp));
                temp.write(data.getDocumentData());
                fileLength = temp.getLength();
                data.setDocumentData((Readable)temp.getClosingRandomAccess());
                cts = this.detectMimeType(temp.getStream());
                if ("text/plain".equals(cts)) {
                    cts = HTMLDetector.containsHTMLTags((InputStream)temp.getStream(), (boolean)true) ? "text/html" : cts;
                }
            } else {
                cts = data.getFileContentType();
            }
            DownloadUtility.CheckedDownload checkedDownload = DownloadUtility.checkInlineDownload(data.getDocumentData(), fileLength, data.getFileName(), cts, data.getContentDisposition(), data.getUserAgent(), data.getRequestData().getSession());
            data.setDocumentData(checkedDownload.getInputStream());
            if (data.getDelivery() == null || !data.getDelivery().equalsIgnoreCase("view")) {
                if (Strings.isEmpty((String)data.getContentDisposition())) {
                    data.getResponse().setHeader("Content-Disposition", checkedDownload.getContentDisposition());
                } else if (data.getContentDisposition().indexOf(59) >= 0) {
                    data.getResponse().setHeader("Content-Disposition", data.getContentDisposition().trim());
                } else {
                    String disposition = checkedDownload.getContentDisposition();
                    int pos = disposition.indexOf(59);
                    if (pos >= 0) {
                        data.getResponse().setHeader("Content-Disposition", data.getContentDisposition().trim() + disposition.substring(pos));
                    } else {
                        data.getResponse().setHeader("Content-Disposition", data.getContentDisposition().trim());
                    }
                }
            } else if (checkedDownload.isAttachment()) {
                data.getResponse().setHeader("Content-Disposition", checkedDownload.getContentDisposition());
            } else if (data.getDelivery().equalsIgnoreCase("view") && null != data.getFileName()) {
                StringBuilder sb = new StringBuilder(32);
                sb.append("inline");
                DownloadUtility.appendFilenameParameter(data.getFileName(), null, data.getUserAgent(), sb);
                data.getResponse().setHeader("Content-Disposition", sb.toString());
            }
            data.setLength(checkedDownload.getSize());
            this.setContentLengthHeader(data.getLength(), data.getResponse());
            String preferredContentType = checkedDownload.getContentType();
            if (!(null == contentTypeByFileName || checkedDownload.isAttachment() || !preferredContentType.startsWith("application/octet-stream") && this.equalPrimaryTypes(preferredContentType, contentTypeByFileName))) {
                try {
                    ContentType tmp = new ContentType(preferredContentType);
                    tmp.setBaseType(contentTypeByFileName);
                    preferredContentType = tmp.toString();
                }
                catch (Exception e) {
                    preferredContentType = contentTypeByFileName;
                }
            }
            if (!data.getContentTypeByParameter().booleanValue() || data.getContentType() == null || "application/octet-stream".equals(data.getContentType())) {
                data.getResponse().setContentType(preferredContentType);
                data.setContentType(preferredContentType);
            } else if ("application/octet-stream".equals(preferredContentType) || this.equalPrimaryTypes(preferredContentType, data.getContentType())) {
                if (!this.trySetSanitizedContentType(data.getContentType(), preferredContentType, data.getResponse())) {
                    data.setContentType(preferredContentType);
                }
            } else {
                ThresholdFileHolder temp = new ThresholdFileHolder(0x100000, 8192);
                data.addCloseable((Closeable)((Object)temp));
                temp.write(data.getDocumentData());
                data.setDocumentData((Readable)temp.getClosingRandomAccess());
                preferredContentType = this.detectMimeType(temp.getStream());
                if ("text/plain".equals(preferredContentType)) {
                    String string = preferredContentType = HTMLDetector.containsHTMLTags((InputStream)temp.getStream(), (boolean)true) ? "text/html" : preferredContentType;
                }
                if (this.equalPrimaryTypes(preferredContentType, data.getContentType())) {
                    if (!this.trySetSanitizedContentType(data.getContentType(), preferredContentType, data.getResponse())) {
                        data.setContentType(preferredContentType);
                    }
                } else {
                    StringBuilder sb = new StringBuilder(128);
                    sb.append("Denied parameter \"").append("content_type");
                    sb.append("\" due to security constraints (requested \"");
                    sb.append(data.getContentType()).append("\" , but is \"").append(preferredContentType).append("\").");
                    LOG.warn(sb.toString());
                    data.getResponse().setContentType(preferredContentType);
                    data.setContentType(preferredContentType);
                }
            }
        }
    }

    private String checkedContentDisposition(String contentDisposition, IFileHolder file) {
        String ct = Strings.toLowerCase((CharSequence)file.getContentType());
        if (null == ct || ct.startsWith("text/htm")) {
            int pos = contentDisposition.indexOf(59);
            return pos > 0 ? "attachment" + contentDisposition.substring(pos) : "attachment";
        }
        return contentDisposition;
    }

    private void setContentLengthHeader(long length, HttpServletResponse resp) {
        if (length > 0L) {
            resp.setHeader("Accept-Ranges", "bytes");
            resp.setHeader("Content-Length", Long.toString(length));
        } else {
            resp.setHeader("Accept-Ranges", "none");
        }
    }

    private String detectMimeType(InputStream in) throws IOException {
        return AJAXUtility.detectMimeType(in);
    }

    private boolean equalPrimaryTypes(String contentType1, String contentType2) {
        if (null == contentType1 || null == contentType2) {
            return false;
        }
        return Strings.toLowerCase((CharSequence)this.getPrimaryType(contentType1)).startsWith(Strings.toLowerCase((CharSequence)this.getPrimaryType(contentType2)));
    }

    private String getPrimaryType(String contentType) {
        if (Strings.isEmpty((String)contentType)) {
            return contentType;
        }
        int pos = contentType.indexOf(47);
        return pos > 0 ? contentType.substring(0, pos) : contentType;
    }

    private boolean trySetSanitizedContentType(String contentType, String fallbackContentType, HttpServletResponse resp) {
        try {
            resp.setContentType(new ContentType(contentType).getBaseType());
            return true;
        }
        catch (Exception e) {
            resp.setContentType(fallbackContentType);
            return false;
        }
    }
}

