/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.customizer;

import com.openexchange.ajax.requesthandler.AJAXActionCustomizer;
import com.openexchange.ajax.requesthandler.AJAXActionCustomizerFactory;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.Converter;
import com.openexchange.exception.OXException;
import com.openexchange.tools.session.ServerSession;

public class ConversionCustomizer
implements AJAXActionCustomizer,
AJAXActionCustomizerFactory {
    private final Converter converter;

    public ConversionCustomizer(Converter converter) {
        this.converter = converter;
    }

    @Override
    public AJAXRequestData incoming(AJAXRequestData requestData, ServerSession session) throws OXException {
        return requestData;
    }

    @Override
    public AJAXRequestResult outgoing(AJAXRequestData requestData, AJAXRequestResult result, ServerSession session) throws OXException {
        String requestedFormat = requestData.getFormat();
        String currentFormat = result.getFormat();
        if (currentFormat.equals(requestedFormat)) {
            return result;
        }
        if (result.getType() == AJAXRequestResult.ResultType.HTTP_ERROR) {
            return result;
        }
        this.converter.convert(currentFormat, requestedFormat, requestData, result, session);
        return result;
    }

    @Override
    public AJAXActionCustomizer createCustomizer(AJAXRequestData request, ServerSession session) {
        return this;
    }
}

